/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.block.entity;

import javax.annotation.Nullable;
import me.dantaeusb.zetter.block.entity.container.ArtistTableContainer;
import me.dantaeusb.zetter.core.ItemStackHandlerListener;
import me.dantaeusb.zetter.core.ZetterBlockEntities;
import me.dantaeusb.zetter.menu.ArtistTableMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ArtistTableBlockEntity
extends BlockEntity
implements ItemStackHandlerListener,
MenuProvider {
    private static final String ARTIST_TABLE_CANVAS_STORAGE_TAG = "canvas_storage";
    protected ArtistTableContainer artistTableContainer;
    protected final LazyOptional<ItemStackHandler> artistTableContainerOptional = LazyOptional.of(() -> this.artistTableContainer);

    public ArtistTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ZetterBlockEntities.ARTIST_TABLE_BLOCK_ENTITY.get(), pos, state);
        this.createInventory();
    }

    protected void createInventory() {
        ArtistTableContainer currentArtistTableContainer = this.artistTableContainer;
        this.artistTableContainer = new ArtistTableContainer(this);
        if (currentArtistTableContainer != null) {
            int i = Math.min(currentArtistTableContainer.getSlots(), this.artistTableContainer.getSlots());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = currentArtistTableContainer.getStackInSlot(j);
                if (itemstack.m_41619_()) continue;
                this.artistTableContainer.setStackInSlot(j, itemstack.m_41777_());
            }
        }
    }

    public boolean canPlayerAccessInventory(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    @Override
    public void containerChanged(ItemStackHandler container) {
        this.m_6596_();
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_(), this.m_58899_().m_142082_(1, 1, 1));
    }

    public void m_183515_(CompoundTag compoundTag) {
        CompoundTag canvasNbt = this.artistTableContainer.serializeNBT();
        compoundTag.m_128365_(ARTIST_TABLE_CANVAS_STORAGE_TAG, (Tag)canvasNbt);
    }

    public void m_142466_(CompoundTag parentNBTTagCompound) {
        super.m_142466_(parentNBTTagCompound);
        CompoundTag canvasNbt = parentNBTTagCompound.m_128469_(ARTIST_TABLE_CANVAS_STORAGE_TAG);
        this.artistTableContainer.deserializeNBT(canvasNbt);
        if (this.artistTableContainer.getSlots() != 16) {
            throw new IllegalArgumentException("Corrupted NBT: Number of inventory slots did not match expected.");
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(packet.m_131708_());
    }

    public CompoundTag m_5995_() {
        CompoundTag nbtTagCompound = new CompoundTag();
        this.m_183515_(nbtTagCompound);
        return nbtTagCompound;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public void dropAllContents(Level world, BlockPos blockPos) {
        for (int i = 0; i < this.artistTableContainer.getSlots(); ++i) {
            Containers.m_18992_((Level)this.f_58857_, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), (ItemStack)this.artistTableContainer.getStackInSlot(i));
        }
    }

    public Component m_5446_() {
        return new TranslatableComponent("container.zetter.artistTable");
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction direction) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (direction == null || direction == Direction.UP || direction == Direction.DOWN)) {
            return this.artistTableContainerOptional.cast();
        }
        return super.getCapability(capability, direction);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowID, Inventory playerInventory, Player playerEntity) {
        return ArtistTableMenu.createMenuServerSide(windowID, playerInventory, this.artistTableContainer);
    }
}

