/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.gui.painting;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.client.gui.PaintingScreen;
import me.dantaeusb.zetter.client.gui.painting.AbstractPaintingWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.StringUtil;

public class ColorCodeWidget
extends AbstractPaintingWidget
implements Widget {
    static final int TEXTBOX_WIDTH = 82;
    static final int TEXTBOX_HEIGHT = 16;
    static final int TEXTBOX_TEXT_OFFSET = 8;
    private static final Pattern HEX_COLOR_PATTERN = Pattern.compile("\\p{XDigit}{1,6}");
    private static final Pattern HEX_COLOR_STRICT_PATTERN = Pattern.compile("(\\p{XDigit}{3}|\\p{XDigit}{6})");
    EditBox textField;
    Predicate<String> hexColorValidator = text -> {
        if (StringUtil.m_14408_((String)text)) {
            return true;
        }
        Matcher matcher = HEX_COLOR_PATTERN.matcher((CharSequence)text);
        return matcher.matches();
    };

    public ColorCodeWidget(PaintingScreen parentScreen, int x, int y) {
        super(parentScreen, x, y, 82, 16, (Component)new TranslatableComponent("container.zetter.painting.color_code"));
    }

    @Override
    @Nullable
    public Component getTooltip(int mouseX, int mouseY) {
        return null;
    }

    public void initFields() {
        this.textField = new EditBox(this.parentScreen.getFont(), this.f_93620_ + 8 + 4, this.f_93621_ + 4, 75, 12, (Component)new TranslatableComponent("container.zetter.easel"));
        this.textField.m_94190_(false);
        this.textField.m_94202_(-1);
        this.textField.m_94205_(-1);
        this.textField.m_94182_(false);
        this.textField.m_94199_(32);
        this.textField.m_94151_(this::applyColor);
        this.textField.m_94153_(this.hexColorValidator);
        this.parentScreen.pipeWidget(this.textField);
    }

    public void tick() {
        this.textField.m_94120_();
    }

    public void updateColorValue(int color) {
        this.textField.m_94144_(Integer.toHexString(color &= 0xFFFFFF));
    }

    private void applyColor(String text) {
        Matcher matcher = HEX_COLOR_STRICT_PATTERN.matcher(text);
        if (!matcher.matches()) {
            return;
        }
        try {
            if (text.length() == 3) {
                StringBuilder longText = new StringBuilder();
                for (int i = 0; i < 3; ++i) {
                    longText.append(text.charAt(i));
                    longText.append(text.charAt(i));
                }
                text = longText.toString();
            }
            int color = Integer.parseInt(text, 16) | 0xFF000000;
            this.parentScreen.updateCurrentPaletteColor(color);
            this.parentScreen.pushPaletteUpdateColor();
        }
        catch (NumberFormatException exception) {
            Zetter.LOG.error("Invalid color number");
            return;
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.textField.m_93696_()) {
            return this.textField.m_7933_(keyCode, scanCode, modifiers) || this.textField.m_94204_();
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int iMouseX = (int)mouseX;
        int iMouseY = (int)mouseY;
        if (PaintingScreen.isInRect(this.f_93620_, this.f_93621_, 82, 16, iMouseX, iMouseY)) {
            this.textField.m_94178_(true);
            return super.m_6375_(mouseX, mouseY, button);
        }
        this.textField.m_94178_(false);
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        return this.textField.m_5534_(codePoint, modifiers);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.drawTextbox(matrixStack);
        this.textField.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected void drawTextbox(PoseStack matrixStack) {
        boolean TEXTBOX_POSITION_U = false;
        int TEXTBOX_POSITION_V = 185;
        int textboxV = 185 + (this.textField.m_93696_() ? 16 : 0);
        this.m_93228_(matrixStack, this.f_93620_, this.f_93621_, 0, textboxV, 82, 16);
    }
}

