/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.renderer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.core.ZetterNetwork;
import me.dantaeusb.zetter.network.packet.CCanvasRequestPacket;
import me.dantaeusb.zetter.network.packet.CCanvasUnloadRequestPacket;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import me.dantaeusb.zetter.storage.CanvasData;
import net.minecraft.client.Timer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CanvasRenderer
implements AutoCloseable {
    private static CanvasRenderer instance;
    private final TextureManager textureManager;
    private final Map<String, Instance> canvasRendererInstances = Maps.newHashMap();
    private final Timer timer = new Timer(20.0f, 0L);
    private final Map<String, Integer> ticksSinceRenderRequested = Maps.newHashMap();
    private final Map<String, TextureRequest> textureRequestTimeout = Maps.newHashMap();

    public CanvasRenderer(TextureManager textureManager) {
        this.textureManager = textureManager;
        instance = this;
    }

    public static CanvasRenderer getInstance() {
        return instance;
    }

    public void updateCanvasTexture(String canvasCode, CanvasData canvas) {
        this.getCanvasRendererInstance(canvasCode, canvas, true).updateCanvasTexture(canvas);
    }

    public void addCanvas(String canvasCode, AbstractCanvasData canvasData) {
        this.canvasRendererInstances.remove(canvasCode);
        this.createCanvasRendererInstance(canvasCode, canvasData);
    }

    public void renderCanvas(PoseStack matrixStack, MultiBufferSource renderTypeBuffer, String canvasCode, AbstractCanvasData canvas, int combinedLight) {
        Instance rendererInstance;
        if (canvasCode.equals(CanvasData.getCanvasCode(0))) {
            return;
        }
        if (canvas.isManaged()) {
            this.ticksSinceRenderRequested.put(canvasCode, 0);
        }
        if ((rendererInstance = this.getCanvasRendererInstance(canvasCode, canvas, false)) == null) {
            this.queueCanvasTextureUpdate(canvas.getType(), canvasCode);
            return;
        }
        rendererInstance.render(matrixStack, renderTypeBuffer, combinedLight);
    }

    public void update(long gameTime) {
        int partialTicks = this.timer.m_92525_(gameTime);
        if (partialTicks > 0) {
            this.updateTicksSinceRender(partialTicks);
            this.updateTextureRequestTimeout(partialTicks);
        }
    }

    private void updateTicksSinceRender(int partialTicks) {
        Iterator<Map.Entry<String, Integer>> iterator = this.ticksSinceRenderRequested.entrySet().iterator();
        while (iterator.hasNext()) {
            String canvasCode = iterator.next().getKey();
            int timeSinceRenderRequested = this.ticksSinceRenderRequested.getOrDefault(canvasCode, 0);
            if ((float)(timeSinceRenderRequested += partialTicks) < 3600.0f) {
                this.ticksSinceRenderRequested.put(canvasCode, timeSinceRenderRequested);
                continue;
            }
            this.unloadCanvas(canvasCode);
            iterator.remove();
        }
    }

    private void updateTextureRequestTimeout(int partialTicks) {
        for (Map.Entry<String, TextureRequest> textureRequestEntry : this.textureRequestTimeout.entrySet()) {
            if (textureRequestEntry.getKey().equals("zetter_fallback_canvas")) continue;
            TextureRequest textureRequest = textureRequestEntry.getValue();
            if (textureRequest.canUpdate()) {
                this.requestCanvasTexture(textureRequest);
                continue;
            }
            textureRequest.tick(partialTicks);
        }
    }

    public void unloadCanvas(String canvasCode) {
        Zetter.LOG.debug("Unloading canvas " + canvasCode);
        this.canvasRendererInstances.remove(canvasCode);
        this.textureRequestTimeout.remove(canvasCode);
        CCanvasUnloadRequestPacket unloadPacket = new CCanvasUnloadRequestPacket(canvasCode);
        ZetterNetwork.simpleChannel.sendToServer((Object)unloadPacket);
    }

    public void queueCanvasTextureUpdate(AbstractCanvasData.Type type, String canvasCode) {
        if (canvasCode == null) {
            Zetter.LOG.debug("Tried to queue null canvas");
            return;
        }
        if (type == AbstractCanvasData.Type.DUMMY) {
            Zetter.LOG.debug("Tried to queue dummy canvas");
            return;
        }
        if (this.textureRequestTimeout.containsKey(canvasCode)) {
            TextureRequest textureRequest = this.textureRequestTimeout.get(canvasCode);
            if (textureRequest.isNeedUpdate()) {
                return;
            }
            textureRequest.markDirty();
        } else {
            this.textureRequestTimeout.put(canvasCode, new TextureRequest(type, canvasCode));
        }
    }

    protected void requestCanvasTexture(TextureRequest request) {
        CCanvasRequestPacket requestSyncPacket = new CCanvasRequestPacket(request.getCanvasType(), request.getCanvasCode());
        ZetterNetwork.simpleChannel.sendToServer((Object)requestSyncPacket);
        request.update();
    }

    @Nullable
    private Instance getCanvasRendererInstance(String canvasCode, AbstractCanvasData canvasData, boolean create) {
        Instance canvasRendererInstance = this.canvasRendererInstances.get(canvasCode);
        if (create && canvasRendererInstance == null) {
            this.createCanvasRendererInstance(canvasCode, canvasData);
        }
        return canvasRendererInstance;
    }

    private void createCanvasRendererInstance(String canvasCode, AbstractCanvasData canvas) {
        Instance canvasRendererInstance = new Instance(canvasCode, canvas.getWidth(), canvas.getHeight(), canvas.getResolution());
        canvasRendererInstance.updateCanvasTexture(canvas);
        this.canvasRendererInstances.put(canvasCode, canvasRendererInstance);
    }

    public void clearLoadedCanvases() {
        for (Instance canvasRendererInstance : this.canvasRendererInstances.values()) {
            canvasRendererInstance.close();
        }
        this.canvasRendererInstances.clear();
    }

    @Override
    public void close() {
        this.clearLoadedCanvases();
    }

    @OnlyIn(value=Dist.CLIENT)
    class Instance
    implements AutoCloseable {
        private final String code;
        private final DynamicTexture canvasTexture;
        private final RenderType renderType;
        private final int width;
        private final int height;
        private final int blockPixelWidth;
        private final int blockPixelHeight;

        private Instance(String canvasCode, int width, int height, AbstractCanvasData.Resolution resolution) {
            this.code = canvasCode;
            this.canvasTexture = new DynamicTexture(width, height, true);
            ResourceLocation dynamicTextureLocation = CanvasRenderer.this.textureManager.m_118490_("canvas/" + canvasCode, this.canvasTexture);
            this.renderType = RenderType.m_110497_((ResourceLocation)dynamicTextureLocation);
            this.width = width;
            this.height = height;
            int downScale = resolution.getNumeric() / Helper.getBasicResolution().getNumeric();
            this.blockPixelWidth = width / downScale;
            this.blockPixelHeight = height / downScale;
        }

        private void updateCanvasTexture(AbstractCanvasData canvas) {
            for (int pixelY = 0; pixelY < canvas.getHeight(); ++pixelY) {
                for (int pixelX = 0; pixelX < canvas.getWidth(); ++pixelX) {
                    int color = canvas.getColorAt(pixelX, pixelY);
                    this.canvasTexture.m_117991_().m_84988_(pixelX, pixelY, this.ARGBtoABGR(color));
                }
            }
            this.canvasTexture.m_117985_();
        }

        private int ARGBtoABGR(int x) {
            return x & 0xFF000000 | (x & 0xFF0000) >> 16 | x & 0xFF00 | (x & 0xFF) << 16;
        }

        private void render(PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int combinedLight) {
            Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
            VertexConsumer ivertexbuilder = renderTypeBuffer.m_6299_(this.renderType);
            ivertexbuilder.m_85982_(matrix4f, 0.0f, (float)this.blockPixelHeight, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_85969_(combinedLight).m_5752_();
            ivertexbuilder.m_85982_(matrix4f, (float)this.blockPixelWidth, (float)this.blockPixelHeight, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_85969_(combinedLight).m_5752_();
            ivertexbuilder.m_85982_(matrix4f, (float)this.blockPixelWidth, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_85969_(combinedLight).m_5752_();
            ivertexbuilder.m_85982_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_85969_(combinedLight).m_5752_();
        }

        @Override
        public void close() {
            this.canvasTexture.close();
        }
    }

    static class TextureRequest {
        private final int TEXTURE_REQUEST_TIMEOUT = 20;
        private final AbstractCanvasData.Type type;
        private final String code;
        private boolean needUpdate = true;
        private int timeout = 0;

        TextureRequest(AbstractCanvasData.Type type, String canvasCode) {
            this.type = type;
            this.code = canvasCode;
        }

        public void markDirty() {
            this.needUpdate = true;
        }

        public boolean isNeedUpdate() {
            return this.needUpdate;
        }

        public void update() {
            this.needUpdate = false;
            this.timeout = 20;
        }

        public String getCanvasCode() {
            return this.code;
        }

        public AbstractCanvasData.Type getCanvasType() {
            return this.type;
        }

        public void tick(int ticks) {
            if (!this.needUpdate && this.timeout <= 0) {
                return;
            }
            this.timeout -= ticks;
        }

        public boolean canUpdate() {
            return this.needUpdate && this.timeout < 0;
        }
    }
}

