/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.canvastracker.ICanvasTracker;
import me.dantaeusb.zetter.client.renderer.CanvasRenderer;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.entity.item.CustomPaintingEntity;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import me.dantaeusb.zetter.storage.PaintingData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class CustomPaintingRenderer
extends EntityRenderer<CustomPaintingEntity> {
    public static ModelLayerLocation PAINTING_PLATE_LAYER = new ModelLayerLocation(new ResourceLocation("zetter", "custom_painting"), "plate_layer");
    public static final String[] MODEL_CODES = new String[]{"1x1", "top_left", "top", "top_right", "left", "right", "bottom_left", "bottom", "bottom_right", "top_u", "bottom_u", "left_u", "right_u", "center", "center_horizontal", "center_vertical"};
    public static final HashMap<String, ModelResourceLocation> FRAME_MODELS = new HashMap();
    public static final HashMap<String, ResourceLocation> PLATE_TEXTURES = new HashMap();
    private final ModelPart platePart;

    public CustomPaintingRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.platePart = context.m_174023_(PAINTING_PLATE_LAYER);
    }

    public static LayerDefinition createPlateLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("main", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, -1.0f, -2.0f, 6.0f, 2.0f, 2.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    public void render(CustomPaintingEntity entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource renderBuffers, int combinedLight) {
        PaintingData canvasData;
        Level world = entity.m_20193_();
        matrixStack.m_85836_();
        Vec3 vector3d = this.m_7860_((Entity)entity, partialTicks);
        matrixStack.m_85837_(-vector3d.m_7096_(), -vector3d.m_7098_(), -vector3d.m_7094_());
        Direction facingDirection = entity.m_6350_();
        double offsetAlignment = 0.46875;
        matrixStack.m_85837_((double)facingDirection.m_122429_() * 0.46875, (double)facingDirection.m_122430_() * 0.46875, (double)facingDirection.m_122431_() * 0.46875);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - entity.m_146908_()));
        boolean flag = entity.m_20145_();
        double[] renderOffset = entity.getRenderOffset();
        int blockWidth = entity.getBlockWidth();
        int blockHeight = entity.getBlockHeight();
        if (!flag) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(renderOffset[0] - 1.0, renderOffset[1] - 1.0, 0.4375);
            if (blockWidth == 1 && blockHeight == 1) {
                this.renderModel(entity, "1x1", matrixStack, renderBuffers, combinedLight);
            } else if (blockWidth == 1) {
                for (v = 0; v < blockHeight; ++v) {
                    matrixStack.m_85837_(0.0, (double)(-v), 0.0);
                    offsetCombinedLight = LevelRenderer.m_109541_((BlockAndTintGetter)entity.f_19853_, (BlockPos)CustomPaintingRenderer.getOffsetBlockPos(entity, 0, v));
                    if (v == 0) {
                        this.renderModel(entity, "top_u", matrixStack, renderBuffers, offsetCombinedLight);
                    } else if (v + 1 == blockHeight) {
                        this.renderModel(entity, "bottom_u", matrixStack, renderBuffers, offsetCombinedLight);
                    } else {
                        this.renderModel(entity, "center_vertical", matrixStack, renderBuffers, offsetCombinedLight);
                    }
                    matrixStack.m_85837_(0.0, (double)v, 0.0);
                }
            } else if (blockHeight == 1) {
                for (int h = 0; h < blockWidth; ++h) {
                    matrixStack.m_85837_((double)(-h), 0.0, 0.0);
                    offsetCombinedLight = LevelRenderer.m_109541_((BlockAndTintGetter)entity.f_19853_, (BlockPos)CustomPaintingRenderer.getOffsetBlockPos(entity, h, 0));
                    if (h == 0) {
                        this.renderModel(entity, "left_u", matrixStack, renderBuffers, offsetCombinedLight);
                    } else if (h + 1 == blockWidth) {
                        this.renderModel(entity, "right_u", matrixStack, renderBuffers, offsetCombinedLight);
                    } else {
                        this.renderModel(entity, "center_horizontal", matrixStack, renderBuffers, offsetCombinedLight);
                    }
                    matrixStack.m_85837_((double)h, 0.0, 0.0);
                }
            } else {
                for (v = 0; v < blockHeight; ++v) {
                    for (int h = 0; h < blockWidth; ++h) {
                        matrixStack.m_85837_((double)(-h), (double)(-v), 0.0);
                        int offsetCombinedLight = LevelRenderer.m_109541_((BlockAndTintGetter)entity.f_19853_, (BlockPos)CustomPaintingRenderer.getOffsetBlockPos(entity, h, v));
                        if (v == 0) {
                            if (h == 0) {
                                this.renderModel(entity, "top_left", matrixStack, renderBuffers, offsetCombinedLight);
                            } else if (h + 1 == blockWidth) {
                                this.renderModel(entity, "top_right", matrixStack, renderBuffers, offsetCombinedLight);
                            } else {
                                this.renderModel(entity, "top", matrixStack, renderBuffers, offsetCombinedLight);
                            }
                        } else if (v + 1 == blockHeight) {
                            if (h == 0) {
                                this.renderModel(entity, "bottom_left", matrixStack, renderBuffers, offsetCombinedLight);
                            } else if (h + 1 == blockWidth) {
                                this.renderModel(entity, "bottom_right", matrixStack, renderBuffers, offsetCombinedLight);
                            } else {
                                this.renderModel(entity, "bottom", matrixStack, renderBuffers, offsetCombinedLight);
                            }
                        } else if (h == 0) {
                            this.renderModel(entity, "left", matrixStack, renderBuffers, offsetCombinedLight);
                        } else if (h + 1 == blockWidth) {
                            this.renderModel(entity, "right", matrixStack, renderBuffers, offsetCombinedLight);
                        } else {
                            this.renderModel(entity, "center", matrixStack, renderBuffers, offsetCombinedLight);
                        }
                        matrixStack.m_85837_((double)h, (double)v, 0.0);
                    }
                }
            }
            matrixStack.m_85849_();
        }
        if ((canvasData = CustomPaintingRenderer.getCanvasData(world, entity.getCanvasCode())) != null) {
            matrixStack.m_85836_();
            double canvasOffsetZ = entity.getMaterial().hasOffset() ? 0.46875 : 0.4375;
            matrixStack.m_85837_(renderOffset[0] - 1.0, renderOffset[1] - 1.0, canvasOffsetZ);
            float scaleFactor = 0.0625f;
            matrixStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            matrixStack.m_85837_(-16.0, -16.0, 0.0);
            CanvasRenderer.getInstance().renderCanvas(matrixStack, renderBuffers, entity.getCanvasCode(), canvasData, combinedLight);
            matrixStack.m_85849_();
        } else {
            CanvasRenderer.getInstance().queueCanvasTextureUpdate(AbstractCanvasData.Type.PAINTING, entity.getCanvasCode());
        }
        if (canvasData != null && entity.hasPlate()) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, (double)blockHeight / -2.0, 0.5);
            String material = entity.getMaterial().toString();
            VertexConsumer vertexBuilder = renderBuffers.m_6299_(RenderType.m_110452_((ResourceLocation)PLATE_TEXTURES.get(material)));
            this.platePart.m_104306_(matrixStack, vertexBuilder, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, matrixStack, renderBuffers, combinedLight);
    }

    private void renderModel(CustomPaintingEntity entity, String key, PoseStack matrixStack, MultiBufferSource renderBuffers, int combinedLight) {
        ModelResourceLocation modelResourceLocation = FRAME_MODELS.get(entity.getMaterial() + "/" + key);
        PoseStack.Pose currentMatrix = matrixStack.m_85850_();
        VertexConsumer vertexBuffer = renderBuffers.m_6299_(RenderType.m_110451_());
        BakedModel frameModel = Minecraft.m_91087_().m_91304_().m_119422_(modelResourceLocation);
        BlockRenderDispatcher rendererDispatcher = Minecraft.m_91087_().m_91289_();
        rendererDispatcher.m_110937_().renderModel(currentMatrix, vertexBuffer, null, frameModel, 1.0f, 1.0f, 1.0f, combinedLight, OverlayTexture.f_118083_, (IModelData)EmptyModelData.INSTANCE);
    }

    public static BlockPos getOffsetBlockPos(CustomPaintingEntity entity, int h, int v) {
        Direction facingDirection = entity.m_6350_();
        facingDirection = facingDirection.m_122428_();
        int xOffset = (entity.getBlockWidth() + 1) / 2 - 1;
        int yOffset = (entity.getBlockHeight() + 1) / 2 - 1;
        return entity.m_31748_().m_142082_((xOffset + h) * facingDirection.m_122429_(), yOffset + v, (xOffset + h) * facingDirection.m_122431_());
    }

    @Nullable
    public static PaintingData getCanvasData(Level world, String canvasName) {
        ICanvasTracker canvasTracker = Helper.getWorldCanvasTracker(world);
        if (canvasTracker == null) {
            return null;
        }
        return canvasTracker.getCanvasData(canvasName, PaintingData.class);
    }

    public ResourceLocation getTextureLocation(CustomPaintingEntity entity) {
        return PLATE_TEXTURES.get("oak");
    }

    static {
        for (String string : MODEL_CODES) {
            for (CustomPaintingEntity.Materials material : CustomPaintingEntity.Materials.values()) {
                FRAME_MODELS.put(material + "/" + string, new ModelResourceLocation("zetter:frame/" + material + "/" + string));
            }
        }
        for (CustomPaintingEntity.Materials materials : CustomPaintingEntity.Materials.values()) {
            if (!materials.canHavePlate()) continue;
            PLATE_TEXTURES.put(materials.toString(), new ResourceLocation("zetter", "textures/entity/frame/plate/" + materials + ".png"));
        }
    }
}

