/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.core;

import java.util.Optional;
import me.dantaeusb.zetter.network.packet.CCanvasBucketToolPacket;
import me.dantaeusb.zetter.network.packet.CCanvasRequestPacket;
import me.dantaeusb.zetter.network.packet.CCanvasUnloadRequestPacket;
import me.dantaeusb.zetter.network.packet.CPaintingFrameBufferPacket;
import me.dantaeusb.zetter.network.packet.CPaletteUpdatePacket;
import me.dantaeusb.zetter.network.packet.CRenamePaintingPacket;
import me.dantaeusb.zetter.network.packet.SCanvasSyncMessage;
import me.dantaeusb.zetter.network.packet.SEaselCanvasChangePacket;
import me.dantaeusb.zetter.network.packet.SPaintingSyncMessage;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

@Mod.EventBusSubscriber(modid="zetter", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ZetterNetwork {
    public static SimpleChannel simpleChannel;
    public static final ResourceLocation simpleChannelRL;
    public static final String MESSAGE_PROTOCOL_VERSION = "0.1";
    public static final byte PAINTING_FRAME = 21;
    public static final byte PAINTING_REQUEST_CANVAS = 22;
    public static final byte PAINTING_UNLOAD_CANVAS = 23;
    public static final byte CANVAS_SYNC = 24;
    public static final byte PALETTE_UPDATE = 25;
    public static final byte PAINTING_RENAME = 26;
    public static final byte EASEL_CANVAS_CHANGE = 28;
    public static final byte PAINTING_SYNC = 29;
    public static final byte PAINTING_BUCKET = 30;

    @SubscribeEvent
    public static void onCommonSetupEvent(FMLCommonSetupEvent event) {
        simpleChannel = NetworkRegistry.newSimpleChannel((ResourceLocation)simpleChannelRL, () -> MESSAGE_PROTOCOL_VERSION, ZetterNetwork::isThisProtocolAcceptedByClient, ZetterNetwork::isThisProtocolAcceptedByServer);
        simpleChannel.registerMessage(21, CPaintingFrameBufferPacket.class, CPaintingFrameBufferPacket::writePacketData, CPaintingFrameBufferPacket::readPacketData, CPaintingFrameBufferPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        simpleChannel.registerMessage(22, CCanvasRequestPacket.class, CCanvasRequestPacket::writePacketData, CCanvasRequestPacket::readPacketData, CCanvasRequestPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        simpleChannel.registerMessage(23, CCanvasUnloadRequestPacket.class, CCanvasUnloadRequestPacket::writePacketData, CCanvasUnloadRequestPacket::readPacketData, CCanvasUnloadRequestPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        simpleChannel.registerMessage(24, SCanvasSyncMessage.class, SCanvasSyncMessage::writePacketData, SCanvasSyncMessage::readPacketData, SCanvasSyncMessage::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        simpleChannel.registerMessage(29, SPaintingSyncMessage.class, SPaintingSyncMessage::writePacketData, SPaintingSyncMessage::readPacketData, SPaintingSyncMessage::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        simpleChannel.registerMessage(25, CPaletteUpdatePacket.class, CPaletteUpdatePacket::writePacketData, CPaletteUpdatePacket::readPacketData, CPaletteUpdatePacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        simpleChannel.registerMessage(26, CRenamePaintingPacket.class, CRenamePaintingPacket::writePacketData, CRenamePaintingPacket::readPacketData, CRenamePaintingPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        simpleChannel.registerMessage(28, SEaselCanvasChangePacket.class, SEaselCanvasChangePacket::writePacketData, SEaselCanvasChangePacket::readPacketData, SEaselCanvasChangePacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        simpleChannel.registerMessage(30, CCanvasBucketToolPacket.class, CCanvasBucketToolPacket::writePacketData, CCanvasBucketToolPacket::readPacketData, CCanvasBucketToolPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    public static boolean isThisProtocolAcceptedByClient(String protocolVersion) {
        return MESSAGE_PROTOCOL_VERSION.equals(protocolVersion);
    }

    public static boolean isThisProtocolAcceptedByServer(String protocolVersion) {
        return MESSAGE_PROTOCOL_VERSION.equals(protocolVersion);
    }

    static {
        simpleChannelRL = new ResourceLocation("zetter", "zetter_channel");
    }
}

