/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.item.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class FramingRecipe
extends CustomRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    public static final ResourceLocation TYPE_ID = new ResourceLocation("zetter", "framing");
    private final Ingredient inputFrame;
    private final Ingredient inputPainting;

    public FramingRecipe(ResourceLocation id, Ingredient inputFrame, Ingredient inputPainting) {
        super(id);
        this.inputFrame = inputFrame;
        this.inputPainting = inputPainting;
    }

    public String toString() {
        return "FramingRecipe [inputFrame=" + this.inputFrame + ", inputPainting=" + this.inputPainting + "]";
    }

    public boolean matches(CraftingContainer craftingInventory, Level world) {
        ItemStack frameStack = ItemStack.f_41583_;
        ItemStack paintingStack = ItemStack.f_41583_;
        for (int i = 0; i < craftingInventory.m_6643_(); ++i) {
            if (craftingInventory.m_8020_(i).m_41619_()) continue;
            if (this.inputFrame.test(craftingInventory.m_8020_(i))) {
                if (!frameStack.m_41619_()) {
                    return false;
                }
                frameStack = craftingInventory.m_8020_(i);
                continue;
            }
            if (!this.inputPainting.test(craftingInventory.m_8020_(i))) continue;
            if (!paintingStack.m_41619_()) {
                return false;
            }
            paintingStack = craftingInventory.m_8020_(i);
        }
        return !frameStack.m_41619_() && !paintingStack.m_41619_() && paintingStack.m_41782_();
    }

    public ItemStack assemble(CraftingContainer craftingInventory) {
        ItemStack frameStack = ItemStack.f_41583_;
        ItemStack paintingStack = ItemStack.f_41583_;
        for (int i = 0; i < craftingInventory.m_6643_(); ++i) {
            if (this.inputFrame.test(craftingInventory.m_8020_(i))) {
                if (!frameStack.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                frameStack = craftingInventory.m_8020_(i);
                continue;
            }
            if (!this.inputPainting.test(craftingInventory.m_8020_(i))) continue;
            if (!paintingStack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            paintingStack = craftingInventory.m_8020_(i);
        }
        if (!paintingStack.m_41619_() && paintingStack.m_41782_()) {
            ItemStack outStack = frameStack.m_41777_();
            CompoundTag compoundnbt = paintingStack.m_41783_().m_6426_();
            outStack.m_41751_(compoundnbt);
            return outStack;
        }
        return ItemStack.f_41583_;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 2 && height >= 2;
    }

    private static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<FramingRecipe> {
        Serializer() {
            this.setRegistryName(new ResourceLocation("zetter", "framing"));
        }

        public FramingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            JsonObject inputFrameJson = GsonHelper.m_13930_((JsonObject)json, (String)"frame");
            Ingredient inputFrame = Ingredient.m_43917_((JsonElement)inputFrameJson);
            JsonObject inputPaintingJson = GsonHelper.m_13930_((JsonObject)json, (String)"painting");
            Ingredient inputPainting = Ingredient.m_43917_((JsonElement)inputPaintingJson);
            return new FramingRecipe(recipeId, inputFrame, inputPainting);
        }

        public FramingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient frameIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient paintingIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            return new FramingRecipe(recipeId, frameIngredient, paintingIngredient);
        }

        public void toNetwork(FriendlyByteBuf buffer, FramingRecipe recipe) {
            recipe.inputFrame.m_43923_(buffer);
            recipe.inputPainting.m_43923_(buffer);
        }
    }
}

