/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.item.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import me.dantaeusb.zetter.core.ZetterItems;
import me.dantaeusb.zetter.item.FrameItem;
import me.dantaeusb.zetter.item.PaintingItem;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class UnframingRecipe
extends CustomRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    public static final ResourceLocation TYPE_ID = new ResourceLocation("zetter", "unframing");
    private final Ingredient inputFrame;

    public UnframingRecipe(ResourceLocation id, Ingredient inputFrame) {
        super(id);
        this.inputFrame = inputFrame;
    }

    public String toString() {
        return "UnframingRecipe [inputFrame=" + this.inputFrame + "]";
    }

    public boolean matches(CraftingContainer craftingInventory, Level world) {
        ItemStack frameStack = ItemStack.f_41583_;
        for (int i = 0; i < craftingInventory.m_6643_(); ++i) {
            if (craftingInventory.m_8020_(i).m_41619_() || !this.inputFrame.test(craftingInventory.m_8020_(i))) continue;
            if (!frameStack.m_41619_()) {
                return false;
            }
            frameStack = craftingInventory.m_8020_(i);
        }
        return !frameStack.m_41619_() && PaintingItem.getPaintingCode(frameStack) != null;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList remainingItems = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (!(stackInSlot.m_41720_() instanceof FrameItem)) continue;
            Item keepItem = stackInSlot.m_41720_();
            ItemStack keepStack = new ItemStack((ItemLike)keepItem);
            keepStack.m_41764_(1);
            remainingItems.set(i, (Object)keepStack);
            break;
        }
        return remainingItems;
    }

    public ItemStack assemble(CraftingContainer craftingInventory) {
        ItemStack frameStack = ItemStack.f_41583_;
        for (int i = 0; i < craftingInventory.m_6643_(); ++i) {
            if (!this.inputFrame.test(craftingInventory.m_8020_(i))) continue;
            if (!frameStack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            frameStack = craftingInventory.m_8020_(i);
        }
        if (!frameStack.m_41619_() && frameStack.m_41782_()) {
            ItemStack outStack = new ItemStack((ItemLike)ZetterItems.PAINTING.get());
            CompoundTag compoundnbt = frameStack.m_41783_().m_6426_();
            outStack.m_41751_(compoundnbt);
            return outStack;
        }
        return ItemStack.f_41583_;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 2 && height >= 2;
    }

    private static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<UnframingRecipe> {
        Serializer() {
            this.setRegistryName(new ResourceLocation("zetter", "unframing"));
        }

        public UnframingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            JsonObject inputFrameJson = GsonHelper.m_13930_((JsonObject)json, (String)"frame");
            Ingredient inputFrame = Ingredient.m_43917_((JsonElement)inputFrameJson);
            return new UnframingRecipe(recipeId, inputFrame);
        }

        public UnframingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient frameIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            return new UnframingRecipe(recipeId, frameIngredient);
        }

        public void toNetwork(FriendlyByteBuf buffer, UnframingRecipe recipe) {
            recipe.inputFrame.m_43923_(buffer);
        }
    }
}

