/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.menu;

import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.block.entity.container.ArtistTableContainer;
import me.dantaeusb.zetter.canvastracker.ICanvasTracker;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.core.ItemStackHandlerListener;
import me.dantaeusb.zetter.core.ZetterContainerMenus;
import me.dantaeusb.zetter.core.ZetterItems;
import me.dantaeusb.zetter.item.FrameItem;
import me.dantaeusb.zetter.item.PaintingItem;
import me.dantaeusb.zetter.menu.artisttable.CanvasCombination;
import me.dantaeusb.zetter.storage.DummyCanvasData;
import me.dantaeusb.zetter.storage.PaintingData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.apache.commons.lang3.StringUtils;

public class ArtistTableMenu
extends AbstractContainerMenu
implements ItemStackHandlerListener {
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    public static final int CANVAS_ROW_COUNT = 4;
    public static final int CANVAS_COLUMN_COUNT = 4;
    public static final int CANVAS_SLOT_COUNT = 16;
    private final Player player;
    private final Level world;
    private ArtistTableContainer artistTableContainer;
    private CanvasCombination canvasCombination;
    private String paintingName = "";
    protected final ItemStackHandler inventoryOut = new ItemStackHandler(1);
    public static final int PLAYER_INVENTORY_XPOS = 8;
    public static final int PLAYER_INVENTORY_YPOS = 138;

    public ArtistTableMenu(int windowID, Inventory invPlayer, ArtistTableContainer artistTableContainer) {
        super((MenuType)ZetterContainerMenus.ARTIST_TABLE.get(), windowID);
        this.player = invPlayer.f_35978_;
        this.world = invPlayer.f_35978_.f_19853_;
        this.artistTableContainer = artistTableContainer;
        this.artistTableContainer.addListener(this);
        int SLOT_X_SPACING = 18;
        int SLOT_Y_SPACING = 18;
        int HOTBAR_XPOS = 8;
        int HOTBAR_YPOS = 196;
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)invPlayer, x, 8 + 18 * x, 196));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                int slotNumber = 9 + y * 9 + x;
                int xpos = 8 + x * 18;
                int ypos = 138 + y * 18;
                this.m_38897_(new Slot((Container)invPlayer, slotNumber, xpos, ypos));
            }
        }
        int CANVAS_INVENTORY_XPOS = 12;
        int CANVAS_INVENTORY_YPOS = 24;
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                int slotNumber = y * 4 + x;
                int xpos = 12 + x * 18;
                int ypos = 24 + y * 18;
                this.m_38897_((Slot)new SlotCanvas(this.artistTableContainer, slotNumber, xpos, ypos));
            }
        }
        int OUTPUT_XPOS = 152;
        int OUTPUT_YPOS = 107;
        this.m_38897_((Slot)new SlotOutput(this.inventoryOut, 0, 152, 107));
        this.updateCanvasCombination();
    }

    public static ArtistTableMenu createMenuServerSide(int windowID, Inventory playerInventory, ArtistTableContainer artistTableContainer) {
        return new ArtistTableMenu(windowID, playerInventory, artistTableContainer);
    }

    public static ArtistTableMenu createMenuClientSide(int windowID, Inventory playerInventory, FriendlyByteBuf networkBuffer) {
        ArtistTableContainer artistTableContainer = new ArtistTableContainer();
        return new ArtistTableMenu(windowID, playerInventory, artistTableContainer);
    }

    public void updatePaintingName(String newPaintingName) {
        this.paintingName = newPaintingName;
        this.updatePaintingOutput();
    }

    public void updatePaintingOutput() {
        ItemStack existingStack = this.inventoryOut.getStackInSlot(0);
        ItemStack outStack = this.isCanvasReady() ? (existingStack.m_41619_() ? new ItemStack((ItemLike)ZetterItems.PAINTING.get()) : existingStack) : ItemStack.f_41583_;
        if (!outStack.m_41619_()) {
            if (StringUtils.isBlank((CharSequence)this.paintingName)) {
                if (existingStack.m_41788_()) {
                    existingStack.m_41787_();
                }
                PaintingItem.setCachedPaintingName(outStack, this.paintingName);
            } else if (!this.paintingName.equals(FrameItem.getCachedAuthorName(outStack))) {
                PaintingItem.setCachedPaintingName(outStack, this.paintingName);
            }
            String authorName = this.player.m_7755_().getString();
            if (!authorName.equals(FrameItem.getCachedAuthorName(outStack))) {
                PaintingItem.setCachedAuthorName(outStack, authorName);
            }
        }
        this.inventoryOut.setStackInSlot(0, outStack);
    }

    protected ItemStack takePainting(Player player, ItemStack outStack) {
        DummyCanvasData combinedCanvasData = this.getCanvasCombination().canvasData;
        ICanvasTracker canvasTracker = Helper.getWorldCanvasTracker(this.world);
        if (combinedCanvasData == null) {
            Zetter.LOG.error("Cannot find combined canvas data");
            return ItemStack.f_41583_;
        }
        int newId = canvasTracker.getNextPaintingId();
        String newCode = PaintingData.getCanvasCode(newId);
        PaintingData paintingData = PaintingData.createFrom(combinedCanvasData);
        paintingData.setMetaProperties(player.m_7755_().getString(), this.paintingName);
        canvasTracker.registerCanvasData(PaintingData.getPaintingCode(newId), paintingData);
        PaintingItem.setPaintingData(outStack, newCode, paintingData, 0);
        if (!player.m_7500_()) {
            this.artistTableContainer.clear();
        }
        return outStack;
    }

    @Override
    public void containerChanged(ItemStackHandler container) {
        this.updateCanvasCombination();
    }

    public void updateCanvasCombination() {
        this.canvasCombination = new CanvasCombination(this.artistTableContainer, this.world);
        this.updatePaintingOutput();
    }

    public CanvasCombination getCanvasCombination() {
        return this.canvasCombination;
    }

    public boolean isCanvasReady() {
        return this.canvasCombination.state == CanvasCombination.State.READY;
    }

    public boolean canvasLoading() {
        return this.canvasCombination.state == CanvasCombination.State.NOT_LOADED;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.artistTableContainer.removeListener(this);
    }

    public boolean m_5882_(ItemStack stack, Slot slotIn) {
        return slotIn.f_40218_ != this.inventoryOut && super.m_5882_(stack, slotIn);
    }

    public ItemStack m_7648_(Player playerIn, int sourceSlotIndex) {
        ItemStack outStack = ItemStack.f_41583_;
        Slot sourceSlot = (Slot)this.f_38839_.get(sourceSlotIndex);
        if (sourceSlot != null && sourceSlot.m_6657_()) {
            ItemStack sourceStack = sourceSlot.m_7993_();
            outStack = sourceStack.m_41777_();
            if (sourceSlotIndex == 0) {
                if (!this.m_38903_(sourceStack, 2, 10, true)) {
                    return ItemStack.f_41583_;
                }
                sourceSlot.m_40234_(sourceStack, outStack);
            } else if (sourceStack.m_41720_() == ZetterItems.PALETTE.get()) {
                if (!this.m_38903_(sourceStack, 0, 1, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                return ItemStack.f_41583_;
            }
            if (sourceStack.m_41619_()) {
                sourceSlot.m_5852_(ItemStack.f_41583_);
            } else {
                sourceSlot.m_6654_();
            }
            if (sourceStack.m_41613_() == outStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            sourceSlot.m_142406_(playerIn, sourceStack);
        }
        return outStack;
    }

    public boolean m_6875_(Player player) {
        return this.artistTableContainer.stillValid(player);
    }

    public class SlotCanvas
    extends SlotItemHandler {
        public SlotCanvas(ItemStackHandler stackHandler, int index, int xPosition, int yPosition) {
            super((IItemHandler)stackHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            return ArtistTableMenu.this.artistTableContainer.isItemValid(this.getSlotIndex(), stack);
        }
    }

    public class SlotOutput
    extends SlotItemHandler {
        public SlotOutput(ItemStackHandler stackHandler, int index, int xPosition, int yPosition) {
            super((IItemHandler)stackHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public void m_142406_(Player player, ItemStack stack) {
            ArtistTableMenu.this.takePainting(player, stack);
        }
    }
}

