/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.menu;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.UUID;
import java.util.Vector;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.canvastracker.CanvasServerTracker;
import me.dantaeusb.zetter.canvastracker.ICanvasTracker;
import me.dantaeusb.zetter.client.renderer.CanvasRenderer;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.core.ZetterCapabilities;
import me.dantaeusb.zetter.core.ZetterContainerMenus;
import me.dantaeusb.zetter.core.ZetterItems;
import me.dantaeusb.zetter.core.ZetterNetwork;
import me.dantaeusb.zetter.entity.item.EaselEntity;
import me.dantaeusb.zetter.entity.item.container.EaselContainer;
import me.dantaeusb.zetter.item.CanvasItem;
import me.dantaeusb.zetter.item.PaletteItem;
import me.dantaeusb.zetter.menu.painting.PaintingFrame;
import me.dantaeusb.zetter.menu.painting.PaintingFrameBuffer;
import me.dantaeusb.zetter.network.packet.CCanvasBucketToolPacket;
import me.dantaeusb.zetter.network.packet.CPaintingFrameBufferPacket;
import me.dantaeusb.zetter.network.packet.CPaletteUpdatePacket;
import me.dantaeusb.zetter.network.packet.SCanvasNamePacket;
import me.dantaeusb.zetter.storage.CanvasData;
import me.dantaeusb.zetter.storage.util.CanvasHolder;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class EaselContainerMenu
extends AbstractContainerMenu {
    public static int FRAME_TIMEOUT = 5000;
    private final Player player;
    private final Level world;
    private EaselEntity entity;
    public static final int PALETTE_SLOTS = 14;
    private static final int HOTBAR_SLOT_COUNT = 9;
    @Nullable
    private CanvasHolder<CanvasData> canvas;
    private final EaselContainer easelContainer;
    private PaintingFrameBuffer canvasChanges;
    private final LinkedList<PaintingFrame> lastFrames = new LinkedList();
    private long lastFrameBufferSendClock = 0L;
    private long lastSyncReceivedClock = 0L;
    private long lastPushedFrameClock = 0L;
    private Notify firstLoadNotification = () -> {};

    public EaselContainerMenu(int windowID, Inventory invPlayer, EaselContainer easelContainer) {
        super((MenuType)ZetterContainerMenus.PAINTING.get(), windowID);
        if (ZetterContainerMenus.PAINTING == null) {
            throw new IllegalStateException("Must initialise containerTypeLockTableContainer before constructing a LockTableContainer!");
        }
        this.player = invPlayer.f_35978_;
        this.world = invPlayer.f_35978_.f_19853_;
        this.easelContainer = easelContainer;
        this.canvasChanges = new PaintingFrameBuffer(System.currentTimeMillis());
        int PALETTE_SLOT_X_SPACING = 152;
        int PALETTE_SLOT_Y_SPACING = 94;
        int HOTBAR_XPOS = 8;
        int HOTBAR_YPOS = 161;
        int SLOT_X_SPACING = 18;
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.easelContainer, 1, 152, 94){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() == ZetterItems.PALETTE.get();
            }
        });
        if (!this.world.m_5776_()) {
            ItemStack canvasStack = this.easelContainer.getCanvasStack();
            String canvasName = CanvasItem.getCanvasCode(canvasStack);
            this.setCanvas(canvasName);
        }
        for (int x = 0; x < 9; ++x) {
            int slotNumber = x;
            this.m_38897_(new Slot((Container)invPlayer, slotNumber, 8 + 18 * x, 161));
        }
    }

    public void setEntity(EaselEntity entity) {
        this.entity = entity;
    }

    public static EaselContainerMenu createMenuServerSide(int windowID, Inventory playerInventory, EaselEntity entity, EaselContainer easelContainer) {
        EaselContainerMenu easelContainerMenu = new EaselContainerMenu(windowID, playerInventory, easelContainer);
        easelContainerMenu.setEntity(entity);
        return easelContainerMenu;
    }

    public static EaselContainerMenu createMenuClientSide(int windowID, Inventory playerInventory, FriendlyByteBuf networkBuffer) {
        EaselContainer easelContainer = new EaselContainer();
        String canvasName = SCanvasNamePacket.readCanvasName(networkBuffer);
        EaselContainerMenu easelContainerMenu = new EaselContainerMenu(windowID, playerInventory, easelContainer);
        easelContainerMenu.setCanvas(canvasName);
        return easelContainerMenu;
    }

    @Nullable
    public EaselEntity getEntity() {
        return this.entity;
    }

    public EaselContainer getEaselContainer() {
        return this.easelContainer;
    }

    public void setFirstLoadNotification(Notify firstLoadNotification) {
        this.firstLoadNotification = firstLoadNotification;
    }

    public void handleCanvasChange(ItemStack canvasStack) {
        this.canvas = canvasStack.m_41720_() == ZetterItems.CANVAS.get() ? new CanvasHolder<CanvasData>(CanvasItem.getCanvasCode(canvasStack), CanvasItem.getCanvasData(canvasStack, this.world)) : null;
        if (this.firstLoadNotification != null) {
            this.firstLoadNotification.invoke();
        }
    }

    public void setCanvas(String canvasName) {
        if (canvasName == null || canvasName.equals(CanvasData.getCanvasCode(0))) {
            this.canvas = null;
            return;
        }
        ICanvasTracker canvasTracker = this.world.m_5776_() ? (ICanvasTracker)this.world.getCapability(ZetterCapabilities.CANVAS_TRACKER).orElse(null) : (ICanvasTracker)this.world.m_142572_().m_129783_().getCapability(ZetterCapabilities.CANVAS_TRACKER).orElse(null);
        if (canvasTracker == null) {
            Zetter.LOG.error("Cannot find world canvas capability");
            this.canvas = null;
            return;
        }
        CanvasData canvas = canvasTracker.getCanvasData(canvasName, CanvasData.class);
        if (canvas == null) {
            this.canvas = null;
            return;
        }
        this.canvas = new CanvasHolder<CanvasData>(canvasName, canvas);
    }

    public int getPaletteColor(int paletteSlot) {
        ItemStack paletteStack = this.easelContainer.getPaletteStack();
        if (paletteStack.m_41619_()) {
            return -16777216;
        }
        return PaletteItem.getPaletteColors(paletteStack)[paletteSlot];
    }

    public void setPaletteColor(int paletteSlot, int color) {
        ItemStack paletteStack = this.easelContainer.getPaletteStack();
        if (paletteStack.m_41619_()) {
            return;
        }
        PaletteItem.updatePaletteColor(paletteStack, paletteSlot, color);
        this.easelContainer.changed();
    }

    public void sendPaletteUpdatePacket(int paletteSlot, int color) {
        if (!this.isPaletteAvailable()) {
            return;
        }
        CPaletteUpdatePacket paletteUpdatePacket = new CPaletteUpdatePacket(paletteSlot, color);
        Zetter.LOG.debug("Sending Palette Update: " + paletteUpdatePacket);
        ZetterNetwork.simpleChannel.sendToServer((Object)paletteUpdatePacket);
    }

    @Nullable
    public String getCanvasCode() {
        if (this.canvas == null) {
            return null;
        }
        return this.canvas.code;
    }

    @Nullable
    public CanvasData getCanvasData() {
        if (this.canvas == null) {
            return null;
        }
        return (CanvasData)((Object)this.canvas.data);
    }

    public boolean isCanvasAvailable() {
        return this.canvas != null;
    }

    public boolean isPaletteAvailable() {
        ItemStack paletteStack = this.easelContainer.getPaletteStack();
        return !paletteStack.m_41619_();
    }

    public void tick() {
        this.checkFrameBuffer();
        this.dropOldFrames();
    }

    public void writePixelOnCanvasClientSide(int pixelX, int pixelY, int color, UUID playerId) {
        if (!this.isCanvasAvailable()) {
            return;
        }
        int index = ((CanvasData)((Object)this.canvas.data)).getPixelIndex(pixelX, pixelY);
        if (this.writePixelOnCanvas(index, color)) {
            this.checkFrameBuffer();
            this.getCanvasChanges().writeChange(this.world.m_46467_(), index, color);
            PaintingFrame newFrame = new PaintingFrame(System.currentTimeMillis(), (short)index, color, playerId);
            this.placeFrame(newFrame);
            this.updateTextureClient();
        }
    }

    public void eyedropper(int slotIndex, int pixelX, int pixelY) {
        if (!this.isCanvasAvailable()) {
            return;
        }
        int newColor = ((CanvasData)((Object)this.canvas.data)).getColorAt(pixelX, pixelY);
        this.setPaletteColor(slotIndex, newColor);
        this.sendPaletteUpdatePacket(slotIndex, newColor);
    }

    public void bucket(int pixelX, int pixelY, int color) {
        if (!this.isCanvasAvailable()) {
            return;
        }
        int position = ((CanvasData)((Object)this.canvas.data)).getPixelIndex(pixelX, pixelY);
        CCanvasBucketToolPacket bucketToolPacket = new CCanvasBucketToolPacket(position, color);
        Zetter.LOG.debug("Sending Bucket Tool Packet: " + bucketToolPacket);
        ZetterNetwork.simpleChannel.sendToServer((Object)bucketToolPacket);
    }

    protected void updateTextureClient() {
        if (this.canvas == null) {
            Zetter.LOG.error("Attempted to update texture with no canvas loaded in easel");
            return;
        }
        CanvasRenderer.getInstance().updateCanvasTexture(this.canvas.code, (CanvasData)((Object)this.canvas.data));
    }

    private void writePixelOnCanvasServerSide(int index, int color) {
        this.writePixelOnCanvas(index, color);
        this.easelContainer.getPaletteStack().m_41622_(1, (LivingEntity)this.player, player -> {});
    }

    private boolean writePixelOnCanvas(int index, int color) {
        if (!this.isCanvasAvailable()) {
            return false;
        }
        if (!this.isPaletteAvailable()) {
            return false;
        }
        if (((CanvasData)((Object)this.canvas.data)).getColorAt(index) == color) {
            return false;
        }
        this.getCanvasData().updateCanvasPixel(index, color);
        return true;
    }

    protected void checkFrameBuffer() {
        if (this.getCanvasChanges().isEmpty()) {
            try {
                this.canvasChanges.updateStartFrameTime(System.currentTimeMillis());
            }
            catch (Exception e) {
                Zetter.LOG.error("Cannot update Painting Frame Buffer start time: " + e.getMessage());
            }
            return;
        }
        if (this.canvasChanges.shouldBeSent(System.currentTimeMillis())) {
            if (this.world.m_5776_()) {
                this.canvasChanges.getFrames(this.player.m_142081_());
                CPaintingFrameBufferPacket paintingFrameBufferPacket = new CPaintingFrameBufferPacket(this.canvasChanges);
                ZetterNetwork.simpleChannel.sendToServer((Object)paintingFrameBufferPacket);
                this.lastFrameBufferSendClock = System.currentTimeMillis();
            } else {
                Zetter.LOG.warn("Unnecessary Painting Frame Buffer check on server");
            }
            this.canvasChanges = null;
        }
    }

    protected PaintingFrameBuffer getCanvasChanges() {
        if (this.canvasChanges == null) {
            this.canvasChanges = new PaintingFrameBuffer(System.currentTimeMillis());
        }
        return this.canvasChanges;
    }

    public void processFrameBufferServer(PaintingFrameBuffer paintingFrameBuffer, UUID ownerId) {
        long currentTime = this.world.m_46467_();
        for (PaintingFrame frame : paintingFrameBuffer.getFrames(ownerId)) {
            if (currentTime - frame.getFrameTime() > (long)FRAME_TIMEOUT) {
                Zetter.LOG.debug("Skipping painting frame, too old");
                continue;
            }
            this.writePixelOnCanvasServerSide(frame.getPixelIndex(), frame.getColor());
        }
        ((CanvasServerTracker)Helper.getWorldCanvasTracker(this.world)).markCanvasDesync(this.canvas.code);
    }

    public void processBucketToolServer(int position, int bucketColor) {
        int width = ((CanvasData)((Object)this.canvas.data)).getWidth();
        int height = ((CanvasData)((Object)this.canvas.data)).getHeight();
        int length = width * height;
        int replacedColor = ((CanvasData)((Object)this.canvas.data)).getColorAt(position);
        LinkedList<Integer> positionsQueue = new LinkedList<Integer>();
        Vector checkedQueue = new Vector();
        Vector<Integer> paintQueue = new Vector<Integer>();
        positionsQueue.add(position);
        paintQueue.add(position);
        do {
            EaselContainerMenu.getNeighborPositions((Integer)positionsQueue.pop(), width, length).filter(currentPosition -> !checkedQueue.contains(currentPosition)).forEach(currentPosition -> {
                if (((CanvasData)((Object)((Object)this.canvas.data))).getColorAt((int)currentPosition) == replacedColor) {
                    positionsQueue.add((Integer)currentPosition);
                    paintQueue.add((Integer)currentPosition);
                }
                checkedQueue.add(currentPosition);
            });
        } while (!positionsQueue.isEmpty());
        Iterator iterator = paintQueue.iterator();
        while (iterator.hasNext()) {
            int updatePosition = (Integer)iterator.next();
            this.writePixelOnCanvasServerSide(updatePosition, bucketColor);
        }
        ((CanvasServerTracker)Helper.getWorldCanvasTracker(this.world)).markCanvasDesync(this.canvas.code);
    }

    public static Stream<Integer> getNeighborPositions(int currentCenter, int width, int length) {
        int bottomPosition;
        int rightPosition;
        int leftPosition;
        ArrayList<Integer> neighborPositions = new ArrayList<Integer>(4);
        int topPosition = currentCenter - width;
        if (topPosition >= 0) {
            neighborPositions.add(topPosition);
        }
        if ((leftPosition = currentCenter - 1) >= 0 && leftPosition / width == currentCenter / width) {
            neighborPositions.add(leftPosition);
        }
        if ((rightPosition = currentCenter + 1) < length && rightPosition / width == currentCenter / width) {
            neighborPositions.add(rightPosition);
        }
        if ((bottomPosition = currentCenter + width) < length) {
            neighborPositions.add(bottomPosition);
        }
        return neighborPositions.stream();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void processSync(String canvasCode, CanvasData canvasData, long packetTimestamp) {
        long timestamp = System.currentTimeMillis();
        PlayerInfo playerInfo = Minecraft.m_91087_().m_91403_().m_104949_(this.player.m_142081_());
        int latency = playerInfo.m_105330_();
        latency = (int)((double)latency * 1.1);
        latency = Math.max(latency, 50);
        long timeSinceLastFrameBufferSent = timestamp - this.lastFrameBufferSendClock;
        long adjustedTimestamp = System.currentTimeMillis();
        adjustedTimestamp -= (long)latency * 2L;
        boolean mightDesync = false;
        Tuple lowTrustInterval = new Tuple((Object)(adjustedTimestamp -= timeSinceLastFrameBufferSent), (Object)(timestamp - this.lastFrameBufferSendClock));
        Zetter.LOG.debug("Latency: " + latency);
        for (PaintingFrame oldFrame : this.lastFrames) {
            if (oldFrame.getFrameTime() < (Long)lowTrustInterval.m_14418_()) continue;
            if (oldFrame.getFrameTime() < (Long)lowTrustInterval.m_14419_()) {
                mightDesync = true;
            }
            canvasData.updateCanvasPixel(oldFrame.getPixelIndex(), oldFrame.getColor());
        }
        if (mightDesync) {
            CanvasRenderer.getInstance().queueCanvasTextureUpdate(canvasData.getType(), canvasCode);
        }
        this.canvas = new CanvasHolder<CanvasData>(canvasCode, canvasData);
        this.lastSyncReceivedClock = System.currentTimeMillis();
    }

    protected void placeFrame(PaintingFrame frame) {
        this.lastFrames.add(frame);
        this.lastPushedFrameClock = System.currentTimeMillis();
    }

    protected void dropOldFrames() {
        long minTime = Util.m_137550_() - (long)(FRAME_TIMEOUT * 50);
        Iterator iterator = this.lastFrames.iterator();
        while (iterator.hasNext()) {
            PaintingFrame oldFrame = (PaintingFrame)iterator.next();
            if (oldFrame.getFrameTime() < minTime) {
                iterator.remove();
                continue;
            }
            return;
        }
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        if (this.world.m_5776_() && !this.getCanvasChanges().isEmpty()) {
            this.canvasChanges.getFrames(playerIn.m_142081_());
            CPaintingFrameBufferPacket modePacket = new CPaintingFrameBufferPacket(this.canvasChanges);
            ZetterNetwork.simpleChannel.sendToServer((Object)modePacket);
            this.lastFrameBufferSendClock = System.currentTimeMillis();
        }
    }

    public ItemStack m_7648_(Player playerIn, int sourceSlotIndex) {
        ItemStack outStack = ItemStack.f_41583_;
        Slot sourceSlot = (Slot)this.f_38839_.get(sourceSlotIndex);
        if (sourceSlot != null && sourceSlot.m_6657_()) {
            ItemStack sourceStack = sourceSlot.m_7993_();
            outStack = sourceStack.m_41777_();
            if (sourceSlotIndex == 0) {
                if (!this.m_38903_(sourceStack, 2, 10, true)) {
                    return ItemStack.f_41583_;
                }
                sourceSlot.m_40234_(sourceStack, outStack);
            } else if (sourceStack.m_41720_() == ZetterItems.PALETTE.get()) {
                if (!this.m_38903_(sourceStack, 0, 1, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                return ItemStack.f_41583_;
            }
            if (sourceStack.m_41619_()) {
                sourceSlot.m_5852_(ItemStack.f_41583_);
            } else {
                sourceSlot.m_6654_();
            }
            if (sourceStack.m_41613_() == outStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            sourceSlot.m_142406_(playerIn, sourceStack);
        }
        return outStack;
    }

    public boolean m_6875_(Player player) {
        return this.easelContainer.stillValid(player);
    }

    @FunctionalInterface
    public static interface Notify {
        public void invoke();
    }
}

