/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.network;

import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.canvastracker.ICanvasTracker;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.core.ZetterCapabilities;
import me.dantaeusb.zetter.entity.item.EaselEntity;
import me.dantaeusb.zetter.menu.ArtistTableMenu;
import me.dantaeusb.zetter.menu.EaselContainerMenu;
import me.dantaeusb.zetter.network.packet.SCanvasSyncMessage;
import me.dantaeusb.zetter.network.packet.SEaselCanvasChangePacket;
import me.dantaeusb.zetter.network.packet.SPaintingSyncMessage;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import me.dantaeusb.zetter.storage.CanvasData;
import me.dantaeusb.zetter.storage.PaintingData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class ClientHandler {
    public static void processCanvasSync(SCanvasSyncMessage packetIn, Level world) {
        ICanvasTracker canvasTracker;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        String canvasCode = packetIn.getCanvasCode();
        AbstractCanvasData canvasData = packetIn.getCanvasData();
        if (player.f_36096_ instanceof EaselContainerMenu && ((EaselContainerMenu)player.f_36096_).isCanvasAvailable() && canvasCode.equals(((EaselContainerMenu)player.f_36096_).getCanvasCode())) {
            ((EaselContainerMenu)player.f_36096_).processSync(canvasCode, (CanvasData)canvasData, packetIn.getTimestamp());
        }
        if (player.f_36096_ instanceof ArtistTableMenu) {
            ((ArtistTableMenu)player.f_36096_).updateCanvasCombination();
        }
        if ((canvasTracker = (ICanvasTracker)world.getCapability(ZetterCapabilities.CANVAS_TRACKER).orElse(null)) == null) {
            Zetter.LOG.error("Cannot find world canvas capability");
            return;
        }
        canvasTracker.registerCanvasData(canvasCode, canvasData);
    }

    public static void processPaintingSync(SPaintingSyncMessage packetIn, Level world) {
        String canvasCode = packetIn.getCanvasCode();
        PaintingData canvasData = packetIn.getPaintingData();
        ICanvasTracker canvasTracker = Helper.getWorldCanvasTracker(world);
        if (canvasTracker == null) {
            Zetter.LOG.error("Cannot find world canvas capability");
            return;
        }
        canvasTracker.registerCanvasData(canvasCode, canvasData);
    }

    public static void processEaselCanvasUpdate(SEaselCanvasChangePacket packetIn, Level world) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Entity easel = world.m_6815_(packetIn.getEntityId());
        if (world.m_6815_(packetIn.getEntityId()) instanceof EaselEntity) {
            ((EaselEntity)easel).putCanvasStack(packetIn.getItem());
        }
        if (player.f_36096_ instanceof EaselContainerMenu) {
            // empty if block
        }
    }
}

