/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.network.packet;

import java.util.function.Supplier;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.network.ServerHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class CRenamePaintingPacket {
    private int windowId;
    private String paintingName;

    public CRenamePaintingPacket() {
    }

    public CRenamePaintingPacket(int windowId, String paintingName) {
        this.windowId = windowId;
        this.paintingName = paintingName;
    }

    public static CRenamePaintingPacket readPacketData(FriendlyByteBuf buf) {
        CRenamePaintingPacket packet = new CRenamePaintingPacket();
        try {
            packet.windowId = buf.readByte();
            packet.paintingName = buf.m_130136_(Short.MAX_VALUE);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Zetter.LOG.warn("Exception while reading CCreatePaintingPacket: " + e);
            return packet;
        }
        return packet;
    }

    public void writePacketData(FriendlyByteBuf buf) {
        buf.writeByte(this.windowId);
        buf.m_130070_(this.paintingName);
    }

    public int getWindowId() {
        return this.windowId;
    }

    public String getPaintingName() {
        return this.paintingName;
    }

    public static void handle(CRenamePaintingPacket packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.setPacketHandled(true);
        ServerPlayer sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            Zetter.LOG.warn("EntityPlayerMP was null when CCreatePaintingPacket was received");
        }
        ctx.enqueueWork(() -> ServerHandler.processRenamePainting(packetIn, sendingPlayer));
    }
}

