/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.network.packet;

import java.util.Optional;
import java.util.function.Supplier;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.network.ClientHandler;
import me.dantaeusb.zetter.network.packet.CanvasContainer;
import me.dantaeusb.zetter.storage.PaintingData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SPaintingSyncMessage {
    private final String canvasCode;
    private final PaintingData paintingData;
    private final long timestamp;

    public SPaintingSyncMessage(String canvasCode, PaintingData paintingData, long timestamp) {
        this.canvasCode = canvasCode;
        this.paintingData = paintingData;
        this.timestamp = timestamp;
    }

    public String getCanvasCode() {
        return this.canvasCode;
    }

    public PaintingData getPaintingData() {
        return this.paintingData;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public static SPaintingSyncMessage readPacketData(FriendlyByteBuf networkBuffer) {
        try {
            String canvasCode = networkBuffer.m_130277_();
            long timestamp = networkBuffer.readLong();
            PaintingData readCanvasData = (PaintingData)CanvasContainer.readPacketCanvasData(networkBuffer);
            String paintingName = networkBuffer.m_130277_();
            String authorName = networkBuffer.m_130277_();
            readCanvasData.setMetaProperties(authorName, paintingName);
            return new SPaintingSyncMessage(canvasCode, readCanvasData, timestamp);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Zetter.LOG.warn("Exception while reading SPaintingSyncMessage: " + e);
            return null;
        }
    }

    public void writePacketData(FriendlyByteBuf networkBuffer) {
        networkBuffer.m_130070_(this.canvasCode);
        networkBuffer.writeLong(this.timestamp);
        CanvasContainer.writePacketCanvasData(networkBuffer, this.paintingData);
        networkBuffer.m_130072_(this.paintingData.getPaintingName(), 64);
        networkBuffer.m_130072_(this.paintingData.getAuthorName(), 64);
    }

    public static void handle(SPaintingSyncMessage packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            Zetter.LOG.warn("SCanvasSyncMessage context could not provide a ClientWorld.");
            return;
        }
        ctx.enqueueWork(() -> ClientHandler.processPaintingSync(packetIn, (Level)clientWorld.get()));
    }

    public String toString() {
        return "SPaintingSyncMessage[painting=" + this.paintingData + ",timestamp=" + this.timestamp + "]";
    }
}

