/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.storage;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import net.minecraft.nbt.CompoundTag;

public class DummyCanvasData
extends AbstractCanvasData {
    protected DummyCanvasData() {
    }

    public static DummyCanvasData createDummy() {
        int width = Helper.getResolution().getNumeric();
        int height = Helper.getResolution().getNumeric();
        AbstractCanvasData.Resolution resolution = Helper.getResolution();
        return DummyCanvasData.createDummy(width, height, resolution);
    }

    public static DummyCanvasData createDummy(int width, int height, AbstractCanvasData.Resolution resolution) {
        byte[] color = new byte[width * height * 4];
        ByteBuffer defaultColorBuffer = ByteBuffer.wrap(color);
        int halfWidth = width / 2;
        int halfHeight = width / 2;
        for (int x = 0; x < width * height; ++x) {
            defaultColorBuffer.putInt(x * 4, width > halfWidth ^ height > halfHeight ? Helper.DUMMY_PINK_COLOR : Helper.DUMMY_BLACK_COLOR);
        }
        DummyCanvasData newDummyCanvas = new DummyCanvasData();
        newDummyCanvas.wrapData(resolution, width, height, color);
        return newDummyCanvas;
    }

    public static DummyCanvasData createWrap(AbstractCanvasData.Resolution resolution, int width, int height, byte[] color) {
        DummyCanvasData newCanvas = new DummyCanvasData();
        newCanvas.wrapData(resolution, width, height, color);
        return newCanvas;
    }

    @Override
    protected void updateColorData(byte[] color) {
        this.color = color;
        this.canvasBuffer = ByteBuffer.wrap(this.color);
        this.canvasBuffer.order(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public AbstractCanvasData.Type getType() {
        return AbstractCanvasData.Type.DUMMY;
    }

    @Override
    public void load(CompoundTag compoundTag) {
        Zetter.LOG.error("Trying to read into dummy canvas!");
    }

    @Override
    public CompoundTag m_7176_(CompoundTag compoundTag) {
        Zetter.LOG.error("Trying to save dummy canvas!");
        return compoundTag;
    }
}

