/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.dailyrewards.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonConfig {
    protected static final Logger log = LogManager.getLogger((String)"Daily Rewards");
    public static final ForgeConfigSpec commonSpec;
    public static final Config COMMON;

    protected CommonConfig() {
    }

    static {
        com.electronwill.nightconfig.core.Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Config)specPair.getLeft();
        log.info("{} Common config ...", (Object)"\ud83d\udcb0 Register Daily Rewards");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec);
    }

    public static class Config {
        public final ForgeConfigSpec.IntValue rewardTimePerDay;
        public final ForgeConfigSpec.ConfigValue<List<String>> normalFillItems;
        public final ForgeConfigSpec.ConfigValue<List<String>> rareFillItems;
        public final ForgeConfigSpec.ConfigValue<List<String>> rewardsJanuaryItems;
        public final ForgeConfigSpec.ConfigValue<List<String>> rewardsFebruaryItems;
        public final ForgeConfigSpec.ConfigValue<List<String>> rewardsMarchItems;
        public final ForgeConfigSpec.ConfigValue<List<String>> rewardsAprilItems;
        public final ForgeConfigSpec.ConfigValue<List<String>> rewardsMayItems;
        public final ForgeConfigSpec.ConfigValue<List<String>> rewardsJuneItems;
        public final ForgeConfigSpec.ConfigValue<List<String>> rewardsJulyItems;
        public final ForgeConfigSpec.ConfigValue<List<String>> rewardsAugustItems;
        public final ForgeConfigSpec.ConfigValue<List<String>> rewardsSeptemberItems;
        public final ForgeConfigSpec.ConfigValue<List<String>> rewardsOctoberItems;
        public final ForgeConfigSpec.ConfigValue<List<String>> rewardsNovemberItems;
        public final ForgeConfigSpec.ConfigValue<List<String>> rewardsDecemberItems;

        Config(ForgeConfigSpec.Builder builder) {
            builder.comment("Daily Rewards (General configuration)");
            builder.push("General");
            this.rewardTimePerDay = builder.comment("Time in minutes the players needs to be online on the server before receiving a reward for the day.").defineInRange("rewardTimePerDay", 30, 1, 1440);
            builder.pop();
            builder.push("Fill Items");
            this.normalFillItems = builder.comment("List of normal fill items which are used in the case we have not enough valid items for a month.").define("normalFillItems", new ArrayList<String>(Arrays.asList("minecraft:cooked_beef:16", "minecraft:iron_ingot:8", "minecraft:oak_log:16", "minecraft:white_wool:4", "minecraft:gold_ingot:8", "minecraft:wheat_seeds:16", "minecraft:pumpkin_seeds:16", "minecraft:melon_seeds:16", "minecraft:beetroot_seeds:16", "minecraft:arrow:32")));
            this.rareFillItems = builder.comment("List of rare fill items which are used in the case we have not enough valid items for a month.").define("rareFillItems", new ArrayList<String>(Arrays.asList("minecraft:diamond", "minecraft:quartz:3", "minecraft:spyglass")));
            builder.pop();
            builder.push("Rewards Items");
            this.rewardsJanuaryItems = builder.comment("List of rewards items for January.").define("rewardsJanuaryItems", new ArrayList<String>(Arrays.asList(new String[0])));
            this.rewardsFebruaryItems = builder.comment("List of rewards items for February.").define("rewardsFebruaryItems", new ArrayList<String>(Arrays.asList(new String[0])));
            this.rewardsMarchItems = builder.comment("List of rewards items for March.").define("rewardsMarchItems", new ArrayList<String>(Arrays.asList(new String[0])));
            this.rewardsAprilItems = builder.comment("List of rewards items for April.").define("rewardsAprilItems", new ArrayList<String>(Arrays.asList(new String[0])));
            this.rewardsMayItems = builder.comment("List of rewards items for May.").define("rewardsMayItems", new ArrayList<String>(Arrays.asList("minecraft:egg:16")));
            this.rewardsJuneItems = builder.comment("List of rewards items for June.").define("rewardsJuneItems", new ArrayList<String>(Arrays.asList(new String[0])));
            this.rewardsJulyItems = builder.comment("List of rewards items for July.").define("rewardsJulyItems", new ArrayList<String>(Arrays.asList(new String[0])));
            this.rewardsAugustItems = builder.comment("List of rewards items for August.").define("rewardsAugustItems", new ArrayList<String>(Arrays.asList(new String[0])));
            this.rewardsSeptemberItems = builder.comment("List of rewards items for September.").define("rewardsSeptemberItems", new ArrayList<String>(Arrays.asList(new String[0])));
            this.rewardsOctoberItems = builder.comment("List of rewards items for October.").define("rewardsOctoberItems", new ArrayList<String>(Arrays.asList(new String[0])));
            this.rewardsNovemberItems = builder.comment("List of rewards items for November.").define("rewardsNovemberItems", new ArrayList<String>(Arrays.asList(new String[0])));
            this.rewardsDecemberItems = builder.comment("List of rewards items for December.").define("rewardsDecemberItems", new ArrayList<String>(Arrays.asList(new String[0])));
            builder.pop();
        }
    }
}

