/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.dailyrewards.data;

import de.markusbordihn.dailyrewards.rewards.Rewards;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RewardData
extends SavedData {
    public static final Logger log = LogManager.getLogger((String)"Daily Rewards");
    public static final String ITEMS_TAG = "RewardItems";
    public static final String ITEM_LIST_TAG = "ItemList";
    public static final String REWARDS_TAG = "Rewards";
    public static final String YEAR_MONTH_TAG = "YearMonth";
    private static final String FILE_ID = "daily_rewards";
    private static MinecraftServer server;
    private static RewardData data;
    private static ConcurrentHashMap<String, List<ItemStack>> rewardItemsMap;

    public RewardData() {
        this.m_77762_();
    }

    public static void prepare(MinecraftServer server) {
        if (server == null || server == RewardData.server && data != null) {
            return;
        }
        log.info("{} preparing reward data for {}", (Object)"Daily Rewards", (Object)server);
        RewardData.server = server;
        data = (RewardData)server.m_129880_(Level.f_46428_).m_8895_().m_164861_(RewardData::load, RewardData::new, RewardData.getFileId());
    }

    public static boolean available() {
        RewardData.get();
        return data != null;
    }

    public static RewardData get() {
        if (data == null) {
            RewardData.prepare(ServerLifecycleHooks.getCurrentServer());
        }
        return data;
    }

    public static String getFileId() {
        return FILE_ID;
    }

    public static String getKeyId(int year, int month) {
        return year + "-" + month;
    }

    public List<ItemStack> getRewardsFor(int year, int month) {
        String key = RewardData.getKeyId(year, month);
        return rewardItemsMap.computeIfAbsent(key, id -> Rewards.calculateRewardItemsForMonth(month));
    }

    public List<ItemStack> getRewardsForCurrentMonth() {
        return this.getRewardsFor(Rewards.getCurrentYear(), Rewards.getCurrentMonth());
    }

    public CompoundTag getRewardsForCurrentMonthSyncData() {
        List<ItemStack> rewardItems = this.getRewardsForCurrentMonth();
        CompoundTag syncData = new CompoundTag();
        ListTag itemListTag = new ListTag();
        for (int i = 0; i < rewardItems.size(); ++i) {
            ItemStack itemStack = rewardItems.get(i);
            CompoundTag itemStackTag = new CompoundTag();
            itemStack.m_41739_(itemStackTag);
            itemListTag.add((Object)itemStackTag);
        }
        syncData.m_128365_(ITEM_LIST_TAG, (Tag)itemListTag);
        return syncData;
    }

    public ItemStack getRewardForCurrentMonth(int day) {
        int rewardIndex;
        List<ItemStack> rewards = this.getRewardsForCurrentMonth();
        if ((rewardIndex = --day) >= 0 && rewards.size() > rewardIndex) {
            return rewards.get(rewardIndex).m_41777_();
        }
        return ItemStack.f_41583_;
    }

    public static RewardData load(CompoundTag compoundTag) {
        RewardData rewardData = new RewardData();
        log.info("{} loading reward data ... {}", (Object)"Daily Rewards", (Object)compoundTag);
        if (compoundTag.m_128441_(REWARDS_TAG)) {
            ListTag listTag = compoundTag.m_128437_(REWARDS_TAG, 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag rewardTag = listTag.m_128728_(i);
                ArrayList<ItemStack> rewardItems = new ArrayList<ItemStack>();
                ListTag itemListTag = rewardTag.m_128437_(ITEMS_TAG, 10);
                String yearMonthKey = rewardTag.m_128461_(YEAR_MONTH_TAG);
                for (int i2 = 0; i2 < itemListTag.size(); ++i2) {
                    ItemStack itemStack = ItemStack.m_41712_((CompoundTag)itemListTag.m_128728_(i2));
                    rewardItems.add(itemStack);
                }
                rewardItemsMap.put(yearMonthKey, rewardItems);
            }
        }
        log.debug("{} Loaded stored rewards data from disk: {}", (Object)"Daily Rewards", rewardItemsMap);
        return rewardData;
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        log.info("{} saving reward data ... {}", (Object)"Daily Rewards", rewardItemsMap);
        ListTag listTag = new ListTag();
        for (Map.Entry<String, List<ItemStack>> reward : rewardItemsMap.entrySet()) {
            CompoundTag rewardTag = new CompoundTag();
            List<ItemStack> rewardItems = reward.getValue();
            ListTag itemListTag = new ListTag();
            for (int i = 0; i < rewardItems.size(); ++i) {
                ItemStack itemStack = rewardItems.get(i);
                if (itemStack.m_41619_()) {
                    log.error("Reward item for month {} and day {} is empty, will fill item!", (Object)reward.getKey(), (Object)i);
                    itemStack = Rewards.getNormalFillItem();
                }
                CompoundTag itemStackTag = new CompoundTag();
                itemStack.m_41739_(itemStackTag);
                itemListTag.add((Object)itemStackTag);
            }
            if (itemListTag.isEmpty()) continue;
            rewardTag.m_128359_(YEAR_MONTH_TAG, reward.getKey());
            rewardTag.m_128365_(ITEMS_TAG, (Tag)itemListTag);
            listTag.add((Object)rewardTag);
        }
        compoundTag.m_128365_(REWARDS_TAG, (Tag)listTag);
        return compoundTag;
    }

    static {
        rewardItemsMap = new ConcurrentHashMap();
    }
}

