/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.dailyrewards.player;

import de.markusbordihn.dailyrewards.config.CommonConfig;
import de.markusbordihn.dailyrewards.data.RewardData;
import de.markusbordihn.dailyrewards.data.RewardUserData;
import de.markusbordihn.dailyrewards.network.NetworkHandler;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class PlayerRewardManager {
    private static final Logger log = LogManager.getLogger((String)"Daily Rewards");
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static int rewardTimePerDay = (Integer)PlayerRewardManager.COMMON.rewardTimePerDay.get();
    private static int rewardTimePerDayTicks = rewardTimePerDay * 60 * 20;
    private static final short REWARD_CHECK_TICK = 1200;
    private static final MutableComponent claimCommand = new TextComponent("/DailyRewards claim").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/DailyRewards claim")));
    private static short ticker = 0;
    private static Set<ServerPlayer> playerList = ConcurrentHashMap.newKeySet();

    protected PlayerRewardManager() {
    }

    @SubscribeEvent
    public static void onServerAboutToStartEvent(ServerAboutToStartEvent event) {
        playerList = ConcurrentHashMap.newKeySet();
        rewardTimePerDay = (Integer)PlayerRewardManager.COMMON.rewardTimePerDay.get();
        rewardTimePerDayTicks = rewardTimePerDay * 60 * 20;
        log.info("Daily rewards will be granted after {} min ({} ticks) a player is online.", (Object)rewardTimePerDay, (Object)rewardTimePerDayTicks);
    }

    @SubscribeEvent
    public static void handlePlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        String username = event.getPlayer().m_7755_().getString();
        if (username.isEmpty()) {
            return;
        }
        ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11255_(username);
        log.debug("{} Player {} {} logged in.", (Object)"Daily Rewards", (Object)username, (Object)player);
        NetworkHandler.syncGeneralRewardForCurrentMonth(player);
        NetworkHandler.syncUserRewardForCurrentMonth(player);
        playerList.add(player);
    }

    @SubscribeEvent
    public static void handlePlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        String username = event.getPlayer().m_7755_().getString();
        if (username.isEmpty()) {
            return;
        }
        ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11255_(username);
        log.debug("{} Player {} {} logged out.", (Object)"Daily Rewards", (Object)username, (Object)player);
        playerList.remove(player);
    }

    @SubscribeEvent
    public static void handleServerTickEvent(TickEvent.ServerTickEvent event) {
        block7: {
            block6: {
                if (event.phase == TickEvent.Phase.END) break block6;
                short s = ticker;
                ticker = (short)(s + 1);
                if (s >= 1200 && !playerList.isEmpty()) break block7;
            }
            return;
        }
        for (ServerPlayer player : playerList) {
            if (player.f_19797_ <= rewardTimePerDayTicks) continue;
            UUID uuid = player.m_142081_();
            RewardUserData rewardUserData = RewardUserData.get();
            if (rewardUserData.hasRewardedToday(uuid)) continue;
            rewardUserData.setLastRewardedDayForCurrentMonth(uuid);
            int rewardedDays = rewardUserData.increaseRewardedDaysForCurrentMonth(uuid);
            ItemStack itemStack = RewardData.get().getRewardForCurrentMonth(rewardedDays);
            if (itemStack.m_41619_()) {
                log.error("Reward {} for day {} for current month was empty!", (Object)itemStack, (Object)rewardedDays);
            } else {
                rewardUserData.addRewardForCurrentMonth(rewardedDays, uuid, itemStack);
                player.m_6352_((Component)new TranslatableComponent("text.daily_rewards.rewarded_item", new Object[]{player.m_7755_(), itemStack, rewardedDays}), Util.f_137441_);
                player.m_6352_((Component)new TranslatableComponent("text.daily_rewards.claim_rewards", new Object[]{claimCommand}), Util.f_137441_);
                NetworkHandler.syncUserRewardForCurrentMonth(player);
            }
            log.info("Reward player {} daily reward for {} days with {} ...", (Object)player, (Object)rewardedDays, (Object)itemStack);
        }
        ticker = 0;
    }
}

