/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntityCrow;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class CrowAICircleCrops
extends MoveToBlockGoal {
    private EntityCrow crow;
    private int idleAtFlowerTime = 0;
    private boolean isAboveDestinationBear;
    float circlingTime = 0.0f;
    float circleDistance = 2.0f;
    float maxCirclingTime = 80.0f;
    float yLevel = 2.0f;
    boolean clockwise = false;
    boolean circlePhase = false;

    public CrowAICircleCrops(EntityCrow bird) {
        super((PathfinderMob)bird, 1.0, 32, 8);
        this.crow = bird;
    }

    public void m_8056_() {
        super.m_8056_();
        this.circlePhase = true;
        this.clockwise = this.crow.m_21187_().nextBoolean();
        this.yLevel = 1 + this.crow.m_21187_().nextInt(3);
        this.circleDistance = 1 + this.crow.m_21187_().nextInt(3);
    }

    public boolean m_8036_() {
        return !this.crow.m_6162_() && (this.crow.m_5448_() == null || !this.crow.m_5448_().m_6084_()) && !this.crow.m_21824_() && this.crow.fleePumpkinFlag == 0 && !this.crow.aiItemFlag && super.m_8036_();
    }

    public boolean m_8045_() {
        return this.f_25602_ != null && (this.crow.m_5448_() == null || !this.crow.m_5448_().m_6084_()) && !this.crow.m_21824_() && !this.crow.aiItemFlag && this.crow.fleePumpkinFlag == 0 && super.m_8045_();
    }

    public void m_8041_() {
        this.idleAtFlowerTime = 0;
        this.circlingTime = 0.0f;
        this.f_25601_ = 0;
        this.f_25602_ = BlockPos.f_121853_;
    }

    public double m_8052_() {
        return 1.0;
    }

    public void m_8037_() {
        if (this.f_25602_ == null) {
            return;
        }
        BlockPos blockpos = this.m_6669_();
        if (this.circlePhase) {
            this.f_25601_ = 0;
            BlockPos circlePos = this.getVultureCirclePos(blockpos);
            if (circlePos != null) {
                this.crow.setFlying(true);
                this.crow.m_21566_().m_6849_((double)circlePos.m_123341_() + 0.5, (double)circlePos.m_123342_() + 0.5, (double)circlePos.m_123343_() + 0.5, (double)0.7f);
            }
            this.circlingTime += 1.0f;
            if (this.circlingTime > 200.0f) {
                this.circlingTime = 0.0f;
                this.circlePhase = false;
            }
        } else {
            super.m_8037_();
            if (this.crow.m_20096_()) {
                this.crow.setFlying(false);
            }
            if (!this.isWithinXZDist(blockpos, this.f_25598_.m_20182_(), this.m_8052_())) {
                this.isAboveDestinationBear = false;
                ++this.f_25601_;
                this.f_25598_.m_21573_().m_26519_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() - 0.5, (double)blockpos.m_123343_() + 0.5, 1.0);
            } else {
                this.isAboveDestinationBear = true;
                --this.f_25601_;
            }
            if (this.m_25625_()) {
                this.crow.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3((double)this.f_25602_.m_123341_() + 0.5, (double)this.f_25602_.m_123342_(), (double)this.f_25602_.m_123343_() + 0.5));
                if (this.idleAtFlowerTime >= 5) {
                    this.pollinate();
                    this.m_8041_();
                } else {
                    this.crow.peck();
                    ++this.idleAtFlowerTime;
                }
            }
        }
    }

    public BlockPos getVultureCirclePos(BlockPos target) {
        float angle = 0.13962634f * (this.clockwise ? -this.circlingTime : this.circlingTime);
        double extraX = this.circleDistance * Mth.m_14031_((float)angle);
        double extraZ = this.circleDistance * Mth.m_14089_((float)angle);
        BlockPos pos = new BlockPos((double)((float)target.m_123341_() + 0.5f) + extraX, (double)((float)(target.m_123342_() + 1) + this.yLevel), (double)((float)target.m_123343_() + 0.5f) + extraZ);
        if (this.crow.f_19853_.m_46859_(pos)) {
            return pos;
        }
        return null;
    }

    private boolean isWithinXZDist(BlockPos blockpos, Vec3 positionVec, double distance) {
        return blockpos.m_123331_((Vec3i)new BlockPos(positionVec.m_7096_(), (double)blockpos.m_123342_(), positionVec.m_7094_())) < distance * distance;
    }

    protected boolean m_25625_() {
        return this.isAboveDestinationBear;
    }

    private void pollinate() {
        if (this.crow.f_19853_.m_8055_(this.f_25602_).m_60734_() instanceof CropBlock) {
            CropBlock block = (CropBlock)this.crow.f_19853_.m_8055_(this.f_25602_).m_60734_();
            int cropAge = (Integer)this.crow.f_19853_.m_8055_(this.f_25602_).m_61143_((Property)block.m_7959_());
            if (cropAge > 0) {
                this.crow.f_19853_.m_46597_(this.f_25602_, (BlockState)this.crow.f_19853_.m_8055_(this.f_25602_).m_61124_((Property)block.m_7959_(), (Comparable)Integer.valueOf(cropAge - 1)));
            } else {
                this.crow.f_19853_.m_46961_(this.f_25602_, true);
            }
            this.m_8041_();
        } else {
            this.crow.f_19853_.m_46961_(this.f_25602_, true);
            this.m_8041_();
        }
        this.f_25601_ = 1200;
    }

    protected boolean m_6465_(LevelReader worldIn, BlockPos pos) {
        return worldIn.m_8055_(pos).m_204336_(AMTagRegistry.CROW_FOODBLOCKS);
    }
}

