/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.ingredients.IngredientInfo;
import org.jetbrains.annotations.Unmodifiable;

public class RegisteredIngredients {
    private final @Unmodifiable List<IIngredientType<?>> orderedTypes;
    private final @Unmodifiable Map<IIngredientType<?>, IngredientInfo<?>> typeToInfo;
    private final Map<Class<?>, IIngredientType<?>> classToType;

    public RegisteredIngredients(List<IngredientInfo<?>> ingredientInfoList) {
        this.orderedTypes = ingredientInfoList.stream().map(IngredientInfo::getIngredientType).toList();
        this.typeToInfo = ingredientInfoList.stream().collect(Collectors.toUnmodifiableMap(IngredientInfo::getIngredientType, Function.identity()));
        this.classToType = this.orderedTypes.stream().collect(Collectors.toMap(IIngredientType::getIngredientClass, Function.identity()));
    }

    public <V> IngredientInfo<V> getIngredientInfo(IIngredientType<V> ingredientType) {
        IngredientInfo<?> ingredientInfo = this.typeToInfo.get(ingredientType);
        if (ingredientInfo == null) {
            throw new IllegalArgumentException("Unknown ingredient type: " + ingredientType.getIngredientClass());
        }
        return ingredientInfo;
    }

    public <V> IIngredientHelper<V> getIngredientHelper(IIngredientType<V> ingredientType) {
        IngredientInfo<V> ingredientInfo = this.getIngredientInfo(ingredientType);
        return ingredientInfo.getIngredientHelper();
    }

    public <V> IIngredientRenderer<V> getIngredientRenderer(IIngredientType<V> ingredientType) {
        IngredientInfo<V> ingredientInfo = this.getIngredientInfo(ingredientType);
        return ingredientInfo.getIngredientRenderer();
    }

    public @Unmodifiable List<IIngredientType<?>> getIngredientTypes() {
        return this.orderedTypes;
    }

    public <V> IIngredientType<V> getIngredientType(V ingredient) {
        Class<?> ingredientClass = ingredient.getClass();
        return this.getIngredientType(ingredientClass);
    }

    public <V> IIngredientType<V> getIngredientType(Class<? extends V> ingredientClass) {
        IIngredientType<?> ingredientType = this.classToType.get(ingredientClass);
        if (ingredientType != null) {
            return ingredientType;
        }
        for (IIngredientType<?> type : this.orderedTypes) {
            if (!type.getIngredientClass().isAssignableFrom(ingredientClass)) continue;
            IIngredientType<?> castType = type;
            this.classToType.put(ingredientClass, castType);
            return castType;
        }
        throw new IllegalArgumentException("Unknown ingredient class: " + ingredientClass);
    }
}

