/*
 * Decompiled with CFR 0.152.
 */
package L_Ender.cataclysm.entity;

import L_Ender.cataclysm.config.CMConfig;
import L_Ender.cataclysm.entity.AI.AnimationGoal;
import L_Ender.cataclysm.entity.AI.CmAttackGoal;
import L_Ender.cataclysm.entity.AI.SimpleAnimationGoal;
import L_Ender.cataclysm.entity.Boss_monster;
import L_Ender.cataclysm.entity.effect.Cm_Falling_Block_Entity;
import L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import L_Ender.cataclysm.entity.etc.CMPathNavigateGround;
import L_Ender.cataclysm.entity.etc.SmartBodyHelper2;
import L_Ender.cataclysm.init.ModEffect;
import L_Ender.cataclysm.init.ModSounds;
import L_Ender.cataclysm.init.ModTag;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Ignis_Entity
extends Boss_monster {
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.PROGRESS).m_7003_(false);
    public static final Animation SWING_ATTACK = Animation.create((int)65);
    public static final Animation HORIZONTAL_SWING_ATTACK = Animation.create((int)68);
    public static final Animation SHIELD_SMASH_ATTACK = Animation.create((int)70);
    public static final Animation PHASE_2 = Animation.create((int)68);
    public static final Animation POKE_ATTACK = Animation.create((int)65);
    public static final Animation POKE_ATTACK2 = Animation.create((int)56);
    public static final Animation POKE_ATTACK3 = Animation.create((int)50);
    public static final Animation POKED_ATTACK = Animation.create((int)65);
    public static final Animation PHASE_3 = Animation.create((int)127);
    public static final Animation MAGIC_ATTACK = Animation.create((int)95);
    public static final Animation SMASH_IN_AIR = Animation.create((int)105);
    public static final Animation SMASH = Animation.create((int)47);
    public static final Animation BODY_CHECK_ATTACK1 = Animation.create((int)62);
    public static final Animation BODY_CHECK_ATTACK2 = Animation.create((int)62);
    public static final Animation BODY_CHECK_ATTACK3 = Animation.create((int)62);
    public static final Animation BODY_CHECK_ATTACK4 = Animation.create((int)62);
    public static final Animation BURNS_THE_EARTH = Animation.create((int)67);
    public static final Animation TRIPLE_ATTACK = Animation.create((int)139);
    public static final Animation BREAK_THE_SHIELD = Animation.create((int)90);
    public static final int BODY_CHECK_COOLDOWN = 200;
    private static final EntityDataAccessor<Boolean> IS_BLOCKING = SynchedEntityData.m_135353_(Ignis_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SHIELD_DURABILITY = SynchedEntityData.m_135353_(Ignis_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_SHIELD = SynchedEntityData.m_135353_(Ignis_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_SWORD = SynchedEntityData.m_135353_(Ignis_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> BOSS_PHASE = SynchedEntityData.m_135353_(Ignis_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Vec3 prevBladePos = new Vec3(0.0, 0.0, 0.0);
    private int body_check_cooldown = 0;
    private int timeWithoutTarget;
    public float blockingProgress;
    public float swordProgress;
    public float prevblockingProgress;
    public float prevswordProgress;

    public Ignis_Entity(EntityType entity, Level world) {
        super(entity, world);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.f_19793_ = 2.5f;
        if (world.f_46443_) {
            this.socketPosArray = new Vec3[]{new Vec3(0.0, 0.0, 0.0)};
        }
        Ignis_Entity.setConfigattribute((LivingEntity)this, CMConfig.IgnisHealthMultiplier, CMConfig.IgnisDamageMultiplier);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, SWING_ATTACK, HORIZONTAL_SWING_ATTACK, POKE_ATTACK, POKE_ATTACK2, POKE_ATTACK3, POKED_ATTACK, MAGIC_ATTACK, PHASE_3, SHIELD_SMASH_ATTACK, PHASE_2, BODY_CHECK_ATTACK4, BODY_CHECK_ATTACK3, BODY_CHECK_ATTACK2, BODY_CHECK_ATTACK1, SMASH, SMASH_IN_AIR, BURNS_THE_EARTH, TRIPLE_ATTACK, BREAK_THE_SHIELD};
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(2, (Goal)new CmAttackGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new Hornzontal_Swing(this, HORIZONTAL_SWING_ATTACK));
        this.f_21345_.m_25352_(1, (Goal)new Poke(this));
        this.f_21345_.m_25352_(1, (Goal)new Phase_Transition(this, PHASE_2));
        this.f_21345_.m_25352_(1, (Goal)new Phase_Transition2(this, PHASE_3));
        this.f_21345_.m_25352_(1, (Goal)new Shield_Smash(this, SHIELD_SMASH_ATTACK));
        this.f_21345_.m_25352_(1, (Goal)new Body_Check(this));
        this.f_21345_.m_25352_(1, (Goal)new Poked(this, POKED_ATTACK));
        this.f_21345_.m_25352_(1, (Goal)new Air_Smash(this, SMASH_IN_AIR));
        this.f_21345_.m_25352_(1, new SimpleAnimationGoal<Ignis_Entity>(this, SMASH));
        this.f_21345_.m_25352_(1, (Goal)new Vertical_Swing(this, SWING_ATTACK));
        this.f_21345_.m_25352_(1, (Goal)new Triple_Attack(this, TRIPLE_ATTACK));
        this.f_21345_.m_25352_(1, (Goal)new Break_the_Shield(this, BREAK_THE_SHIELD));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    @Override
    public boolean m_6469_(DamageSource source, float damage) {
        double range = this.calculateRange(source);
        if (range > CMConfig.IgnisLongRangelimit * CMConfig.IgnisLongRangelimit) {
            return false;
        }
        if (!source.m_19378_()) {
            damage = Math.min((float)CMConfig.IgnisDamageCap, damage);
        }
        if (this.getAnimation() == PHASE_2 && !source.m_19378_()) {
            return false;
        }
        Entity entity = source.m_7640_();
        if (damage > 0.0f && this.canBlockDamageSource(source)) {
            this.m_7909_(damage);
            if (!source.m_19360_() && entity instanceof LivingEntity) {
                this.m_6728_((LivingEntity)entity);
            }
            this.m_5496_(SoundEvents.f_11704_, 0.5f, 0.4f + this.m_21187_().nextFloat() * 0.1f);
            return false;
        }
        return super.m_6469_(source, damage);
    }

    private boolean canBlockDamageSource(DamageSource damageSourceIn) {
        Vec3 vector3d2;
        AbstractArrow abstractarrowentity;
        Entity entity = damageSourceIn.m_7640_();
        boolean flag = false;
        if (entity instanceof AbstractArrow && (abstractarrowentity = (AbstractArrow)entity).m_36796_() > 0) {
            flag = true;
        }
        if (!damageSourceIn.m_19376_() && !flag && this.getIsShield() && (vector3d2 = damageSourceIn.m_7270_()) != null) {
            Vec3 vector3d = this.m_20252_(1.0f);
            Vec3 vector3d1 = vector3d2.m_82505_(this.m_20182_()).m_82541_();
            vector3d1 = new Vec3(vector3d1.f_82479_, 0.0, vector3d1.f_82481_);
            return vector3d1.m_82526_(vector3d) < 0.0;
        }
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_BLOCKING, (Object)false);
        this.f_19804_.m_135372_(IS_SHIELD, (Object)false);
        this.f_19804_.m_135372_(SHIELD_DURABILITY, (Object)5);
        this.f_19804_.m_135372_(IS_SWORD, (Object)false);
        this.f_19804_.m_135372_(BOSS_PHASE, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("BossPhase", this.getBossPhase());
        compound.m_128405_("Shield_Durability", this.getShieldDurability());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setBossPhase(compound.m_128451_("BossPhase"));
        this.setShieldDurability(compound.m_128451_("Shield_Durability"));
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
    }

    public void setIsBlocking(boolean isBlocking) {
        this.f_19804_.m_135381_(IS_BLOCKING, (Object)isBlocking);
    }

    public boolean getIsBlocking() {
        return (Boolean)this.f_19804_.m_135370_(IS_BLOCKING);
    }

    public void setIsShield(boolean isShield) {
        this.f_19804_.m_135381_(IS_SHIELD, (Object)isShield);
    }

    public boolean getIsShield() {
        return (Boolean)this.f_19804_.m_135370_(IS_SHIELD);
    }

    public void setIsSword(boolean isSword) {
        this.f_19804_.m_135381_(IS_SWORD, (Object)isSword);
    }

    public boolean getIsSword() {
        return (Boolean)this.f_19804_.m_135370_(IS_SWORD);
    }

    public void setShieldDurability(int ShieldDurability) {
        this.f_19804_.m_135381_(SHIELD_DURABILITY, (Object)ShieldDurability);
    }

    public int getShieldDurability() {
        return (Integer)this.f_19804_.m_135370_(SHIELD_DURABILITY);
    }

    public void setBossPhase(int bossPhase) {
        this.f_19804_.m_135381_(BOSS_PHASE, (Object)bossPhase);
    }

    public int getBossPhase() {
        return (Integer)this.f_19804_.m_135370_(BOSS_PHASE);
    }

    public static AttributeSupplier.Builder ignis() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 50.0).m_22268_(Attributes.f_22279_, (double)0.33f).m_22268_(Attributes.f_22281_, 14.0).m_22268_(Attributes.f_22276_, 333.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public float m_6073_() {
        return 1.0f;
    }

    protected int m_7302_(int air) {
        return air;
    }

    public boolean m_142535_(float p_148711_, float p_148712_, DamageSource p_148713_) {
        return false;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.IGNIS_AMBIENT.get();
    }

    private static Animation getRandomPoke(Random rand) {
        switch (rand.nextInt(3)) {
            case 0: {
                return POKE_ATTACK;
            }
            case 1: {
                return POKE_ATTACK2;
            }
            case 2: {
                return POKE_ATTACK3;
            }
        }
        return POKE_ATTACK;
    }

    public void m_8119_() {
        if (!this.f_19861_ && this.m_20184_().f_82480_ < 0.0 && this.getAnimation() == NO_ANIMATION && !this.getIsBlocking() && !this.getIsSword()) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        this.prevblockingProgress = this.blockingProgress;
        this.prevswordProgress = this.swordProgress;
        if (this.getIsBlocking() && this.blockingProgress < 10.0f) {
            this.blockingProgress += 1.0f;
        }
        if (!this.getIsBlocking() && this.blockingProgress > 0.0f) {
            this.blockingProgress -= 1.0f;
        }
        if (this.getIsSword() && this.swordProgress < 10.0f) {
            this.swordProgress += 1.0f;
        }
        if (!this.getIsSword() && this.swordProgress > 0.0f) {
            this.swordProgress -= 1.0f;
        }
        if (!this.m_20197_().isEmpty() && ((Entity)this.m_20197_().get(0)).m_6144_()) {
            ((Entity)this.m_20197_().get(0)).m_20260_(false);
        }
        LivingEntity target = this.m_5448_();
        this.SwingParticles();
        if (this.f_19853_.f_46443_) {
            if (this.f_19796_.nextInt(24) == 0 && !this.m_20067_()) {
                this.f_19853_.m_7785_(this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5, SoundEvents.f_11702_, this.m_5720_(), 1.0f + this.f_19796_.nextFloat(), this.f_19796_.nextFloat() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        } else {
            ++this.timeWithoutTarget;
            if (target != null) {
                this.timeWithoutTarget = 0;
                if (this.getShieldDurability() < 1) {
                    if (!this.getIsSword()) {
                        this.setIsSword(true);
                    }
                    if (this.getIsBlocking()) {
                        this.setIsBlocking(false);
                    }
                } else {
                    if (!this.getIsBlocking()) {
                        this.setIsBlocking(true);
                    }
                    if (this.getIsSword()) {
                        this.setIsSword(false);
                    }
                }
            }
            if (this.getAnimation() == NO_ANIMATION && this.timeWithoutTarget > 150 && (this.getIsBlocking() || this.getIsSword()) && target == null) {
                this.timeWithoutTarget = 0;
                this.setIsSword(false);
                this.setIsBlocking(false);
            }
            if (this.getShieldDurability() < 1 && this.getIsBlocking()) {
                this.setIsBlocking(false);
                this.setIsSword(true);
            }
            if (this.getAnimation() == NO_ANIMATION && this.getShieldDurability() == 1) {
                this.setShieldDurability(0);
            }
            if (this.getBossPhase() > 0) {
                this.bossInfo.m_6451_(BossEvent.BossBarColor.BLUE);
            }
            if (this.getBossPhase() > 1) {
                this.bossInfo.m_7003_(true);
                this.setShieldDurability(0);
            }
        }
        if (this.body_check_cooldown > 0) {
            --this.body_check_cooldown;
        }
        this.repelEntities(1.7f, 4.0f, 1.7f, 1.7f);
        this.m_146922_(this.f_20883_);
        if (this.m_6084_()) {
            if (!this.m_21525_() && this.getAnimation() == NO_ANIMATION && this.m_21223_() <= this.m_21233_() / 2.0f && this.getBossPhase() < 1) {
                this.setAnimation(PHASE_2);
            } else if (target != null && target.m_6084_() && (this.blockingProgress == 10.0f || this.swordProgress == 10.0f)) {
                if (!this.m_21525_() && this.getAnimation() == NO_ANIMATION && this.m_20280_((Entity)target) >= 64.0 && this.m_20280_((Entity)target) <= 1024.0 && target.m_20096_() && this.m_21187_().nextFloat() * 100.0f < 0.9f && this.getIsShield()) {
                    this.setAnimation(SMASH_IN_AIR);
                } else if (!this.m_21525_() && this.getAnimation() == NO_ANIMATION && this.m_20270_((Entity)target) < 7.0f && this.m_21187_().nextFloat() * 100.0f < 6.0f) {
                    Animation animation = Ignis_Entity.getRandomPoke(this.f_19796_);
                    this.setAnimation(animation);
                } else if (!this.m_21525_() && this.getAnimation() == NO_ANIMATION && this.m_20270_((Entity)target) < 5.0f && this.m_21187_().nextFloat() * 100.0f < 12.0f) {
                    if (this.f_19796_.nextInt(3) == 0) {
                        this.setAnimation(HORIZONTAL_SWING_ATTACK);
                    } else {
                        this.setAnimation(SWING_ATTACK);
                    }
                } else if (!this.m_21525_() && this.getAnimation() == NO_ANIMATION && this.m_20270_((Entity)target) < 3.0f && this.m_21187_().nextFloat() * 100.0f < 20.0f && this.getIsShield()) {
                    this.setAnimation(SHIELD_SMASH_ATTACK);
                } else if (!this.m_21525_() && this.getAnimation() == NO_ANIMATION && this.m_20270_((Entity)target) < 3.0f && this.m_21187_().nextFloat() * 100.0f < 10.0f && this.body_check_cooldown <= 0) {
                    this.body_check_cooldown = 200;
                    this.setAnimation(BODY_CHECK_ATTACK1);
                }
            }
        }
        super.m_8119_();
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.getIsBlocking() && this.blockingProgress == 10.0f) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.setIsShield(true);
            } else if (this.getAnimation() == POKED_ATTACK) {
                this.setIsShield(false);
            } else if (this.getAnimation() == HORIZONTAL_SWING_ATTACK) {
                this.setIsShield(this.getAnimationTick() > 31);
            } else if (this.getAnimation() == BODY_CHECK_ATTACK1 || this.getAnimation() == BODY_CHECK_ATTACK2 || this.getAnimation() == BODY_CHECK_ATTACK3 || this.getAnimation() == BODY_CHECK_ATTACK4) {
                this.setIsShield(this.getAnimationTick() < 25);
            } else if (this.getAnimation() == POKE_ATTACK) {
                this.setIsShield(this.getAnimationTick() < 39);
            } else if (this.getAnimation() == POKE_ATTACK2) {
                this.setIsShield(this.getAnimationTick() < 34);
            } else if (this.getAnimation() == POKE_ATTACK3) {
                this.setIsShield(this.getAnimationTick() < 29);
            } else if (this.getAnimation() == SWING_ATTACK) {
                this.setIsShield(this.getAnimationTick() < 34);
            }
        } else {
            this.setIsShield(false);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.getAnimation() == SWING_ATTACK && this.getAnimationTick() == 34) {
            this.m_5496_((SoundEvent)ModSounds.STRONGSWING.get(), 1.0f, 1.0f + this.m_21187_().nextFloat() * 0.1f);
            this.AreaAttack(5.5f, 6.0f, 60.0f, 1.2f, 0.08f, 100, 5, 150);
        }
        if (this.getAnimation() == HORIZONTAL_SWING_ATTACK && this.getAnimationTick() == 31) {
            this.m_5496_((SoundEvent)ModSounds.STRONGSWING.get(), 1.0f, 1.0f + this.m_21187_().nextFloat() * 0.1f);
            this.AreaAttack(5.5f, 6.0f, 170.0f, 1.1f, 0.06f, 80, 3, 150);
        }
        if (this.getAnimation() == BREAK_THE_SHIELD) {
            if (this.getAnimationTick() == 28) {
                this.setShieldDurability(1);
            }
            if (this.getAnimationTick() == 79) {
                this.setShieldDurability(0);
            }
        }
        if (this.getAnimation() == PHASE_2) {
            if (this.getAnimationTick() == 29) {
                this.m_5496_((SoundEvent)ModSounds.FLAME_BURST.get(), 1.0f, 1.0f + this.m_21187_().nextFloat() * 0.1f);
            }
            if (this.getAnimationTick() > 29 && this.getAnimationTick() < 39) {
                this.Sphereparticle(2.0f, 0.0f, 5.0f);
                this.Phase_Transition(0.4f, 0.03f, 5, 150);
            }
            if (this.getAnimationTick() == 34) {
                this.setBossPhase(1);
            }
        }
        if (this.getAnimation() == PHASE_3) {
            if (this.getAnimationTick() == 58) {
                this.setBossPhase(2);
                this.m_5496_((SoundEvent)ModSounds.FLAME_BURST.get(), 1.0f, 1.0f + this.m_21187_().nextFloat() * 0.1f);
                this.m_5496_((SoundEvent)ModSounds.SWORD_STOMP.get(), 1.0f, 0.75f + this.m_21187_().nextFloat() * 0.1f);
                ScreenShake_Entity.ScreenShake(this.f_19853_, this.m_20182_(), 30.0f, 0.15f, 0, 50);
                this.ShieldSmashparticle(0.5f, 1.0f, -0.15f);
            }
            if (this.getAnimationTick() > 58 && this.getAnimationTick() < 68) {
                this.Sphereparticle(0.5f, 1.0f, 6.0f);
                this.Phase_Transition(0.6f, 0.05f, 5, 150);
            }
        }
        if (this.getAnimation() == SHIELD_SMASH_ATTACK) {
            if (this.getAnimationTick() == 34) {
                this.m_5496_(SoundEvents.f_12513_, 1.5f, 0.8f + this.m_21187_().nextFloat() * 0.1f);
                ScreenShake_Entity.ScreenShake(this.f_19853_, this.m_20182_(), 20.0f, 0.3f, 0, 20);
                this.AreaAttack(4.85f, 2.5f, 45.0f, 1.5f, 0.15f, 200, 0, 0);
                this.ShieldSmashDamage(4, 2.75f);
                this.ShieldSmashparticle(1.3f, 2.75f, -0.1f);
            }
            if (this.getAnimationTick() == 37) {
                this.ShieldSmashDamage(5, 2.75f);
            }
            if (this.getAnimationTick() == 40) {
                this.ShieldSmashDamage(6, 2.75f);
            }
        }
        if (this.getAnimation() == SMASH) {
            if (this.getAnimationTick() == 5) {
                this.m_5496_(SoundEvents.f_12513_, 1.5f, 0.8f + this.m_21187_().nextFloat() * 0.1f);
                ScreenShake_Entity.ScreenShake(this.f_19853_, this.m_20182_(), 20.0f, 0.3f, 0, 20);
                this.AreaAttack(4.85f, 2.5f, 45.0f, 1.5f, 0.15f, 200, 0, 0);
                this.ShieldSmashDamage(3, 1.5f);
                this.ShieldSmashparticle(1.3f, 1.5f, 0.0f);
            }
            if (this.getAnimationTick() == 8) {
                this.ShieldSmashDamage(4, 1.5f);
            }
            if (this.getAnimationTick() == 11) {
                this.ShieldSmashDamage(5, 1.5f);
            }
            if (this.getAnimationTick() == 14) {
                this.ShieldSmashDamage(6, 1.5f);
            }
        }
        if (this.getAnimation() == POKE_ATTACK && this.getAnimationTick() == 39) {
            this.Poke(7.0f, 70.0f, 60);
        }
        if (this.getAnimation() == POKE_ATTACK2 && this.getAnimationTick() == 34) {
            this.Poke(7.0f, 65.0f, 50);
        }
        if (this.getAnimation() == POKE_ATTACK3 && this.getAnimationTick() == 29) {
            this.Poke(7.0f, 60.0f, 40);
        }
        if ((this.getAnimation() == BODY_CHECK_ATTACK1 || this.getAnimation() == BODY_CHECK_ATTACK2 || this.getAnimation() == BODY_CHECK_ATTACK3 || this.getAnimation() == BODY_CHECK_ATTACK4) && this.getAnimationTick() == 25) {
            this.BodyCheckAttack(3.0f, 6.0f, 120.0f, 0.8f, 0.03f, 40, 80);
        }
        if (this.getAnimation() == TRIPLE_ATTACK) {
            if (this.getAnimationTick() == 30) {
                this.m_5496_((SoundEvent)ModSounds.STRONGSWING.get(), 1.0f, 1.0f + this.m_21187_().nextFloat() * 0.1f);
                this.AreaAttack(5.5f, 6.0f, 100.0f, 1.0f, 0.05f, 80, 3, 150);
            }
            if (this.getAnimationTick() == 73) {
                this.m_5496_((SoundEvent)ModSounds.STRONGSWING.get(), 1.0f, 1.0f + this.m_21187_().nextFloat() * 0.1f);
                this.AreaAttack(5.5f, 6.0f, 45.0f, 1.1f, 0.06f, 120, 5, 150);
            }
            if (this.getAnimationTick() == 108) {
                this.BodyCheckAttack(4.85f, 6.0f, 60.0f, 1.0f, 0.01f, 40, 0);
            }
        }
    }

    private void AreaAttack(float range, float height, float arc, float damage, float hpdamage, int shieldbreakticks, int firetime, int brandticks) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || entityHit instanceof Ignis_Entity) continue;
            boolean flag = entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)(this.m_21133_(Attributes.f_22281_) * (double)damage + (double)(entityHit.m_21233_() * hpdamage)));
            if (entityHit instanceof Player && entityHit.m_21254_() && shieldbreakticks > 0) {
                Ignis_Entity.disableShield(entityHit, shieldbreakticks);
            }
            if (!flag) continue;
            entityHit.m_20254_(firetime);
            if (brandticks <= 0) continue;
            MobEffectInstance effectinstance1 = entityHit.m_21124_((MobEffect)ModEffect.EFFECTBLAZING_BRAND.get());
            int i = 1;
            if (effectinstance1 != null) {
                i += effectinstance1.m_19564_();
                entityHit.m_6234_((MobEffect)ModEffect.EFFECTBLAZING_BRAND.get());
            } else {
                --i;
            }
            i = Mth.m_14045_((int)i, (int)0, (int)4);
            MobEffectInstance effectinstance = new MobEffectInstance((MobEffect)ModEffect.EFFECTBLAZING_BRAND.get(), brandticks, i, false, false, true);
            entityHit.m_7292_(effectinstance);
            this.m_5634_(6 * (i + 1));
        }
    }

    private void BodyCheckAttack(float range, float height, float arc, float damage, float hpdamage, int shieldbreakticks, int slowticks) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || this.m_7307_((Entity)entityHit) || entityHit instanceof Ignis_Entity) continue;
            boolean flag = entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)(this.m_21133_(Attributes.f_22281_) * (double)damage + (double)(entityHit.m_21233_() * hpdamage)));
            if (entityHit instanceof Player && entityHit.m_21254_() && shieldbreakticks > 0) {
                Ignis_Entity.disableShield(entityHit, shieldbreakticks);
            }
            if (!flag) continue;
            this.m_5496_(SoundEvents.f_11668_, 1.5f, 0.8f + this.m_21187_().nextFloat() * 0.1f);
            double d0 = entityHit.m_20185_() - this.m_20185_();
            double d1 = entityHit.m_20189_() - this.m_20189_();
            double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
            entityHit.m_5997_(d0 / d2 * 2.5, 0.2, d1 / d2 * 2.5);
            if (slowticks <= 0) continue;
            entityHit.m_7292_(new MobEffectInstance((MobEffect)ModEffect.EFFECTSTUN.get(), slowticks, 1, false, false, true));
        }
    }

    private void Poke(float range, float arc, int shieldbreakticks) {
        LivingEntity target = this.m_5448_();
        if (target != null) {
            float entityHitAngle = (float)((Math.atan2(target.m_20189_() - this.m_20189_(), target.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            if (this.m_20270_((Entity)target) <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f || entityRelativeAngle <= -360.0f + arc / 2.0f) {
                boolean flag = target.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_) + target.m_21233_() * 0.1f);
                if (target instanceof Player && target.m_21254_() && shieldbreakticks > 0) {
                    Ignis_Entity.disableShield(target, shieldbreakticks);
                }
                if (flag && !target.m_6095_().m_204039_(ModTag.IGNIS_CANT_POKE)) {
                    if (target.m_6144_()) {
                        target.m_20260_(false);
                    }
                    target.m_7998_((Entity)this, true);
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, POKED_ATTACK);
                }
            }
        }
    }

    private void Flameswing() {
        Vec3 bladePos = this.socketPosArray[0];
        int snowflakeDensity = 4;
        float snowflakeRandomness = 0.5f;
        double length = this.prevBladePos.m_82546_(bladePos).m_82553_();
        int numClouds = (int)Math.floor(2.0 * length);
        for (int i = 0; i < numClouds; ++i) {
            double x = this.prevBladePos.f_82479_ + (double)i * (bladePos.f_82479_ - this.prevBladePos.f_82479_) / (double)numClouds;
            double y = this.prevBladePos.f_82480_ + (double)i * (bladePos.f_82480_ - this.prevBladePos.f_82480_) / (double)numClouds;
            double z = this.prevBladePos.f_82481_ + (double)i * (bladePos.f_82481_ - this.prevBladePos.f_82481_) / (double)numClouds;
            for (int j = 0; j < snowflakeDensity; ++j) {
                float xOffset = snowflakeRandomness * (2.0f * this.f_19796_.nextFloat() - 1.0f);
                float yOffset = snowflakeRandomness * (2.0f * this.f_19796_.nextFloat() - 1.0f);
                float zOffset = snowflakeRandomness * (2.0f * this.f_19796_.nextFloat() - 1.0f);
                if (this.getBossPhase() > 0) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123745_, x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, 0.0, 0.0, 0.0);
                    continue;
                }
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, 0.0, 0.0, 0.0);
            }
        }
    }

    private void SwingParticles() {
        if (this.f_19853_.f_46443_) {
            Vec3 bladePos = this.socketPosArray[0];
            if (this.getAnimation() == HORIZONTAL_SWING_ATTACK && this.getAnimationTick() > 27 && this.getAnimationTick() < 33) {
                this.Flameswing();
            }
            if (this.getAnimation() == SWING_ATTACK && this.getAnimationTick() > 25 && this.getAnimationTick() < 37) {
                this.Flameswing();
            }
            if (this.getAnimation() == BURNS_THE_EARTH && this.getAnimationTick() > 35 && this.getAnimationTick() < 52) {
                this.Flameswing();
            }
            if (this.getAnimation() == TRIPLE_ATTACK) {
                this.Flameswing();
            }
            this.prevBladePos = bladePos;
        }
    }

    private void ShieldSmashparticle(float radius, float vec, float math) {
        if (this.f_19853_.f_46443_) {
            for (int i1 = 0; i1 < 80 + this.f_19796_.nextInt(12); ++i1) {
                double motionX = this.m_21187_().nextGaussian() * 0.07;
                double motionY = this.m_21187_().nextGaussian() * 0.07;
                double motionZ = this.m_21187_().nextGaussian() * 0.07;
                float angle = (float)Math.PI / 180 * this.f_20883_ + (float)i1;
                float f = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                float f1 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.3f;
                double extraZ = radius * Mth.m_14089_((float)angle);
                double theta = (double)this.f_20883_ * (Math.PI / 180);
                double vecX = Math.cos(theta += 1.5707963267948966);
                double vecZ = Math.sin(theta);
                int hitX = Mth.m_14107_((double)(this.m_20185_() + (double)vec * vecX + extraX));
                int hitY = Mth.m_14107_((double)this.m_20186_());
                int hitZ = Mth.m_14107_((double)(this.m_20189_() + (double)vec * vecZ + extraZ));
                BlockPos hit = new BlockPos(hitX, hitY, hitZ);
                BlockState block = this.f_19853_.m_8055_(hit.m_7495_());
                this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), this.m_20185_() + (double)vec * vecX + extraX + (double)(f * math), this.m_20186_() + extraY, this.m_20189_() + (double)vec * vecZ + extraZ + (double)(f1 * math), motionX, motionY, motionZ);
            }
        }
    }

    private void ShieldSmashDamage(int distance, float vec) {
        double perpFacing = (double)this.f_20883_ * (Math.PI / 180);
        double facingAngle = perpFacing + 1.5707963267948966;
        int hitY = Mth.m_14107_((double)(this.m_142469_().f_82289_ - 0.5));
        double spread = Math.PI * 2;
        int arcLen = Mth.m_14165_((double)((double)distance * spread));
        double minY = this.m_20186_() - 1.0;
        double maxY = this.m_20186_() + 1.5;
        for (int i = 0; i < arcLen; ++i) {
            double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
            double vx = Math.cos(theta);
            double vz = Math.sin(theta);
            double px = this.m_20185_() + vx * (double)distance + (double)vec * Math.cos((double)(this.f_20883_ + 90.0f) * Math.PI / 180.0);
            double pz = this.m_20189_() + vz * (double)distance + (double)vec * Math.sin((double)(this.f_20883_ + 90.0f) * Math.PI / 180.0);
            if (!this.f_19853_.f_46443_) {
                int hitX = Mth.m_14107_((double)px);
                int hitZ = Mth.m_14107_((double)pz);
                BlockPos pos = new BlockPos(hitX, hitY, hitZ);
                BlockPos abovePos = new BlockPos((Vec3i)pos).m_7494_();
                BlockState block = this.f_19853_.m_8055_(pos);
                BlockState blockAbove = this.f_19853_.m_8055_(abovePos);
                if (!(block.m_60767_() == Material.f_76296_ || block.m_155947_() || blockAbove.m_60767_().m_76334_() || block.m_204336_(ModTag.NETHERITE_MONSTROSITY_IMMUNE))) {
                    Cm_Falling_Block_Entity fallingBlockEntity = new Cm_Falling_Block_Entity(this.f_19853_, (double)hitX + 0.5, (double)hitY + 0.5, (double)hitZ + 0.5, block);
                    this.f_19853_.m_7731_(pos, block.m_60819_().m_76188_(), 3);
                    fallingBlockEntity.m_5997_(0.0, 0.2 + this.m_21187_().nextGaussian() * 0.15, 0.0);
                    this.f_19853_.m_7967_((Entity)fallingBlockEntity);
                }
            }
            AABB selection = new AABB(px - 0.5, minY, pz - 0.5, px + 0.5, maxY, pz + 0.5);
            List hit = this.f_19853_.m_45976_(LivingEntity.class, selection);
            for (LivingEntity entity : hit) {
                boolean flag;
                if (this.m_7307_((Entity)entity) || entity instanceof Ignis_Entity || entity == this || !(flag = entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_)))) continue;
                double airborne = 0.1 * (double)distance + this.f_19853_.f_46441_.nextDouble() * 0.15;
                entity.m_20256_(entity.m_20184_().m_82520_(0.0, airborne, 0.0));
            }
        }
    }

    private void Sphereparticle(float height, float vec, float size) {
        if (this.f_19853_.f_46443_ && this.f_19797_ % 2 == 0) {
            double d0 = this.m_20185_();
            double d1 = this.m_20186_() + (double)height;
            double d2 = this.m_20189_();
            double theta = (double)this.f_20883_ * (Math.PI / 180);
            double vecX = Math.cos(theta += 1.5707963267948966);
            double vecZ = Math.sin(theta);
            for (float i = -size; i <= size; i += 1.0f) {
                for (float j = -size; j <= size; j += 1.0f) {
                    for (float k = -size; k <= size; k += 1.0f) {
                        double d3 = (double)j + (this.f_19796_.nextDouble() - this.f_19796_.nextDouble()) * 0.5;
                        double d4 = (double)i + (this.f_19796_.nextDouble() - this.f_19796_.nextDouble()) * 0.5;
                        double d5 = (double)k + (this.f_19796_.nextDouble() - this.f_19796_.nextDouble()) * 0.5;
                        double d6 = (double)Mth.m_14116_((float)((float)(d3 * d3 + d4 * d4 + d5 * d5))) / 0.5 + this.f_19796_.nextGaussian() * 0.05;
                        if (this.getBossPhase() == 0) {
                            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0 + (double)vec * vecX, d1, d2 + (double)vec * vecZ, d3 / d6, d4 / d6, d5 / d6);
                        } else {
                            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123745_, d0 + (double)vec * vecX, d1, d2 + (double)vec * vecZ, d3 / d6, d4 / d6, d5 / d6);
                        }
                        if (i == -size || i == size || j == -size || j == size) continue;
                        k += size * 2.0f - 1.0f;
                    }
                }
            }
        }
    }

    private void Phase_Transition(float damage, float hpdamage, int firetime, int brandticks) {
        if (this.getAnimationTick() % 2 == 0) {
            int distance = this.getAnimationTick() / 2 - 27;
            List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(distance, distance, distance, distance);
            for (LivingEntity entityHit : entitiesHit) {
                boolean flag;
                if (this.m_7307_((Entity)entityHit) || entityHit instanceof Ignis_Entity || entityHit == this || !(flag = entityHit.m_6469_(DamageSource.m_19367_((Entity)this, (Entity)this), (float)(this.m_21133_(Attributes.f_22281_) * (double)damage + (double)hpdamage)))) continue;
                entityHit.m_20254_(firetime);
                if (brandticks <= 0) continue;
                MobEffectInstance effectinstance1 = entityHit.m_21124_((MobEffect)ModEffect.EFFECTBLAZING_BRAND.get());
                int i = 1;
                if (effectinstance1 != null) {
                    i += effectinstance1.m_19564_();
                    entityHit.m_6234_((MobEffect)ModEffect.EFFECTBLAZING_BRAND.get());
                } else {
                    --i;
                }
                i = Mth.m_14045_((int)i, (int)0, (int)4);
                MobEffectInstance effectinstance = new MobEffectInstance((MobEffect)ModEffect.EFFECTBLAZING_BRAND.get(), brandticks, i, false, false, true);
                entityHit.m_7292_(effectinstance);
            }
        }
    }

    public void m_7332_(Entity passenger) {
        super.m_7332_(passenger);
        if (this.m_20363_(passenger)) {
            boolean flag;
            LivingEntity target;
            int tick = 5;
            if (this.getAnimation() == POKED_ATTACK) {
                tick = this.getAnimationTick();
                if (this.getAnimationTick() == 46) {
                    passenger.m_8127_();
                    float f1 = (float)Math.cos(Math.toRadians(this.m_146908_() + 90.0f));
                    float f = (float)Math.sin(Math.toRadians(this.m_146908_() + 90.0f));
                }
                this.m_146922_(this.f_19859_);
                this.f_20883_ = this.m_146908_();
                this.f_20885_ = this.m_146908_();
            }
            float radius = 4.0f;
            float angle = (float)Math.PI / 180 * this.f_20883_;
            double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * Mth.m_14089_((float)angle);
            double extraY = tick < 10 ? 0.0 : (double)(0.2f * (float)Mth.m_14045_((int)(tick - 10), (int)0, (int)15));
            passenger.m_6034_(this.m_20185_() + extraX, this.m_20186_() + extraY + (double)1.2f, this.m_20189_() + extraZ);
            if ((tick - 10) % 4 == 0 && (target = this.m_5448_()) != null && passenger == target && (flag = target.m_6469_(DamageSource.m_19370_((LivingEntity)this), 4.0f + target.m_21233_() * 0.02f))) {
                MobEffectInstance effectinstance1 = target.m_21124_((MobEffect)ModEffect.EFFECTBLAZING_BRAND.get());
                int i = 1;
                if (effectinstance1 != null) {
                    i += effectinstance1.m_19564_();
                    target.m_6234_((MobEffect)ModEffect.EFFECTBLAZING_BRAND.get());
                } else {
                    --i;
                }
                i = Mth.m_14045_((int)i, (int)0, (int)4);
                MobEffectInstance effectinstance = new MobEffectInstance((MobEffect)ModEffect.EFFECTBLAZING_BRAND.get(), 150, i, false, false, true);
                target.m_7292_(effectinstance);
                this.m_5634_(2.0f * (float)(i + 1));
            }
        }
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    @Override
    protected void repelEntities(float x, float y, float z, float radius) {
        super.repelEntities(x, y, z, radius);
    }

    @Override
    public boolean canBePushedByEntity(Entity entity) {
        return false;
    }

    public void m_7023_(Vec3 travelVector) {
        this.m_7910_((float)this.m_21133_(Attributes.f_22279_) * (this.m_20077_() ? 0.2f : 1.0f));
        if (this.getAnimation() == POKED_ATTACK) {
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            travelVector = Vec3.f_82478_;
            super.m_7023_(travelVector);
            return;
        }
        super.m_7023_(travelVector);
    }

    protected BodyRotationControl m_7560_() {
        return new SmartBodyHelper2((Mob)this);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new CMPathNavigateGround((Mob)this, worldIn);
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    private boolean shouldFollowUp(float Range) {
        LivingEntity target = this.m_5448_();
        if (target != null && target.m_6084_()) {
            Vec3 betweenEntitiesVec;
            Vec3 targetMoveVec = target.m_20184_();
            boolean targetComingCloser = targetMoveVec.m_82526_(betweenEntitiesVec = this.m_20182_().m_82546_(target.m_20182_())) > 0.0;
            return this.m_20270_((Entity)target) < Range || this.m_20270_((Entity)target) < 5.0f + Range && targetComingCloser;
        }
        return false;
    }

    class Hornzontal_Swing
    extends SimpleAnimationGoal<Ignis_Entity> {
        public Hornzontal_Swing(Ignis_Entity entity, Animation animation) {
            super(entity, animation);
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public void m_8037_() {
            LivingEntity target = Ignis_Entity.this.m_5448_();
            if (Ignis_Entity.this.getAnimationTick() < 31 && target != null || Ignis_Entity.this.getAnimationTick() > 51 && target != null) {
                Ignis_Entity.this.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            } else {
                Ignis_Entity.this.m_146922_(Ignis_Entity.this.f_19859_);
            }
            if (Ignis_Entity.this.getAnimationTick() == 26) {
                float f1 = (float)Math.cos(Math.toRadians(Ignis_Entity.this.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(Ignis_Entity.this.m_146908_() + 90.0f));
                if (target != null) {
                    float r = Ignis_Entity.this.m_20270_((Entity)target);
                    r = Mth.m_14036_((float)r, (float)0.0f, (float)8.0f);
                    Ignis_Entity.this.m_5997_((double)f1 * 0.3 * (double)r, 0.0, (double)f2 * 0.3 * (double)r);
                } else {
                    Ignis_Entity.this.m_5997_(f1, 0.0, f2);
                }
            }
            if (Ignis_Entity.this.getAnimationTick() == 36 && Ignis_Entity.this.shouldFollowUp(3.5f) && Ignis_Entity.this.f_19796_.nextInt(3) == 0 && Ignis_Entity.this.body_check_cooldown <= 0) {
                Ignis_Entity.this.body_check_cooldown = 200;
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)Ignis_Entity.this, BODY_CHECK_ATTACK2);
            }
            if (Ignis_Entity.this.getAnimationTick() > 32 || Ignis_Entity.this.getAnimationTick() < 26) {
                Ignis_Entity.this.m_20334_(0.0, Ignis_Entity.this.m_20184_().f_82480_, 0.0);
            }
        }
    }

    class Poke
    extends AnimationGoal<Ignis_Entity> {
        public Poke(Ignis_Entity entity) {
            super(entity);
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        @Override
        protected boolean test(Animation animation) {
            return Ignis_Entity.this.getAnimation() == POKE_ATTACK || Ignis_Entity.this.getAnimation() == POKE_ATTACK2 || Ignis_Entity.this.getAnimation() == POKE_ATTACK3;
        }

        public void m_8037_() {
            float r;
            LivingEntity target = Ignis_Entity.this.m_5448_();
            float f1 = (float)Math.cos(Math.toRadians(Ignis_Entity.this.m_146908_() + 90.0f));
            float f2 = (float)Math.sin(Math.toRadians(Ignis_Entity.this.m_146908_() + 90.0f));
            if (Ignis_Entity.this.getAnimation() == POKE_ATTACK) {
                if (Ignis_Entity.this.getAnimationTick() < 39 && target != null || Ignis_Entity.this.getAnimationTick() > 59 && target != null) {
                    Ignis_Entity.this.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                } else {
                    Ignis_Entity.this.m_146922_(Ignis_Entity.this.f_19859_);
                }
                if (Ignis_Entity.this.getAnimationTick() == 34) {
                    if (target != null) {
                        r = Ignis_Entity.this.m_20270_((Entity)target);
                        r = Mth.m_14036_((float)r, (float)0.0f, (float)15.0f);
                        Ignis_Entity.this.m_5997_((double)f1 * 0.3 * (double)r, 0.0, (double)f2 * 0.3 * (double)r);
                    } else {
                        Ignis_Entity.this.m_5997_(f1, 0.0, f2);
                    }
                }
                if (Ignis_Entity.this.getAnimationTick() == 42 && Ignis_Entity.this.shouldFollowUp(3.0f) && Ignis_Entity.this.f_19796_.nextInt(2) == 0 && Ignis_Entity.this.body_check_cooldown <= 0) {
                    Ignis_Entity.this.body_check_cooldown = 200;
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)Ignis_Entity.this, BODY_CHECK_ATTACK4);
                }
                if (Ignis_Entity.this.getAnimationTick() > 40 || Ignis_Entity.this.getAnimationTick() < 34) {
                    Ignis_Entity.this.m_20334_(0.0, Ignis_Entity.this.m_20184_().f_82480_, 0.0);
                }
            }
            if (Ignis_Entity.this.getAnimation() == POKE_ATTACK2) {
                if (Ignis_Entity.this.getAnimationTick() < 33 && target != null || Ignis_Entity.this.getAnimationTick() > 53 && target != null) {
                    Ignis_Entity.this.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                } else {
                    Ignis_Entity.this.m_146922_(Ignis_Entity.this.f_19859_);
                }
                if (Ignis_Entity.this.getAnimationTick() == 28) {
                    if (target != null) {
                        r = Ignis_Entity.this.m_20270_((Entity)target);
                        r = Mth.m_14036_((float)r, (float)0.0f, (float)15.0f);
                        Ignis_Entity.this.m_5997_((double)f1 * 0.3 * (double)r, 0.0, (double)f2 * 0.3 * (double)r);
                    } else {
                        Ignis_Entity.this.m_5997_(f1, 0.0, f2);
                    }
                }
                if (Ignis_Entity.this.getAnimationTick() == 36 && Ignis_Entity.this.shouldFollowUp(3.0f) && Ignis_Entity.this.f_19796_.nextInt(2) == 0 && Ignis_Entity.this.body_check_cooldown <= 0) {
                    Ignis_Entity.this.body_check_cooldown = 200;
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)Ignis_Entity.this, BODY_CHECK_ATTACK4);
                }
                if (Ignis_Entity.this.getAnimationTick() > 34 || Ignis_Entity.this.getAnimationTick() < 28) {
                    Ignis_Entity.this.m_20334_(0.0, Ignis_Entity.this.m_20184_().f_82480_, 0.0);
                }
            }
            if (Ignis_Entity.this.getAnimation() == POKE_ATTACK3) {
                if (Ignis_Entity.this.getAnimationTick() < 29 && target != null) {
                    Ignis_Entity.this.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                } else {
                    Ignis_Entity.this.m_146922_(Ignis_Entity.this.f_19859_);
                }
                if (Ignis_Entity.this.getAnimationTick() == 24) {
                    if (target != null) {
                        r = Ignis_Entity.this.m_20270_((Entity)target);
                        r = Mth.m_14036_((float)r, (float)0.0f, (float)15.0f);
                        Ignis_Entity.this.m_5997_((double)f1 * 0.3 * (double)r, 0.0, (double)f2 * 0.3 * (double)r);
                    } else {
                        Ignis_Entity.this.m_5997_(f1, 0.0, f2);
                    }
                }
                if (Ignis_Entity.this.getAnimationTick() == 33 && Ignis_Entity.this.shouldFollowUp(3.0f) && Ignis_Entity.this.f_19796_.nextInt(2) == 0 && Ignis_Entity.this.body_check_cooldown <= 0) {
                    Ignis_Entity.this.body_check_cooldown = 200;
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)Ignis_Entity.this, BODY_CHECK_ATTACK4);
                }
                if (Ignis_Entity.this.getAnimationTick() > 30 || Ignis_Entity.this.getAnimationTick() < 24) {
                    Ignis_Entity.this.m_20334_(0.0, Ignis_Entity.this.m_20184_().f_82480_, 0.0);
                }
            }
        }
    }

    class Phase_Transition
    extends SimpleAnimationGoal<Ignis_Entity> {
        public Phase_Transition(Ignis_Entity entity, Animation animation) {
            super(entity, animation);
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public void m_8037_() {
            LivingEntity target = Ignis_Entity.this.m_5448_();
            if (Ignis_Entity.this.getAnimationTick() < 34 && target != null || Ignis_Entity.this.getAnimationTick() > 54 && target != null) {
                Ignis_Entity.this.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            } else {
                Ignis_Entity.this.m_146922_(Ignis_Entity.this.f_19859_);
            }
            Ignis_Entity.this.m_20334_(0.0, Ignis_Entity.this.m_20184_().f_82480_, 0.0);
        }
    }

    class Phase_Transition2
    extends SimpleAnimationGoal<Ignis_Entity> {
        public Phase_Transition2(Ignis_Entity entity, Animation animation) {
            super(entity, animation);
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public void m_8037_() {
            LivingEntity target = Ignis_Entity.this.m_5448_();
            if (Ignis_Entity.this.getAnimationTick() < 34 && target != null) {
                Ignis_Entity.this.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            } else {
                Ignis_Entity.this.m_146922_(Ignis_Entity.this.f_19859_);
            }
            Ignis_Entity.this.m_20334_(0.0, Ignis_Entity.this.m_20184_().f_82480_, 0.0);
        }
    }

    class Shield_Smash
    extends SimpleAnimationGoal<Ignis_Entity> {
        public Shield_Smash(Ignis_Entity entity, Animation animation) {
            super(entity, animation);
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public void m_8037_() {
            LivingEntity target = Ignis_Entity.this.m_5448_();
            if (Ignis_Entity.this.getAnimationTick() < 34 && target != null) {
                Ignis_Entity.this.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            } else {
                Ignis_Entity.this.m_146922_(Ignis_Entity.this.f_19859_);
            }
            Ignis_Entity.this.m_20334_(0.0, Ignis_Entity.this.m_20184_().f_82480_, 0.0);
            if (Ignis_Entity.this.getAnimationTick() == 45 && Ignis_Entity.this.shouldFollowUp(4.0f) && Ignis_Entity.this.f_19796_.nextInt(3) == 0 && Ignis_Entity.this.body_check_cooldown <= 0) {
                Ignis_Entity.this.body_check_cooldown = 200;
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)Ignis_Entity.this, BODY_CHECK_ATTACK3);
            }
        }
    }

    class Body_Check
    extends AnimationGoal<Ignis_Entity> {
        public Body_Check(Ignis_Entity entity) {
            super(entity);
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        @Override
        protected boolean test(Animation animation) {
            return Ignis_Entity.this.getAnimation() == BODY_CHECK_ATTACK1 || Ignis_Entity.this.getAnimation() == BODY_CHECK_ATTACK2 || Ignis_Entity.this.getAnimation() == BODY_CHECK_ATTACK3 || Ignis_Entity.this.getAnimation() == BODY_CHECK_ATTACK4;
        }

        public void m_8037_() {
            LivingEntity target = Ignis_Entity.this.m_5448_();
            if (Ignis_Entity.this.getAnimationTick() < 25 && target != null) {
                Ignis_Entity.this.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            } else {
                Ignis_Entity.this.m_146922_(Ignis_Entity.this.f_19859_);
            }
            if (Ignis_Entity.this.getAnimationTick() == 20 && target != null) {
                Ignis_Entity.this.m_20334_((target.m_20185_() - Ignis_Entity.this.m_20185_()) * 0.25, 0.0, (target.m_20189_() - Ignis_Entity.this.m_20189_()) * 0.25);
            }
        }
    }

    class Poked
    extends SimpleAnimationGoal<Ignis_Entity> {
        public Poked(Ignis_Entity entity, Animation animation) {
            super(entity, animation);
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public void m_8037_() {
            LivingEntity target = Ignis_Entity.this.m_5448_();
            if (target != null) {
                Ignis_Entity.this.m_21563_().m_24960_((Entity)target, 20.0f, 20.0f);
            }
            Ignis_Entity.this.m_20334_(0.0, Ignis_Entity.this.m_20184_().f_82480_, 0.0);
        }
    }

    class Air_Smash
    extends SimpleAnimationGoal<Ignis_Entity> {
        public Air_Smash(Ignis_Entity entity, Animation animation) {
            super(entity, animation);
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public void m_8037_() {
            LivingEntity target = Ignis_Entity.this.m_5448_();
            if (target != null) {
                Ignis_Entity.this.m_21391_((Entity)target, 30.0f, 30.0f);
            }
            if (Ignis_Entity.this.getAnimationTick() == 19) {
                if (target != null) {
                    Ignis_Entity.this.m_20334_((target.m_20185_() - Ignis_Entity.this.m_20185_()) * 0.2, 1.4, (target.m_20189_() - Ignis_Entity.this.m_20189_()) * 0.2);
                } else {
                    Ignis_Entity.this.m_20334_(0.0, 1.4, 0.0);
                }
            }
            if (Ignis_Entity.this.getAnimationTick() > 19 && Ignis_Entity.this.m_20096_()) {
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)Ignis_Entity.this, SMASH);
            }
        }
    }

    class Vertical_Swing
    extends SimpleAnimationGoal<Ignis_Entity> {
        public Vertical_Swing(Ignis_Entity entity, Animation animation) {
            super(entity, animation);
        }

        public void m_8037_() {
            LivingEntity target = Ignis_Entity.this.m_5448_();
            if (Ignis_Entity.this.getAnimationTick() < 34 && target != null) {
                Ignis_Entity.this.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            } else {
                Ignis_Entity.this.m_146922_(Ignis_Entity.this.f_19859_);
            }
        }
    }

    class Triple_Attack
    extends SimpleAnimationGoal<Ignis_Entity> {
        public Triple_Attack(Ignis_Entity entity, Animation animation) {
            super(entity, animation);
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public void m_8037_() {
            LivingEntity target = Ignis_Entity.this.m_5448_();
            if (Ignis_Entity.this.getAnimationTick() < 30 && target != null || Ignis_Entity.this.getAnimationTick() < 69 && Ignis_Entity.this.getAnimationTick() > 42 && target != null || Ignis_Entity.this.getAnimationTick() < 108 && Ignis_Entity.this.getAnimationTick() > 84 && target != null || Ignis_Entity.this.getAnimationTick() > 124 && target != null) {
                Ignis_Entity.this.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            } else {
                Ignis_Entity.this.m_146922_(Ignis_Entity.this.f_19859_);
            }
            if (Ignis_Entity.this.getAnimationTick() == 27 || Ignis_Entity.this.getAnimationTick() == 105) {
                float f1 = (float)Math.cos(Math.toRadians(Ignis_Entity.this.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(Ignis_Entity.this.m_146908_() + 90.0f));
                if (target != null) {
                    if (Ignis_Entity.this.m_20270_((Entity)target) > 3.5f) {
                        Ignis_Entity.this.m_5997_((double)f1 * 1.5, 0.0, (double)f2 * 1.5);
                    }
                } else {
                    Ignis_Entity.this.m_5997_((double)f1 * 1.5, 0.0, (double)f2 * 1.5);
                }
            }
        }
    }

    class Break_the_Shield
    extends SimpleAnimationGoal<Ignis_Entity> {
        public Break_the_Shield(Ignis_Entity entity, Animation animation) {
            super(entity, animation);
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public void m_8037_() {
        }
    }
}

