/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import vazkii.arl.util.ClientTicker;
import vazkii.quark.addons.oddities.block.be.MatrixEnchantingTableBlockEntity;
import vazkii.quark.addons.oddities.client.screen.MatrixEnchantingPieceList;
import vazkii.quark.addons.oddities.client.screen.MatrixEnchantingPlusButton;
import vazkii.quark.addons.oddities.inventory.EnchantmentMatrix;
import vazkii.quark.addons.oddities.inventory.MatrixEnchantingMenu;
import vazkii.quark.addons.oddities.module.MatrixEnchantingModule;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.oddities.MatrixEnchanterOperationMessage;

public class MatrixEnchantingScreen
extends AbstractContainerScreen<MatrixEnchantingMenu> {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("quark", "textures/misc/matrix_enchanting.png");
    protected final Inventory playerInv;
    protected final MatrixEnchantingTableBlockEntity enchanter;
    protected Button plusButton;
    protected MatrixEnchantingPieceList pieceList;
    protected EnchantmentMatrix.Piece hoveredPiece;
    protected int selectedPiece = -1;
    protected int gridHoverX;
    protected int gridHoverY;
    protected List<Integer> listPieces = null;

    public MatrixEnchantingScreen(MatrixEnchantingMenu container, Inventory inventory, Component component) {
        super((AbstractContainerMenu)container, inventory, component);
        this.playerInv = inventory;
        this.enchanter = container.enchanter;
    }

    public void m_7856_() {
        super.m_7856_();
        this.selectedPiece = -1;
        this.plusButton = new MatrixEnchantingPlusButton(this.f_97735_ + 86, this.f_97736_ + 63, this::add);
        this.m_142416_((GuiEventListener)this.plusButton);
        this.pieceList = new MatrixEnchantingPieceList(this, 28, 64, this.f_97736_ + 11, this.f_97736_ + 75, 22);
        this.pieceList.m_93507_(this.f_97735_ + 139);
        this.m_142416_((GuiEventListener)this.pieceList);
        this.updateButtonStatus();
        this.pieceList.refresh();
    }

    public void m_181908_() {
        super.m_181908_();
        this.updateButtonStatus();
        if (this.enchanter.matrix == null) {
            this.selectedPiece = -1;
            this.pieceList.refresh();
        }
        if (this.enchanter.clientMatrixDirty) {
            this.pieceList.refresh();
            this.enchanter.clientMatrixDirty = false;
        }
    }

    protected void m_7286_(@Nonnull PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        Minecraft mc = this.getMinecraft();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.m_93228_(stack, i, j, 0, 0, this.f_97726_, this.f_97727_);
        if (this.enchanter.charge > 0 && MatrixEnchantingModule.chargePerLapis > 0) {
            int maxHeight = 18;
            int barHeight = (int)((float)this.enchanter.charge / (float)MatrixEnchantingModule.chargePerLapis * (float)maxHeight);
            this.m_93228_(stack, i + 7, j + 32 + maxHeight - barHeight, 50, 176 + maxHeight - barHeight, 4, barHeight);
        }
        this.pieceList.m_6305_(stack, mouseX, mouseY, partialTicks);
        if (this.enchanter.matrix != null && this.enchanter.matrix.canGeneratePiece(this.enchanter.influences, this.enchanter.bookshelfPower, this.enchanter.enchantability) && !mc.f_91074_.m_150110_().f_35937_) {
            int x = i + 74;
            int y = j + 58;
            int xpCost = this.enchanter.matrix.getNewPiecePrice();
            int xpMin = this.enchanter.matrix.getMinXpLevel(this.enchanter.bookshelfPower);
            boolean has = this.enchanter.matrix.validateXp((Player)mc.f_91074_, this.enchanter.bookshelfPower);
            this.m_93228_(stack, x, y, 0, this.f_97727_, 10, 10);
            String text = String.valueOf(xpCost);
            if (!has && mc.f_91074_.f_36078_ < xpMin) {
                this.f_96547_.m_92750_(stack, "!", (float)(x + 6), (float)(y + 3), 0xFF0000);
                text = I18n.m_118938_((String)"quark.gui.enchanting.min", (Object[])new Object[]{xpMin});
            }
            this.f_96547_.m_92883_(stack, text, (float)((x -= this.f_96547_.m_92895_(text) - 5) - 1), (float)(y += 3), 0);
            this.f_96547_.m_92883_(stack, text, (float)(x + 1), (float)y, 0);
            this.f_96547_.m_92883_(stack, text, (float)x, (float)(y + 1), 0);
            this.f_96547_.m_92883_(stack, text, (float)x, (float)(y - 1), 0);
            this.f_96547_.m_92883_(stack, text, (float)x, (float)y, has ? 0xC8FF8F : 0xFF8F8F);
        }
    }

    protected void m_7027_(@Nonnull PoseStack matrix, int mouseX, int mouseY) {
        int color = MiscUtil.getGuiTextColor("matrix_enchanting");
        this.f_96547_.m_92883_(matrix, this.enchanter.m_5446_().getString(), 12.0f, 5.0f, color);
        this.f_96547_.m_92883_(matrix, this.playerInv.m_5446_().getString(), 8.0f, (float)(this.f_97727_ - 96 + 2), color);
        if (this.enchanter.matrix != null) {
            boolean needsRefresh = this.listPieces == null;
            this.listPieces = this.enchanter.matrix.benchedPieces;
            if (needsRefresh) {
                this.pieceList.refresh();
            }
            this.renderMatrixGrid(matrix, this.enchanter.matrix);
        }
    }

    public void m_6305_(@Nonnull PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        if (this.hoveredPiece != null) {
            EnchantmentMatrix.Piece p;
            LinkedList<Object> tooltip = new LinkedList<Object>();
            tooltip.add(new TranslatableComponent(this.hoveredPiece.enchant.m_44700_(this.hoveredPiece.level).getString().replaceAll("\\u00A7.", "")).m_130940_(ChatFormatting.GOLD));
            if (this.hoveredPiece.influence > 0) {
                tooltip.add(new TranslatableComponent("quark.gui.enchanting.influence", new Object[]{(int)((double)this.hoveredPiece.influence * MatrixEnchantingModule.influencePower * 100.0)}).m_130940_(ChatFormatting.GRAY));
            } else if (this.hoveredPiece.influence < 0) {
                tooltip.add(new TranslatableComponent("quark.gui.enchanting.dampen", new Object[]{(int)((double)this.hoveredPiece.influence * MatrixEnchantingModule.influencePower * 100.0)}).m_130940_(ChatFormatting.GRAY));
            }
            int max = this.hoveredPiece.getMaxXP();
            if (max > 0) {
                tooltip.add(new TranslatableComponent("quark.gui.enchanting.upgrade", new Object[]{this.hoveredPiece.xp, max}).m_130940_(ChatFormatting.GRAY));
            }
            if (this.gridHoverX == -1) {
                tooltip.add(new TextComponent(""));
                tooltip.add(new TranslatableComponent("quark.gui.enchanting.left_click").m_130940_(ChatFormatting.GRAY));
                tooltip.add(new TranslatableComponent("quark.gui.enchanting.right_click").m_130940_(ChatFormatting.GRAY));
            } else if (this.selectedPiece != -1 && (p = this.getPiece(this.selectedPiece)) != null && p.enchant == this.hoveredPiece.enchant && this.hoveredPiece.level < this.hoveredPiece.enchant.m_6586_()) {
                tooltip.add(new TextComponent(""));
                tooltip.add(new TranslatableComponent("quark.gui.enchanting.merge").m_130940_(ChatFormatting.GRAY));
            }
            this.m_96597_(stack, tooltip, mouseX, mouseY);
        } else {
            this.m_7025_(stack, mouseX, mouseY);
        }
    }

    public void m_94757_(double mouseX, double mouseY) {
        int gridMouseX = (int)(mouseX - (double)this.f_97735_ - 86.0);
        int gridMouseY = (int)(mouseY - (double)this.f_97736_ - 11.0);
        this.gridHoverX = gridMouseX < 0 ? -1 : gridMouseX / 10;
        int n = this.gridHoverY = gridMouseY < 0 ? -1 : gridMouseY / 10;
        if (this.gridHoverX < 0 || this.gridHoverX > 4 || this.gridHoverY < 0 || this.gridHoverY > 4) {
            this.gridHoverX = -1;
            this.gridHoverY = -1;
            this.hoveredPiece = null;
        } else if (this.enchanter.matrix != null) {
            int hover = this.enchanter.matrix.matrix[this.gridHoverX][this.gridHoverY];
            this.hoveredPiece = this.getPiece(hover);
        }
        super.m_94757_(mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        super.m_6375_(mouseX, mouseY, mouseButton);
        if (this.enchanter.matrix == null) {
            return true;
        }
        if (mouseButton == 0 && this.gridHoverX != -1) {
            int hover = this.enchanter.matrix.matrix[this.gridHoverX][this.gridHoverY];
            if (this.selectedPiece != -1) {
                if (hover == -1) {
                    this.place(this.selectedPiece, this.gridHoverX, this.gridHoverY);
                } else {
                    this.merge(this.selectedPiece);
                }
            } else {
                this.remove(hover);
                if (!MatrixEnchantingScreen.m_96638_()) {
                    this.selectedPiece = hover;
                }
            }
        } else if (mouseButton == 1 && this.selectedPiece != -1) {
            this.rotate(this.selectedPiece);
        }
        return true;
    }

    private void renderMatrixGrid(PoseStack stack, EnchantmentMatrix matrix) {
        EnchantmentMatrix.Piece piece;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        stack.m_85836_();
        stack.m_85837_(86.0, 11.0, 0.0);
        for (int i : matrix.placedPieces) {
            EnchantmentMatrix.Piece piece2 = this.getPiece(i);
            if (piece2 == null) continue;
            stack.m_85836_();
            stack.m_85837_((double)(piece2.x * 10), (double)(piece2.y * 10), 0.0);
            this.renderPiece(stack, piece2, 1.0f);
            stack.m_85849_();
        }
        if (this.selectedPiece != -1 && this.gridHoverX != -1 && (piece = this.getPiece(this.selectedPiece)) != null && (this.hoveredPiece == null || piece.enchant != this.hoveredPiece.enchant || this.hoveredPiece.level >= this.hoveredPiece.enchant.m_6586_())) {
            stack.m_85836_();
            stack.m_85837_((double)(this.gridHoverX * 10), (double)(this.gridHoverY * 10), 0.0);
            float a = 0.2f;
            if (matrix.canPlace(piece, this.gridHoverX, this.gridHoverY)) {
                a = (float)((Math.sin((double)ClientTicker.total * 0.2) + 1.0) * 0.4 + 0.4);
            }
            this.renderPiece(stack, piece, a);
            stack.m_85849_();
        }
        if (this.hoveredPiece == null && this.gridHoverX != -1) {
            this.renderHover(stack, this.gridHoverX, this.gridHoverY);
        }
        stack.m_85849_();
    }

    protected void renderPiece(PoseStack stack, EnchantmentMatrix.Piece piece, float a) {
        float r = (float)(piece.color >> 16 & 0xFF) / 255.0f;
        float g = (float)(piece.color >> 8 & 0xFF) / 255.0f;
        float b = (float)(piece.color & 0xFF) / 255.0f;
        boolean hovered = this.hoveredPiece == piece;
        for (int[] block : piece.blocks) {
            this.renderBlock(stack, block[0], block[1], piece.type, r, g, b, a, hovered);
        }
    }

    private void renderBlock(PoseStack stack, int x, int y, int type, float r, float g, float b, float a, boolean hovered) {
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)a);
        this.m_93228_(stack, x * 10, y * 10, 11 + type * 10, this.f_97727_, 10, 10);
        if (hovered) {
            this.renderHover(stack, x, y);
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderHover(PoseStack stack, int x, int y) {
        MatrixEnchantingScreen.m_93172_((PoseStack)stack, (int)(x * 10), (int)(y * 10), (int)(x * 10 + 10), (int)(y * 10 + 10), (int)0x66FFFFFF);
    }

    public void add(Button button) {
        this.send(0, 0, 0, 0);
    }

    public void place(int id, int x, int y) {
        this.send(1, id, x, y);
        this.selectedPiece = -1;
        this.click();
    }

    public void remove(int id) {
        this.send(2, id, 0, 0);
    }

    public void rotate(int id) {
        this.send(3, id, 0, 0);
    }

    public void merge(int id) {
        int hover = this.enchanter.matrix.matrix[this.gridHoverX][this.gridHoverY];
        EnchantmentMatrix.Piece p = this.getPiece(hover);
        EnchantmentMatrix.Piece p1 = this.getPiece(this.selectedPiece);
        if (p != null && p1 != null && p.enchant == p1.enchant && p.level < p.enchant.m_6586_()) {
            this.send(4, hover, id, 0);
            this.selectedPiece = -1;
            this.click();
        }
    }

    private void send(int operation, int arg0, int arg1, int arg2) {
        MatrixEnchanterOperationMessage message = new MatrixEnchanterOperationMessage(operation, arg0, arg1, arg2);
        QuarkNetwork.sendToServer(message);
    }

    private void click() {
        this.getMinecraft().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
    }

    private void updateButtonStatus() {
        this.plusButton.f_93623_ = this.enchanter.matrix != null && (this.getMinecraft().f_91074_.m_150110_().f_35937_ || this.enchanter.charge > 0) && this.enchanter.matrix.validateXp((Player)this.getMinecraft().f_91074_, this.enchanter.bookshelfPower) && this.enchanter.matrix.canGeneratePiece(this.enchanter.influences, this.enchanter.bookshelfPower, this.enchanter.enchantability);
    }

    protected EnchantmentMatrix.Piece getPiece(int id) {
        EnchantmentMatrix matrix = this.enchanter.matrix;
        if (matrix != null) {
            return matrix.pieces.get(id);
        }
        return null;
    }
}

