/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module.config.type;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.type.AbstractConfigType;

public class DimensionConfig
extends AbstractConfigType {
    @Config
    private boolean isBlacklist;
    @Config
    private List<String> dimensions;

    public DimensionConfig(boolean blacklist, String ... dims) {
        this.isBlacklist = blacklist;
        this.dimensions = new LinkedList<String>();
        Collections.addAll(this.dimensions, dims);
    }

    public static DimensionConfig overworld(boolean blacklist) {
        return new DimensionConfig(blacklist, "minecraft:overworld");
    }

    public static DimensionConfig nether(boolean blacklist) {
        return new DimensionConfig(blacklist, "minecraft:the_nether");
    }

    public static DimensionConfig end(boolean blacklist) {
        return new DimensionConfig(blacklist, "minecraft:the_end");
    }

    public static DimensionConfig all() {
        return new DimensionConfig(true, new String[0]);
    }

    public boolean canSpawnHere(LevelAccessor world) {
        if (!(world instanceof Level)) {
            return false;
        }
        Level level = (Level)world;
        return this.canSpawnHere(level.m_46472_().m_135782_());
    }

    public boolean canSpawnHere(ResourceLocation resloc) {
        return this.dimensions.contains(resloc.toString()) != this.isBlacklist;
    }
}

