/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.automation.module;

import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.content.automation.block.FeedingTroughBlock;
import vazkii.quark.content.automation.block.be.FeedingTroughBlockEntity;

@LoadModule(category=ModuleCategory.AUTOMATION, hasSubscriptions=true)
public class FeedingTroughModule
extends QuarkModule {
    public static BlockEntityType<FeedingTroughBlockEntity> blockEntityType;
    public static PoiType feedingTroughPoi;
    @Config(description="How long, in game ticks, between animals being able to eat from the trough")
    @Config.Min(value=1.0)
    public static int cooldown;
    @Config(description="The maximum amount of animals allowed around the trough's range for an animal to enter love mode")
    public static int maxAnimals;
    @Config(description="The chance (between 0 and 1) for an animal to enter love mode when eating from the trough")
    @Config.Min(value=0.0, exclusive=true)
    @Config.Max(value=1.0)
    public static double loveChance;
    @Config
    public static double range;
    private static final ThreadLocal<Boolean> breedingOccurred;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBreed(BabyEntitySpawnEvent event) {
        if (event.getCausedByPlayer() == null && event.getParentA().f_19853_.m_46469_().m_46207_(GameRules.f_46135_)) {
            breedingOccurred.set(true);
        }
    }

    @SubscribeEvent
    public void onOrbSpawn(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof ExperienceOrb && breedingOccurred.get().booleanValue()) {
            event.setCanceled(true);
            breedingOccurred.remove();
        }
    }

    public static Player temptWithTroughs(TemptGoal goal, Player found, ServerLevel level) {
        Animal animal;
        if (!ModuleLoader.INSTANCE.isModuleEnabled(FeedingTroughModule.class) || found != null && (goal.f_25935_.test(found.m_21205_()) || goal.f_25935_.test(found.m_21206_()))) {
            return found;
        }
        PathfinderMob pathfinderMob = goal.f_25924_;
        if (!(pathfinderMob instanceof Animal) || !(animal = (Animal)pathfinderMob).m_5957_() || animal.m_146764_() != 0) {
            return found;
        }
        Vec3 position = animal.m_20182_();
        Pair pair = level.m_8904_().m_27171_(feedingTroughPoi.m_27392_(), p -> p.m_123331_(new Vec3i(position.f_82479_, position.f_82480_, position.f_82481_)) <= range * range, animal.m_142538_(), (int)range, PoiManager.Occupancy.ANY).map(pos -> {
            FeedingTroughBlockEntity trough;
            BlockEntity patt4043$temp = level.m_7702_(pos);
            return patt4043$temp instanceof FeedingTroughBlockEntity ? (trough = (FeedingTroughBlockEntity)patt4043$temp) : null;
        }).filter(Objects::nonNull).map(trough -> Pair.of((Object)trough.m_58899_(), (Object)trough.getFoodHolder(goal))).filter(p -> p.getSecond() != null).findFirst().orElse(null);
        if (pair != null) {
            Vec3 targetPos;
            BlockPos location = (BlockPos)pair.getFirst();
            Vec3 eyesPos = goal.f_25924_.m_20182_().m_82520_(0.0, (double)goal.f_25924_.m_20192_(), 0.0);
            BlockHitResult ray = goal.f_25924_.f_19853_.m_45547_(new ClipContext(eyesPos, targetPos = new Vec3((double)location.m_123341_(), (double)location.m_123342_(), (double)location.m_123343_()).m_82520_(0.5, 0.0625, 0.5), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)goal.f_25924_));
            if (ray.m_6662_() == HitResult.Type.BLOCK && ray.m_82425_().equals((Object)location)) {
                return (Player)pair.getSecond();
            }
        }
        return found;
    }

    @Override
    public void register() {
        FeedingTroughBlock feedingTrough = new FeedingTroughBlock("feeding_trough", this, CreativeModeTab.f_40750_, BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(0.6f).m_60918_(SoundType.f_56736_));
        blockEntityType = BlockEntityType.Builder.m_155273_(FeedingTroughBlockEntity::new, (Block[])new Block[]{feedingTrough}).m_58966_(null);
        RegistryHelper.register(blockEntityType, (String)"feeding_trough");
        feedingTroughPoi = new PoiType("quark:feeding_trough", PoiType.m_27372_((Block)feedingTrough), 1, 32);
        RegistryHelper.register((IForgeRegistryEntry)feedingTroughPoi, (String)"feeding_trough");
    }

    static {
        cooldown = 30;
        maxAnimals = 32;
        loveChance = 0.333333333;
        range = 10.0;
        breedingOccurred = ThreadLocal.withInitial(() -> false);
    }
}

