/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.block;

import it.unimi.dsi.fastutil.floats.Float2ObjectArrayMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.block.SimpleFluidloggedBlock;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.base.module.QuarkModule;

public class GrateBlock
extends QuarkBlock
implements SimpleFluidloggedBlock {
    private static final VoxelShape TRUE_SHAPE = GrateBlock.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Float2ObjectArrayMap<VoxelShape> WALK_BLOCK_CACHE = new Float2ObjectArrayMap();
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty LAVALOGGED = BooleanProperty.m_61465_((String)"lavalogged");

    public GrateBlock(QuarkModule module) {
        super("grate", module, CreativeModeTab.f_40750_, BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, 10.0f).m_60918_(SoundType.f_56743_).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LAVALOGGED, (Comparable)Boolean.valueOf(false)));
        RenderLayerHandler.setRenderType((Block)this, RenderLayerHandler.RenderTypeSkeleton.CUTOUT);
    }

    private static VoxelShape createNewBox(double stepHeight) {
        return GrateBlock.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)(17.0 + 16.0 * stepHeight), (double)16.0);
    }

    public boolean m_49967_() {
        return true;
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return TRUE_SHAPE;
    }

    private static VoxelShape getCachedShape(float stepHeight) {
        return (VoxelShape)WALK_BLOCK_CACHE.computeIfAbsent(stepHeight, GrateBlock::createNewBox);
    }

    public boolean collisionExtendsVertically(BlockState state, BlockGetter level, BlockPos pos, Entity collidingEntity) {
        Animal animal;
        if (!(!(collidingEntity instanceof Animal) && !(collidingEntity instanceof WaterAnimal) || collidingEntity instanceof Animal && (animal = (Animal)collidingEntity).m_21524_() != null)) {
            WaterAnimal waterAnimal;
            return !(collidingEntity instanceof WaterAnimal) || (waterAnimal = (WaterAnimal)collidingEntity).m_21524_() == null;
        }
        return false;
    }

    @Nonnull
    public VoxelShape m_5939_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        Entity entity;
        Entity entity2 = entity = context instanceof EntityCollisionContext ? ((EntityCollisionContext)context).m_193113_() : null;
        if (entity != null) {
            WaterAnimal waterAnimal;
            Animal animal;
            if (entity instanceof ItemEntity || entity instanceof ExperienceOrb) {
                return Shapes.m_83040_();
            }
            boolean preventedType = entity instanceof Animal || entity instanceof WaterAnimal;
            boolean leashed = entity instanceof Animal && (animal = (Animal)entity).m_21524_() != null || entity instanceof WaterAnimal && (waterAnimal = (WaterAnimal)entity).m_21524_() != null;
            boolean onGrate = world.m_8055_(entity.m_142538_().m_142082_(0, -1, 0)).m_60734_() instanceof GrateBlock;
            if (preventedType && !leashed && !onGrate) {
                return GrateBlock.getCachedShape(entity.f_19793_);
            }
            return TRUE_SHAPE;
        }
        return TRUE_SHAPE;
    }

    @Nullable
    public BlockPathTypes getAiPathNodeType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        if (entity instanceof Animal || entity instanceof WaterAnimal) {
            return BlockPathTypes.DAMAGE_OTHER;
        }
        return null;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Fluid fluidAt = context.m_43725_().m_6425_(context.m_8083_()).m_76152_();
        BlockState state = this.m_49966_();
        return this.acceptsFluid(fluidAt) ? this.withFluid(state, fluidAt) : state;
    }

    public boolean m_7357_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull PathComputationType path) {
        return false;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return this.fluidContained(state).getAttributes().getLuminosity();
    }

    public boolean m_7420_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos) {
        return this.fluidContained(state) == Fluids.f_76191_;
    }

    public boolean isValidSpawn(BlockState state, BlockGetter world, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        return false;
    }

    public boolean m_7923_(@Nonnull BlockState state) {
        return true;
    }

    public void m_6861_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Block updatedBlock, @Nonnull BlockPos neighbor, boolean isMoving) {
        BlockState neighborState;
        super.m_6861_(state, level, pos, updatedBlock, neighbor, isMoving);
        if (!pos.m_7495_().equals((Object)neighbor) && (neighborState = level.m_8055_(neighbor)).m_60819_().m_205070_(FluidTags.f_13131_) && this.fluidContained(state).m_6212_((Fluid)Fluids.f_76195_)) {
            level.m_46961_(pos, true);
            level.m_7731_(pos, ForgeEventFactory.fireFluidPlaceBlockEvent((LevelAccessor)level, (BlockPos)pos, (BlockPos)neighbor, (BlockState)Blocks.f_50080_.m_49966_()), 3);
            level.m_46796_(1501, pos, 0);
        }
    }

    @Nonnull
    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        Fluid fluid;
        if (((Boolean)state.m_61143_((Property)LAVALOGGED)).booleanValue() && ((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            state = this.withFluid(state, (Fluid)Fluids.f_76193_);
        }
        if ((fluid = this.fluidContained(state)) != Fluids.f_76191_) {
            level.m_186469_(pos, fluid, fluid.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, LAVALOGGED});
    }

    @Nonnull
    public FluidState m_5888_(@Nonnull BlockState state) {
        FluidState contained = this.fluidContained(state).m_76145_();
        if (contained.m_61138_((Property)BlockStateProperties.f_61434_)) {
            contained = (FluidState)contained.m_61124_((Property)BlockStateProperties.f_61434_, (Comparable)Boolean.valueOf(false));
        }
        return contained;
    }

    @Override
    public boolean acceptsFluid(@Nonnull Fluid fluid) {
        return fluid == Fluids.f_76193_ || fluid == Fluids.f_76195_;
    }

    @Override
    @Nonnull
    public BlockState withFluid(@Nonnull BlockState state, @Nonnull Fluid fluid) {
        return (BlockState)((BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid == Fluids.f_76193_))).m_61124_((Property)LAVALOGGED, (Comparable)Boolean.valueOf(fluid == Fluids.f_76195_));
    }

    @Override
    @Nonnull
    public Fluid fluidContained(@Nonnull BlockState state) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.f_76193_;
        }
        if (((Boolean)state.m_61143_((Property)LAVALOGGED)).booleanValue()) {
            return Fluids.f_76195_;
        }
        return Fluids.f_76191_;
    }
}

