/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.module;

import com.google.common.collect.ImmutableSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.building.block.LeafCarpetBlock;
import vazkii.quark.content.world.block.BlossomLeavesBlock;
import vazkii.quark.content.world.module.BlossomTreesModule;

@LoadModule(category=ModuleCategory.BUILDING, antiOverlap={"woodworks"})
public class LeafCarpetModule
extends QuarkModule {
    public static List<LeafCarpetBlock> carpets = new LinkedList<LeafCarpetBlock>();

    @Override
    public void register() {
        ImmutableSet.of((Object)Blocks.f_50050_, (Object)Blocks.f_50051_, (Object)Blocks.f_50052_, (Object)Blocks.f_50053_, (Object)Blocks.f_50054_, (Object)Blocks.f_50055_, (Object[])new Block[]{Blocks.f_152470_, Blocks.f_152471_}).forEach(this::carpet);
    }

    @Override
    public void postRegister() {
        BlossomTreesModule.trees.keySet().stream().map(t -> (BlossomLeavesBlock)t.leaf.m_60734_()).forEach(this::blossomCarpet);
    }

    @Override
    public void loadComplete() {
        this.enqueue(() -> {
            for (LeafCarpetBlock c : carpets) {
                if (c.m_5456_() == null) continue;
                ComposterBlock.f_51914_.put((Object)c.m_5456_(), 0.2f);
            }
        });
    }

    private void carpet(Block base) {
        this.carpetBlock(base);
    }

    private void blossomCarpet(BlossomLeavesBlock base) {
        this.carpetBlock((Block)base).setCondition(base::isEnabled);
    }

    private LeafCarpetBlock carpetBlock(Block base) {
        LeafCarpetBlock carpet = new LeafCarpetBlock(base.getRegistryName().m_135815_().replaceAll("_leaves", ""), base, this);
        carpets.add(carpet);
        return carpet;
    }
}

