/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.management.module;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.OpenBoatChestMessage;
import vazkii.quark.content.management.client.render.entity.ChestPassengerRenderer;
import vazkii.quark.content.management.entity.ChestPassenger;

@LoadModule(category=ModuleCategory.MANAGEMENT, hasSubscriptions=true)
public class ChestsInBoatsModule
extends QuarkModule {
    public static EntityType<ChestPassenger> chestPassengerEntityType;
    private static TagKey<Item> boatableChestsTag;

    @Override
    public void register() {
        chestPassengerEntityType = EntityType.Builder.m_20704_(ChestPassenger::new, (MobCategory)MobCategory.MISC).m_20699_(0.8f, 0.8f).m_20717_(128).setCustomClientFactory((spawnEntity, world) -> new ChestPassenger((EntityType<? extends ChestPassenger>)chestPassengerEntityType, (Level)world)).m_20712_("chest_passenger");
        RegistryHelper.register(chestPassengerEntityType, (String)"chest_passenger");
    }

    @Override
    public void setup() {
        boatableChestsTag = ItemTags.create((ResourceLocation)new ResourceLocation("quark", "boatable_chests"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        EntityRenderers.m_174036_(chestPassengerEntityType, ChestPassengerRenderer::new);
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity target = event.getTarget();
        Player player = event.getPlayer();
        if (target instanceof Boat && target.m_20197_().isEmpty()) {
            InteractionHand hand = InteractionHand.MAIN_HAND;
            ItemStack stack = player.m_21205_();
            if (!this.isChest(stack)) {
                stack = player.m_21206_();
                hand = InteractionHand.OFF_HAND;
            }
            if (this.isChest(stack)) {
                Level world = event.getWorld();
                if (!event.getWorld().f_46443_) {
                    ItemStack chestStack = stack.m_41777_();
                    chestStack.m_41764_(1);
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                    ChestPassenger passenger = new ChestPassenger(world, chestStack);
                    Vec3 pos = target.m_20182_();
                    passenger.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
                    passenger.m_146922_(target.m_146908_());
                    passenger.m_7998_(target, true);
                    world.m_7967_((Entity)passenger);
                }
                player.m_6674_(hand);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    @OnlyIn(value=Dist.CLIENT)
    public void onOpenGUI(ScreenOpenEvent event) {
        Entity riding;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && event.getScreen() instanceof InventoryScreen && player.m_20159_() && (riding = player.m_20202_()) instanceof Boat) {
            List passengers = riding.m_20197_();
            for (Entity passenger : passengers) {
                if (!(passenger instanceof ChestPassenger)) continue;
                QuarkNetwork.sendToServer(new OpenBoatChestMessage());
                event.setCanceled(true);
                return;
            }
        }
    }

    private boolean isChest(ItemStack stack) {
        return !stack.m_41619_() && stack.m_204117_(boatableChestsTag);
    }
}

