/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.command;

import com.google.common.base.Strings;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import doggytalents.common.command.arguments.UUIDArgument;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.item.RadarItem;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.storage.DogRespawnData;
import doggytalents.common.storage.DogRespawnStorage;
import doggytalents.common.storage.IDogData;
import doggytalents.common.util.Util;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.commands.synchronization.EmptyArgumentSerializer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class DogRespawnCommand {
    public static final DynamicCommandExceptionType COLOR_INVALID = new DynamicCommandExceptionType(arg -> new TranslatableComponent("command.dogrespawn.invalid", new Object[]{arg}));
    public static final DynamicCommandExceptionType SPAWN_EXCEPTION = new DynamicCommandExceptionType(arg -> new TranslatableComponent("command.dogrespawn.exception", new Object[]{arg}));
    public static final Dynamic2CommandExceptionType TOO_MANY_OPTIONS = new Dynamic2CommandExceptionType((arg1, arg2) -> new TranslatableComponent("command.dogrespawn.imprecise", new Object[]{arg1, arg2}));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dog").requires(s -> s.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"locate").then(Commands.m_82127_((String)"byuuid").then(Commands.m_82129_((String)"dog_owner", (ArgumentType)UUIDArgument.uuid()).suggests(DogRespawnCommand.getOwnerIdSuggestionsLocate()).then(Commands.m_82129_((String)"dog_uuid", (ArgumentType)UUIDArgument.uuid()).suggests(DogRespawnCommand.getDogIdSuggestionsLocate()).executes(c -> DogRespawnCommand.locate((CommandContext<CommandSourceStack>)c)))))).then(Commands.m_82127_((String)"byname").then(Commands.m_82129_((String)"owner_name", (ArgumentType)StringArgumentType.string()).suggests(DogRespawnCommand.getOwnerNameSuggestionsLocate()).then(Commands.m_82129_((String)"dog_name", (ArgumentType)StringArgumentType.string()).suggests(DogRespawnCommand.getDogNameSuggestionsLocate()).executes(c -> DogRespawnCommand.locate2((CommandContext<CommandSourceStack>)c))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"revive").then(Commands.m_82127_((String)"byuuid").then(Commands.m_82129_((String)"dog_owner", (ArgumentType)UUIDArgument.uuid()).suggests(DogRespawnCommand.getOwnerIdSuggestionsRevive()).then(Commands.m_82129_((String)"dog_uuid", (ArgumentType)UUIDArgument.uuid()).suggests(DogRespawnCommand.getDogIdSuggestionsRevive()).executes(c -> DogRespawnCommand.respawn((CommandContext<CommandSourceStack>)c)))))).then(Commands.m_82127_((String)"byname").then(Commands.m_82129_((String)"owner_name", (ArgumentType)StringArgumentType.string()).suggests(DogRespawnCommand.getOwnerNameSuggestionsRevive()).then(Commands.m_82129_((String)"dog_name", (ArgumentType)StringArgumentType.string()).suggests(DogRespawnCommand.getDogNameSuggestionsRevive()).executes(c -> DogRespawnCommand.respawn2((CommandContext<CommandSourceStack>)c)))))));
    }

    public static void registerSerilizers() {
        ArgumentTypes.m_121601_((String)Util.getResourcePath("uuid"), UUIDArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(UUIDArgument::uuid));
    }

    private static <S extends SharedSuggestionProvider> SuggestionProvider<S> getOwnerIdSuggestionsLocate() {
        return (context, builder) -> DogRespawnCommand.getOwnerIdSuggestions(DogLocationStorage.get((Level)((CommandSourceStack)context.getSource()).m_81372_()).getAll(), context, builder);
    }

    private static <S extends SharedSuggestionProvider> SuggestionProvider<S> getOwnerIdSuggestionsRevive() {
        return (context, builder) -> DogRespawnCommand.getOwnerIdSuggestions(DogRespawnStorage.get((Level)((CommandSourceStack)context.getSource()).m_81372_()).getAll(), context, builder);
    }

    private static <S extends SharedSuggestionProvider> CompletableFuture<Suggestions> getOwnerIdSuggestions(Collection<? extends IDogData> possibilities, CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof CommandSourceStack) {
            return SharedSuggestionProvider.m_82970_((Iterable)possibilities.stream().map(IDogData::getOwnerId).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()), (SuggestionsBuilder)builder);
        }
        if (context.getSource() instanceof SharedSuggestionProvider) {
            return ((SharedSuggestionProvider)context.getSource()).m_212155_(context);
        }
        return Suggestions.empty();
    }

    private static <S extends SharedSuggestionProvider> SuggestionProvider<S> getDogIdSuggestionsLocate() {
        return (context, builder) -> DogRespawnCommand.getDogIdSuggestions(DogLocationStorage.get((Level)((CommandSourceStack)context.getSource()).m_81372_()).getAll(), context, builder);
    }

    private static <S extends SharedSuggestionProvider> SuggestionProvider<S> getDogIdSuggestionsRevive() {
        return (context, builder) -> DogRespawnCommand.getDogIdSuggestions(DogRespawnStorage.get((Level)((CommandSourceStack)context.getSource()).m_81372_()).getAll(), context, builder);
    }

    private static <S extends SharedSuggestionProvider> CompletableFuture<Suggestions> getDogIdSuggestions(Collection<? extends IDogData> possibilities, CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof CommandSourceStack) {
            UUID ownerId = (UUID)context.getArgument("dog_owner", UUID.class);
            if (ownerId == null) {
                return Suggestions.empty();
            }
            return SharedSuggestionProvider.m_82970_((Iterable)possibilities.stream().filter(data -> ownerId.equals(data.getOwnerId())).map(IDogData::getDogId).map(Object::toString).collect(Collectors.toSet()), (SuggestionsBuilder)builder);
        }
        if (context.getSource() instanceof SharedSuggestionProvider) {
            return ((SharedSuggestionProvider)context.getSource()).m_212155_(context);
        }
        return Suggestions.empty();
    }

    private static <S extends SharedSuggestionProvider> SuggestionProvider<S> getOwnerNameSuggestionsLocate() {
        return (context, builder) -> DogRespawnCommand.getOwnerNameSuggestions(DogLocationStorage.get((Level)((CommandSourceStack)context.getSource()).m_81372_()).getAll(), context, builder);
    }

    private static <S extends SharedSuggestionProvider> SuggestionProvider<S> getOwnerNameSuggestionsRevive() {
        return (context, builder) -> DogRespawnCommand.getOwnerNameSuggestions(DogRespawnStorage.get((Level)((CommandSourceStack)context.getSource()).m_81372_()).getAll(), context, builder);
    }

    public static <S extends SharedSuggestionProvider> CompletableFuture<Suggestions> getOwnerNameSuggestions(Collection<? extends IDogData> possibilities, CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof CommandSourceStack) {
            return SharedSuggestionProvider.m_82970_((Iterable)possibilities.stream().map(IDogData::getOwnerName).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()), (SuggestionsBuilder)builder);
        }
        if (context.getSource() instanceof SharedSuggestionProvider) {
            return ((SharedSuggestionProvider)context.getSource()).m_212155_(context);
        }
        return Suggestions.empty();
    }

    private static <S extends SharedSuggestionProvider> SuggestionProvider<S> getDogNameSuggestionsLocate() {
        return (context, builder) -> DogRespawnCommand.getDogNameSuggestions(DogLocationStorage.get((Level)((CommandSourceStack)context.getSource()).m_81372_()).getAll(), context, builder);
    }

    private static <S extends SharedSuggestionProvider> SuggestionProvider<S> getDogNameSuggestionsRevive() {
        return (context, builder) -> DogRespawnCommand.getDogNameSuggestions(DogRespawnStorage.get((Level)((CommandSourceStack)context.getSource()).m_81372_()).getAll(), context, builder);
    }

    public static <S extends SharedSuggestionProvider> CompletableFuture<Suggestions> getDogNameSuggestions(Collection<? extends IDogData> possibilities, CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof CommandSourceStack) {
            String ownerName = (String)context.getArgument("owner_name", String.class);
            if (ownerName == null) {
                return Suggestions.empty();
            }
            return SharedSuggestionProvider.m_82970_((Iterable)possibilities.stream().filter(data -> ownerName.equals(data.getOwnerName())).map(IDogData::getDogName).filter(str -> !Strings.isNullOrEmpty((String)str)).collect(Collectors.toList()), (SuggestionsBuilder)builder);
        }
        if (context.getSource() instanceof SharedSuggestionProvider) {
            return ((SharedSuggestionProvider)context.getSource()).m_212155_(context);
        }
        return Suggestions.empty();
    }

    private static int respawn(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        source.m_81375_();
        ServerLevel world = source.m_81372_();
        UUID ownerUuid = (UUID)ctx.getArgument("dog_owner", UUID.class);
        UUID uuid = (UUID)ctx.getArgument("dog_uuid", UUID.class);
        DogRespawnStorage respawnStorage = DogRespawnStorage.get((Level)world);
        DogRespawnData respawnData = respawnStorage.getData(uuid);
        if (respawnData == null) {
            throw COLOR_INVALID.create((Object)uuid.toString());
        }
        return DogRespawnCommand.respawn(respawnStorage, respawnData, source);
    }

    private static int respawn2(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        source.m_81375_();
        ServerLevel world = source.m_81372_();
        String ownerName = (String)ctx.getArgument("owner_name", String.class);
        String dogName = (String)ctx.getArgument("dog_name", String.class);
        DogRespawnStorage respawnStorage = DogRespawnStorage.get((Level)world);
        List respawnData = respawnStorage.getDogs(ownerName).filter(data -> data.getDogName().equalsIgnoreCase(dogName)).collect(Collectors.toList());
        if (respawnData.isEmpty()) {
            throw COLOR_INVALID.create((Object)dogName);
        }
        if (respawnData.size() > 1) {
            StringJoiner joiner = new StringJoiner(", ");
            for (DogRespawnData data2 : respawnData) {
                joiner.add(Objects.toString(data2.getDogId()));
            }
            throw TOO_MANY_OPTIONS.create((Object)joiner.toString(), (Object)respawnData.size());
        }
        return DogRespawnCommand.respawn(respawnStorage, (DogRespawnData)respawnData.get(0), source);
    }

    private static int respawn(DogRespawnStorage respawnStorage, DogRespawnData respawnData, CommandSourceStack source) throws CommandSyntaxException {
        DogEntity dog = respawnData.respawn(source.m_81372_(), (Player)source.m_81375_(), source.m_81375_().m_142538_().m_7494_());
        if (dog != null) {
            respawnStorage.remove(respawnData.getDogId());
            source.m_81354_((Component)new TranslatableComponent("commands.dogrespawn.uuid.success", new Object[]{respawnData.getDogName()}), false);
            return 1;
        }
        source.m_81354_((Component)new TranslatableComponent("commands.dogrespawn.uuid.failure", new Object[]{respawnData.getDogName()}), false);
        return 0;
    }

    private static int locate(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        source.m_81375_();
        ServerLevel world = source.m_81372_();
        UUID ownerUuid = (UUID)ctx.getArgument("dog_owner", UUID.class);
        UUID uuid = (UUID)ctx.getArgument("dog_uuid", UUID.class);
        DogLocationStorage locationStorage = DogLocationStorage.get((Level)world);
        DogLocationData locationData = locationStorage.getData(uuid);
        if (locationData == null) {
            throw COLOR_INVALID.create((Object)uuid.toString());
        }
        return DogRespawnCommand.locate(locationStorage, locationData, source);
    }

    private static int locate2(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        source.m_81375_();
        ServerLevel world = source.m_81372_();
        String ownerName = (String)ctx.getArgument("owner_name", String.class);
        String dogName = (String)ctx.getArgument("dog_name", String.class);
        DogLocationStorage locationStorage = DogLocationStorage.get((Level)world);
        List locationData = locationStorage.getAll().stream().filter(data -> ownerName.equals(data.getOwnerName())).filter(data -> data.getDogName().equalsIgnoreCase(dogName)).collect(Collectors.toList());
        if (locationData.isEmpty()) {
            throw COLOR_INVALID.create((Object)dogName);
        }
        if (locationData.size() > 1) {
            StringJoiner joiner = new StringJoiner(", ");
            for (DogLocationData data2 : locationData) {
                joiner.add(Objects.toString(data2.getDogId()));
            }
            throw TOO_MANY_OPTIONS.create((Object)joiner.toString(), (Object)locationData.size());
        }
        return DogRespawnCommand.locate(locationStorage, (DogLocationData)locationData.get(0), source);
    }

    private static int locate(DogLocationStorage respawnStorage, DogLocationData locationData, CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        if (locationData.getDimension().equals((Object)player.f_19853_.m_46472_())) {
            String translateStr = RadarItem.getDirectionTranslationKey(locationData, (Entity)player);
            int distance = Mth.m_14165_((double)(locationData.getPos() != null ? locationData.getPos().m_82554_(player.m_20182_()) : -1.0));
            source.m_81354_((Component)new TranslatableComponent(translateStr, new Object[]{locationData.getName(player.f_19853_), distance}), false);
        } else {
            source.m_81354_((Component)new TranslatableComponent("dogradar.notindim", new Object[]{locationData.getDimension()}), false);
        }
        return 1;
    }
}

