/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.common.entity.DogEntity;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.DogNameData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class DogNamePacket
extends DogPacket<DogNameData> {
    @Override
    public void encode(DogNameData data, FriendlyByteBuf buf) {
        super.encode(data, buf);
        buf.m_130072_(data.name, 64);
    }

    @Override
    public DogNameData decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        String name = buf.m_130136_(64);
        return new DogNameData(entityId, name);
    }

    @Override
    public void handleDog(DogEntity dogIn, DogNameData data, Supplier<NetworkEvent.Context> ctx) {
        if (!dogIn.canInteract((LivingEntity)ctx.get().getSender())) {
            return;
        }
        if (data.name.isEmpty()) {
            dogIn.m_6593_(null);
        } else {
            dogIn.m_6593_((Component)new TextComponent(data.name));
        }
    }
}

