/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.service.webmap.kotlin.routes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import info.journeymap.shaded.kotlin.kotlin.Metadata;
import info.journeymap.shaded.kotlin.kotlin.jvm.internal.Intrinsics;
import info.journeymap.shaded.kotlin.spark.kotlin.RouteHandler;
import info.journeymap.shaded.org.jetbrains.annotations.NotNull;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import journeymap.client.JourneymapClient;
import journeymap.client.io.FileHandler;
import journeymap.client.io.MapSaver;
import journeymap.client.model.MapType;
import journeymap.client.task.multi.MapRegionTask;
import journeymap.client.task.multi.SaveMapTask;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.Logger;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a \u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a \u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"GSON", "Lcom/google/gson/Gson;", "logger", "Lorg/apache/logging/log4j/Logger;", "actionGet", "", "handler", "Linfo/journeymap/shaded/kotlin/spark/kotlin/RouteHandler;", "autoMap", "minecraft", "Lnet/minecraft/client/Minecraft;", "level", "Lnet/minecraft/world/level/Level;", "saveMap", "journeymap"})
public final class ActionKt {
    @NotNull
    private static final Gson GSON;
    @NotNull
    private static final Logger logger;

    @NotNull
    public static final Object actionGet(@NotNull RouteHandler handler) {
        Object object;
        Intrinsics.checkNotNullParameter(handler, "handler");
        Minecraft minecraft = Minecraft.m_91087_();
        Intrinsics.checkNotNullExpressionValue(minecraft, "getInstance()");
        Minecraft minecraft2 = minecraft;
        Level level = (Level)minecraft2.f_91073_;
        if (level == null) {
            logger.warn("Action requested before world loaded");
            handler.status(400);
            return "World not loaded";
        }
        if (!JourneymapClient.getInstance().isMapping().booleanValue()) {
            logger.warn("Action requested before Journeymap started");
            handler.status(400);
            return "JourneyMap is still starting";
        }
        String type = handler.params("type");
        String string = type;
        if (Intrinsics.areEqual(string, "automap")) {
            object = ActionKt.autoMap(handler, minecraft2, level);
        } else if (Intrinsics.areEqual(string, "savemap")) {
            object = ActionKt.saveMap(handler, minecraft2, level);
        } else {
            logger.warn("Unknown action type '" + type + "'");
            handler.status(400);
            object = "Unknown action type '" + type + "'";
        }
        return object;
    }

    @NotNull
    public static final Object saveMap(@NotNull RouteHandler handler, @NotNull Minecraft minecraft, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(handler, "handler");
        Intrinsics.checkNotNullParameter(minecraft, "minecraft");
        Intrinsics.checkNotNullParameter(level, "level");
        File file = FileHandler.getJMWorldDir(minecraft);
        Intrinsics.checkNotNullExpressionValue(file, "getJMWorldDir(minecraft)");
        File worldDir = file;
        if (!worldDir.exists() || !worldDir.isDirectory()) {
            logger.warn("JM world directory not found");
            handler.status(500);
            return "Unable to find JourneyMap world directory";
        }
        String string = handler.getRequest().queryParamOrDefault("dim", "overworld");
        Intrinsics.checkNotNullExpressionValue(string, "handler.request.queryPar\u2026fault(\"dim\", \"overworld\")");
        String dimension = string;
        String string2 = handler.getRequest().queryParamOrDefault("mapType", MapType.Name.day.name());
        Intrinsics.checkNotNullExpressionValue(string2, "handler.request.queryPar\u2026\", MapType.Name.day.name)");
        String mapTypeString = string2;
        Integer vSlice = handler.queryMap("depth").integerValue();
        MapType.Name mapTypeName = null;
        try {
            mapTypeName = MapType.Name.valueOf(mapTypeString);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Invalid map type '" + mapTypeString + "'");
            handler.status(400);
            return "Invalid map type '" + mapTypeString + "'";
        }
        if (mapTypeName != MapType.Name.underground) {
            vSlice = null;
        }
        boolean hardcore = level.m_6106_().m_5466_();
        MapType mapType = MapType.from(mapTypeName, vSlice, DimensionHelper.getWorldKeyForName(dimension));
        Intrinsics.checkNotNullExpressionValue(mapType, "from(mapTypeName, vSlice\u2026rldKeyForName(dimension))");
        MapType mapType2 = mapType;
        if (mapType2.isUnderground() && hardcore) {
            logger.warn("Cave mapping is not allowed on hardcore servers");
            handler.status(400);
            return "Cave mapping is not allowed on hardcore servers";
        }
        MapSaver mapSaver = new MapSaver(worldDir, mapType2);
        if (!mapSaver.isValid()) {
            logger.info("No image files to save");
            handler.status(400);
            return "No image files to save";
        }
        JourneymapClient.getInstance().toggleTask(SaveMapTask.Manager.class, true, mapSaver);
        Map data = new LinkedHashMap();
        String string3 = mapSaver.getSaveFileName();
        Intrinsics.checkNotNullExpressionValue(string3, "mapSaver.saveFileName");
        data.put("filename", string3);
        handler.getResponse().raw().setContentType("application/json");
        String string4 = GSON.toJson((Object)data);
        Intrinsics.checkNotNullExpressionValue(string4, "GSON.toJson(data)");
        return string4;
    }

    @NotNull
    public static final Object autoMap(@NotNull RouteHandler handler, @NotNull Minecraft minecraft, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(handler, "handler");
        Intrinsics.checkNotNullParameter(minecraft, "minecraft");
        Intrinsics.checkNotNullParameter(level, "level");
        Map data = new LinkedHashMap();
        boolean enabled = JourneymapClient.getInstance().isTaskManagerEnabled(MapRegionTask.Manager.class);
        String string = handler.getRequest().queryParamOrDefault("scope", "stop");
        Intrinsics.checkNotNullExpressionValue(string, "handler.request.queryPar\u2026rDefault(\"scope\", \"stop\")");
        String scope = string;
        if (Intrinsics.areEqual(scope, "stop") && enabled) {
            JourneymapClient.getInstance().toggleTask(MapRegionTask.Manager.class, false, false);
            data.put("message", "automap_complete");
        } else if (!enabled) {
            boolean doAll = Intrinsics.areEqual(scope, "all");
            JourneymapClient.getInstance().toggleTask(MapRegionTask.Manager.class, true, doAll);
            data.put("message", "automap_started");
        } else {
            data.put("message", "automap_already_started");
        }
        handler.getResponse().raw().setContentType("application/json");
        string = GSON.toJson((Object)data);
        Intrinsics.checkNotNullExpressionValue(string, "GSON.toJson(data)");
        return string;
    }

    static {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Intrinsics.checkNotNullExpressionValue(gson, "GsonBuilder().setPrettyPrinting().create()");
        GSON = gson;
        gson = Journeymap.getLogger("webmap/routes/action");
        Intrinsics.checkNotNullExpressionValue(gson, "getLogger(\"webmap/routes/action\")");
        logger = gson;
    }
}

