/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class FurnitureConfig {
    static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;
    static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    static {
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (Common)commonSpecPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue drawCollisionShapes;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client configuration settings").push("client");
            this.drawCollisionShapes = builder.comment("Draws the collision shape rather than the selection shape when hovering blocks. Used for debugging collisions.").translation("cfm.configgui.drawCollisionShapes").define("drawCollisionShapes", false);
            builder.pop();
        }
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue maxMailQueue;
        public final ForgeConfigSpec.IntValue pullMailInterval;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Mail configuration settings").push("mail");
            this.maxMailQueue = builder.comment("The maximum amount of mail that can be in a player's mail queue.").translation("cfm.configgui.maxMailQueue").defineInRange("maxMailQueue", 20, 1, Integer.MAX_VALUE);
            this.pullMailInterval = builder.comment("The interval in ticks for mail boxes to pull mail from the player's queue").translation("cfm.configgui.pullMailInterval").defineInRange("pullMailInterval", 20, 1, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

