/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.mrcrayfish.furniture.FurnitureConfig;
import com.mrcrayfish.furniture.common.mail.Mail;
import com.mrcrayfish.furniture.common.mail.PostOffice;
import com.mrcrayfish.furniture.core.ModBlockEntities;
import com.mrcrayfish.furniture.inventory.container.MailBoxMenu;
import com.mrcrayfish.furniture.tileentity.BasicLootBlockEntity;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class MailBoxBlockEntity
extends BasicLootBlockEntity {
    private UUID id;
    private String name = "Mail Box";
    private String ownerName;
    private UUID ownerId;

    protected MailBoxBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public MailBoxBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.MAIL_BOX.get(), pos, state);
    }

    public void setId(UUID id) {
        if (this.id == null) {
            this.id = id;
        }
    }

    @Nullable
    public UUID getId() {
        return this.id;
    }

    public void setMailBoxName(String name) {
        this.name = name;
    }

    public String getMailBoxName() {
        return this.name;
    }

    public void setOwner(ServerPlayer entity) {
        this.ownerId = entity.m_142081_();
        this.ownerName = entity.m_7755_().getString();
    }

    @Nullable
    public UUID getOwnerId() {
        return this.ownerId;
    }

    @Nullable
    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public void updateOwnerName(ServerPlayer player) {
        if (player.m_142081_().equals(this.ownerId) && !player.m_7755_().getString().equals(this.ownerName)) {
            this.ownerName = player.m_7755_().getString();
        }
    }

    public void updateIdAndAttemptClaim(ServerPlayer player) {
        if (this.id == null) {
            this.id = UUID.randomUUID();
        }
        if (this.ownerId == null) {
            this.setOwner(player);
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, MailBoxBlockEntity blockEntity) {
        MinecraftServer server = level.m_142572_();
        if (server == null || blockEntity.ownerId == null || blockEntity.id == null) {
            return;
        }
        if (!PostOffice.isRegistered(blockEntity.ownerId, blockEntity.id)) {
            ServerPlayer player = server.m_6846_().m_11259_(blockEntity.ownerId);
            if (player != null) {
                PostOffice.registerMailBox(player, blockEntity.id, "Mail Box", blockEntity.f_58858_);
            }
        } else if (!blockEntity.isFull() && server.m_129921_() % (Integer)FurnitureConfig.COMMON.pullMailInterval.get() == 0) {
            Mail mail;
            Supplier<Mail> supplier = PostOffice.getMailForPlayerMailBox(blockEntity.ownerId, blockEntity.id);
            while (!blockEntity.isFull() && (mail = supplier.get()) != null) {
                blockEntity.addItem(mail.getStack());
            }
        }
    }

    @Override
    public int m_6643_() {
        return 9;
    }

    @Override
    protected Component m_6820_() {
        return new TranslatableComponent("container.cfm.mail_box", new Object[]{this.ownerName, this.name});
    }

    @Override
    protected AbstractContainerMenu m_6555_(int windowId, Inventory playerInventory) {
        return new MailBoxMenu(windowId, playerInventory, this);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.readData(compound);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.writeData(tag);
    }

    public CompoundTag m_5995_() {
        return this.writeData(new CompoundTag());
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag compound = pkt.m_131708_();
        this.readData(compound);
    }

    private void readData(CompoundTag compound) {
        if (compound.m_128403_("MailBoxUUID")) {
            this.id = compound.m_128342_("MailBoxUUID");
        }
        if (compound.m_128425_("MailBoxName", 8)) {
            this.name = compound.m_128461_("MailBoxName");
        }
        if (compound.m_128425_("OwnerName", 8)) {
            this.ownerName = compound.m_128461_("OwnerName");
        }
        if (compound.m_128403_("OwnerUUID")) {
            this.ownerId = compound.m_128342_("OwnerUUID");
        }
    }

    private CompoundTag writeData(CompoundTag compound) {
        if (this.id != null) {
            compound.m_128362_("MailBoxUUID", this.id);
        }
        if (this.name != null) {
            compound.m_128359_("MailBoxName", this.name);
        }
        if (this.ownerName != null && this.ownerId != null) {
            compound.m_128359_("OwnerName", this.ownerName);
            compound.m_128362_("OwnerUUID", this.ownerId);
        }
        return compound;
    }
}

