/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.resourcepack.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.mehvahdjukaar.selene.resourcepack.recipe.IRecipeTemplate;
import net.mehvahdjukaar.selene.resourcepack.recipe.ShapedRecipeTemplate;
import net.mehvahdjukaar.selene.resourcepack.recipe.ShapelessRecipeTemplate;
import net.mehvahdjukaar.selene.resourcepack.recipe.StoneCutterRecipeTemplate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class TemplateRecipeManager {
    private static final Map<ResourceLocation, Function<JsonObject, ? extends IRecipeTemplate<?>>> DESERIALIZERS = new HashMap();

    public static <T extends IRecipeTemplate<?>> void registerTemplate(RecipeSerializer<?> serializer, Function<JsonObject, T> deserializer) {
        TemplateRecipeManager.registerTemplate(serializer.getRegistryName(), deserializer);
    }

    public static <T extends IRecipeTemplate<?>> void registerTemplate(ResourceLocation serializerId, Function<JsonObject, T> deserializer) {
        DESERIALIZERS.put(serializerId, deserializer);
    }

    public static IRecipeTemplate<?> read(JsonObject recipe) throws UnsupportedOperationException {
        String type = GsonHelper.m_13906_((JsonObject)recipe, (String)"type");
        Function<JsonObject, IRecipeTemplate<?>> templateFactory = DESERIALIZERS.get(new ResourceLocation(type));
        if (templateFactory != null) {
            ShapedRecipeTemplate st;
            ShapelessRecipeTemplate template = templateFactory.apply(recipe);
            if (template instanceof ShapedRecipeTemplate && (st = (ShapedRecipeTemplate)((Object)template)).shouldBeShapeless()) {
                template = st.toShapeless();
            }
            if (recipe.has("conditions")) {
                JsonArray cond = recipe.get("conditions").getAsJsonArray();
                List<ICondition> c = TemplateRecipeManager.deserializeConditions(cond);
                c.forEach(template::addCondition);
            }
            return template;
        }
        throw new UnsupportedOperationException(String.format("Invalid recipe serializer: %s. Must be either shaped, shapeless or stonecutting", type));
    }

    public static List<ICondition> deserializeConditions(JsonArray conditions) {
        ArrayList<ICondition> list = new ArrayList<ICondition>();
        for (int x = 0; x < conditions.size(); ++x) {
            if (!conditions.get(x).isJsonObject()) {
                throw new JsonSyntaxException("Conditions must be an array of JsonObjects");
            }
            JsonObject json = conditions.get(x).getAsJsonObject();
            list.add(CraftingHelper.getCondition((JsonObject)json));
        }
        return list;
    }

    static {
        TemplateRecipeManager.registerTemplate(RecipeSerializer.f_44076_, ShapedRecipeTemplate::new);
        TemplateRecipeManager.registerTemplate(RecipeSerializer.f_44077_, ShapelessRecipeTemplate::new);
        TemplateRecipeManager.registerTemplate(RecipeSerializer.f_44095_, StoneCutterRecipeTemplate::new);
    }
}

