/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.recipe;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import info.u_team.u_team_core.api.dye.DyeableItem;
import info.u_team.u_team_core.recipeserializer.UShapedRecipeSerializer;
import info.u_team.u_team_core.util.ColorUtil;
import info.u_team.useful_backpacks.init.UsefulBackpacksRecipeSerializers;
import info.u_team.useful_backpacks.item.BackpackItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class BackpackCraftingRecipe
extends ShapedRecipe {
    public BackpackCraftingRecipe(ResourceLocation id, String group, int width, int height, NonNullList<Ingredient> ingredients, ItemStack output) {
        super(id, group, width, height, ingredients, output);
    }

    public ItemStack m_5874_(CraftingContainer inventory) {
        ItemStack backpackItem = super.m_5874_(inventory);
        ArrayList dyeList = Lists.newArrayList();
        boolean backpackPresent = false;
        for (int index = 0; index < inventory.m_6643_(); ++index) {
            DyeColor color2;
            ItemStack slotStack = inventory.m_8020_(index);
            if (slotStack.m_41619_()) continue;
            Item item = slotStack.m_41720_();
            if (item instanceof BackpackItem) {
                if (backpackPresent) {
                    return ItemStack.f_41583_;
                }
                backpackPresent = true;
                if (!slotStack.m_41782_()) continue;
                backpackItem.m_41751_(slotStack.m_41783_().m_6426_());
                continue;
            }
            if (!slotStack.m_204117_(ItemTags.f_13167_) || (color2 = ColorUtil.getColorFromWool((Item)item)) == null) continue;
            dyeList.add(color2);
        }
        if (!dyeList.isEmpty() && !dyeList.parallelStream().allMatch(color -> color == DyeColor.WHITE)) {
            return DyeableItem.colorStack((ItemStack)backpackItem, (List)dyeList);
        }
        return backpackItem;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)UsefulBackpacksRecipeSerializers.BACKPACK.get();
    }

    public static class Serializer
    extends UShapedRecipeSerializer<BackpackCraftingRecipe> {
        public BackpackCraftingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Map keys = Serializer.deserializeKey((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] pattern = Serializer.shrink((String[])Serializer.patternFromJson((JsonArray)GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
            int width = pattern[0].length();
            int height = pattern.length;
            NonNullList ingredients = Serializer.deserializeIngredients((String[])pattern, (Map)keys, (int)width, (int)height);
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new BackpackCraftingRecipe(recipeId, group, width, height, (NonNullList<Ingredient>)ingredients, output);
        }

        public BackpackCraftingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int width = buffer.m_130242_();
            int height = buffer.m_130242_();
            String group = buffer.m_130136_(Short.MAX_VALUE);
            NonNullList ingredients = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            for (int index = 0; index < ingredients.size(); ++index) {
                ingredients.set(index, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack output = buffer.m_130267_();
            return new BackpackCraftingRecipe(recipeId, group, width, height, (NonNullList<Ingredient>)ingredients, output);
        }

        public void toNetwork(FriendlyByteBuf buffer, BackpackCraftingRecipe recipe) {
            buffer.m_130130_(recipe.m_44220_());
            buffer.m_130130_(recipe.m_44221_());
            buffer.m_130070_(recipe.m_6076_());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.m_8043_());
        }
    }
}

