/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.block;

import com.starfish_studios.another_furniture.block.SeatBlock;
import com.starfish_studios.another_furniture.block.ShelfBlock;
import com.starfish_studios.another_furniture.block.properties.HorizontalConnectionType;
import com.starfish_studios.another_furniture.entity.SeatEntity;
import com.starfish_studios.another_furniture.registry.AFBlockTags;
import com.starfish_studios.another_furniture.registry.AFSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ChairBlock
extends SeatBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty TUCKED = BooleanProperty.m_61465_((String)"tucked");
    protected static final VoxelShape SEAT = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)7.0, (double)14.0);
    protected static final VoxelShape SHAPE_NORTH = Shapes.m_83110_((VoxelShape)SEAT, (VoxelShape)Block.m_49796_((double)2.0, (double)7.0, (double)12.0, (double)14.0, (double)16.0, (double)14.0));
    protected static final VoxelShape SHAPE_EAST = Shapes.m_83110_((VoxelShape)SEAT, (VoxelShape)Block.m_49796_((double)2.0, (double)7.0, (double)2.0, (double)4.0, (double)16.0, (double)14.0));
    protected static final VoxelShape SHAPE_SOUTH = Shapes.m_83110_((VoxelShape)SEAT, (VoxelShape)Block.m_49796_((double)2.0, (double)7.0, (double)2.0, (double)14.0, (double)16.0, (double)4.0));
    protected static final VoxelShape SHAPE_WEST = Shapes.m_83110_((VoxelShape)SEAT, (VoxelShape)Block.m_49796_((double)12.0, (double)7.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0));
    protected static final VoxelShape SHAPE_NORTH_TUCKED = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)7.0, (double)3.0, (double)14.0, (double)16.0, (double)5.0), (VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)7.0, (double)5.0));
    protected static final VoxelShape SHAPE_EAST_TUCKED = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)11.0, (double)7.0, (double)2.0, (double)13.0, (double)16.0, (double)14.0), (VoxelShape)Block.m_49796_((double)11.0, (double)0.0, (double)2.0, (double)16.0, (double)7.0, (double)14.0));
    protected static final VoxelShape SHAPE_SOUTH_TUCKED = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)7.0, (double)11.0, (double)14.0, (double)16.0, (double)13.0), (VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)11.0, (double)14.0, (double)7.0, (double)16.0));
    protected static final VoxelShape SHAPE_WEST_TUCKED = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)3.0, (double)7.0, (double)2.0, (double)5.0, (double)16.0, (double)14.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)5.0, (double)7.0, (double)14.0));
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{SHAPE_SOUTH, SHAPE_WEST, SHAPE_NORTH, SHAPE_EAST, SHAPE_SOUTH_TUCKED, SHAPE_WEST_TUCKED, SHAPE_NORTH_TUCKED, SHAPE_EAST_TUCKED};

    public ChairBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TUCKED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public float seatHeight() {
        return 0.2f;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        int shape = ((Direction)pState.m_61143_((Property)FACING)).m_122416_();
        if (((Boolean)pState.m_61143_((Property)TUCKED)).booleanValue()) {
            shape += 4;
        }
        return SHAPES[shape];
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        boolean waterlogged = pContext.m_43725_().m_6425_(pContext.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        if (((Boolean)pState.m_61143_((Property)TUCKED)).booleanValue() && !this.canTuckUnderFacing(pState, (Level)pLevel, pCurrentPos)) {
            return (BlockState)pState.m_61124_((Property)TUCKED, (Comparable)Boolean.valueOf(false));
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    @Override
    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        boolean tucked = (Boolean)pState.m_61143_((Property)TUCKED);
        if ((pPlayer.m_6047_() || tucked) && pPlayer.m_21205_().m_41619_() && pPlayer.m_21206_().m_41619_() && this.canTuckUnderFacing(pState, pLevel, pPos)) {
            if (tucked) {
                pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)TUCKED, (Comparable)Boolean.valueOf(false)));
                pLevel.m_5594_(null, pPos, AFSoundEvents.CHAIR_UNTUCK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (this.isChairBlocking(pState, pLevel, pPos)) {
                pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)TUCKED, (Comparable)Boolean.valueOf(true)));
                pLevel.m_5594_(null, pPos, AFSoundEvents.CHAIR_TUCK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public PushReaction m_5537_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)TUCKED) != false ? PushReaction.BLOCK : super.m_5537_(pState);
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, TUCKED, WATERLOGGED});
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    public boolean canTuckUnderFacing(BlockState state, Level level, BlockPos pos) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        BlockState facing_state = level.m_8055_(pos.m_142300_(dir));
        Block facing_state_block = facing_state.m_60734_();
        if (facing_state_block instanceof ShelfBlock) {
            return facing_state.m_61143_(ShelfBlock.TYPE) == HorizontalConnectionType.MIDDLE || facing_state.m_61143_((Property)FACING) != dir;
        }
        if (facing_state_block instanceof SlabBlock) {
            return facing_state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.TOP;
        }
        if (facing_state_block instanceof StairBlock) {
            StairsShape shape = (StairsShape)facing_state.m_61143_((Property)StairBlock.f_56843_);
            Direction facing_dir = (Direction)facing_state.m_61143_((Property)FACING);
            return facing_state.m_61143_((Property)StairBlock.f_56842_) == Half.TOP && (dir == facing_dir || shape == StairsShape.OUTER_LEFT && dir == facing_dir.m_122428_() || shape == StairsShape.OUTER_RIGHT && dir == facing_dir.m_122427_());
        }
        return facing_state.m_204336_(AFBlockTags.CHAIRS_TUCKABLE_UNDER);
    }

    public boolean isChairBlocking(BlockState state, Level level, BlockPos pos) {
        if (!level.m_45976_(SeatEntity.class, new AABB(pos)).isEmpty()) {
            return false;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockState left = level.m_8055_(pos.m_142300_(facing).m_142300_(facing.m_122428_()));
        BlockState right = level.m_8055_(pos.m_142300_(facing).m_142300_(facing.m_122427_()));
        if (left.m_60734_() instanceof ChairBlock && ((Boolean)left.m_61143_((Property)TUCKED)).booleanValue() && left.m_61143_((Property)FACING) == facing.m_122427_()) {
            return false;
        }
        return !(right.m_60734_() instanceof ChairBlock) || (Boolean)right.m_61143_((Property)TUCKED) == false || right.m_61143_((Property)FACING) != facing.m_122428_();
    }
}

