/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.BossSpawnHandler;
import com.brutalbosses.entity.IOnProjectileHit;
import com.brutalbosses.entity.ai.IAIParams;
import com.brutalbosses.entity.ai.SimpleRangedAttackGoal;
import com.brutalbosses.entity.thrownentity.ThrownItemEntity;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class ItemThrowAttackGoal
extends SimpleRangedAttackGoal {
    public static ResourceLocation ID = new ResourceLocation("brutalbosses:itemshootgoal");

    public ItemThrowAttackGoal(Mob mob, IAIParams params) {
        super(mob, params);
    }

    @Override
    protected ResourceLocation getID() {
        return ID;
    }

    @Override
    protected void doRangedAttack(Projectile Projectile2, LivingEntity target) {
        Projectile2.m_142687_(Entity.RemovalReason.DISCARDED);
        double xDiff = target.m_20185_() - this.mob.m_20185_();
        double yDiff = target.m_20227_(0.5) - (this.mob.m_20186_() + (double)this.mob.m_20192_() - 0.5);
        double zDiff = target.m_20189_() - this.mob.m_20189_();
        ThrownItemEntity pearlEntity = new ThrownItemEntity(this.mob.f_19853_, this.mob);
        pearlEntity.m_6034_(this.mob.m_20185_(), this.mob.m_20186_() + (double)this.mob.m_20192_() - 0.5, this.mob.m_20189_());
        pearlEntity.m_6686_(xDiff, yDiff, zDiff, 0.8f * this.params.speed, 3.0f);
        pearlEntity.m_37446_(((ItemThrowParams)this.params).item);
        pearlEntity.m_20242_(true);
        if (pearlEntity instanceof IOnProjectileHit) {
            ((IOnProjectileHit)((Object)pearlEntity)).setMaxLifeTime(this.mob.f_19853_.m_46467_() + 400L);
            ((IOnProjectileHit)((Object)pearlEntity)).setOnHitAction(rayTraceResult -> {
                if (!this.mob.m_6084_()) {
                    return;
                }
                if (rayTraceResult instanceof EntityHitResult) {
                    Entity hitEntity = ((EntityHitResult)rayTraceResult).m_82443_();
                    if (hitEntity instanceof LivingEntity && hitEntity != this.mob) {
                        if (((ItemThrowParams)this.params).damage > 0.0f) {
                            hitEntity.m_6469_(DamageSource.m_19367_((Entity)hitEntity, (Entity)this.mob), ((ItemThrowParams)this.params).damage);
                        }
                        if (((ItemThrowParams)this.params).lighting) {
                            LightningBolt lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(hitEntity.f_19853_);
                            lightningboltentity.m_6027_(hitEntity.m_20185_(), hitEntity.m_20186_(), hitEntity.m_20189_());
                            lightningboltentity.m_20874_(false);
                            this.mob.f_19853_.m_7967_((Entity)lightningboltentity);
                        }
                        if (((ItemThrowParams)this.params).explode) {
                            hitEntity.f_19853_.m_7703_(null, DamageSource.m_19340_((Entity)((LivingEntity)hitEntity), (LivingEntity)this.mob), null, hitEntity.m_20185_(), hitEntity.m_20186_(), hitEntity.m_20189_(), (float)(1.0 * (Double)BrutalBosses.config.getCommonConfig().globalDifficultyMultiplier.get()) * pearlEntity.getScale(), false, Explosion.BlockInteraction.BREAK);
                        }
                        if (((ItemThrowParams)this.params).teleport) {
                            double d0 = -Mth.m_14031_((float)(this.mob.m_146908_() * ((float)Math.PI / 180)));
                            double d1 = Mth.m_14089_((float)(this.mob.m_146908_() * ((float)Math.PI / 180)));
                            if (this.mob.f_19853_ instanceof ServerLevel) {
                                ((ServerLevel)this.mob.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123760_, this.mob.m_20185_() + d0, this.mob.m_20227_(0.5), this.mob.m_20189_() + d1, 20, d0, 0.0, d1, 0.0);
                            }
                            this.mob.f_19853_.m_6263_((Player)null, this.mob.f_19854_, this.mob.f_19855_, this.mob.f_19856_, SoundEvents.f_11852_, this.mob.m_5720_(), 1.0f, 1.0f);
                            this.mob.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                            this.mob.m_6021_(pearlEntity.m_20185_(), hitEntity.m_20186_(), pearlEntity.m_20189_());
                        }
                    }
                } else if (rayTraceResult instanceof BlockHitResult) {
                    BlockPos tpPos;
                    BlockPos hitPos = ((BlockHitResult)rayTraceResult).m_82425_();
                    if (((ItemThrowParams)this.params).lighting) {
                        LightningBolt lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(this.mob.f_19853_);
                        lightningboltentity.m_6027_((double)hitPos.m_123341_(), (double)hitPos.m_123342_(), (double)hitPos.m_123343_());
                        lightningboltentity.m_20874_(false);
                        this.mob.f_19853_.m_7967_((Entity)lightningboltentity);
                    }
                    if (((ItemThrowParams)this.params).explode) {
                        this.mob.f_19853_.m_7703_(null, DamageSource.m_19340_((Entity)this.mob, (LivingEntity)this.mob), null, (double)hitPos.m_123341_(), (double)hitPos.m_123342_(), (double)hitPos.m_123343_(), (float)(1.0 * (Double)BrutalBosses.config.getCommonConfig().globalDifficultyMultiplier.get()), false, Explosion.BlockInteraction.NONE);
                    }
                    if (((ItemThrowParams)this.params).teleport && (tpPos = BossSpawnHandler.findSpawnPosForBoss((BlockGetter)((ServerLevelAccessor)this.mob.f_19853_), (Entity)this.mob, hitPos)) != null) {
                        double d0 = -Mth.m_14031_((float)(this.mob.m_146908_() * ((float)Math.PI / 180)));
                        double d1 = Mth.m_14089_((float)(this.mob.m_146908_() * ((float)Math.PI / 180)));
                        if (this.mob.f_19853_ instanceof ServerLevel) {
                            ((ServerLevel)this.mob.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123760_, this.mob.m_20185_() + d0, this.mob.m_20227_(0.5), this.mob.m_20189_() + d1, 20, d0, 0.0, d1, 0.0);
                        }
                        this.mob.f_19853_.m_6263_((Player)null, this.mob.f_19854_, this.mob.f_19855_, this.mob.f_19856_, SoundEvents.f_11852_, this.mob.m_5720_(), 1.0f, 1.0f);
                        this.mob.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                        this.mob.m_6021_((double)tpPos.m_123341_(), (double)tpPos.m_123342_(), (double)tpPos.m_123343_());
                    }
                }
            });
        }
        this.mob.f_19853_.m_7967_((Entity)pearlEntity);
    }

    @Override
    protected Projectile createProjectile() {
        ThrownItemEntity pearlEntity = new ThrownItemEntity(this.mob.f_19853_, this.mob);
        pearlEntity.m_37446_(((ItemThrowParams)this.params).item);
        pearlEntity.setScale(((ItemThrowParams)this.params).projectilesize);
        return pearlEntity;
    }

    public static class ItemThrowParams
    extends SimpleRangedAttackGoal.RangedParams {
        private ItemStack item = Items.f_42584_.m_7968_();
        private float damage = 0.0f;
        private boolean teleport = false;
        private boolean lighting = false;
        private boolean explode = false;
        private float projectilesize = 1.0f;
        private static final String ITEM = "item";
        private static final String DAMAGE = "damage";
        private static final String TELEPORT = "teleport";
        private static final String LIGHTNING = "lightning";
        private static final String EXPLODE = "explode";
        private static final String PR_SIZE = "projectilesize";

        public ItemThrowParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(ITEM)) {
                try {
                    this.item = ItemStack.m_41712_((CompoundTag)TagParser.m_129359_((String)jsonElement.get(ITEM).getAsString()));
                }
                catch (CommandSyntaxException e) {
                    BrutalBosses.LOGGER.warn("Could not parse item of: " + jsonElement.get(ITEM).getAsString(), (Throwable)e);
                }
            }
            if (jsonElement.has(DAMAGE)) {
                this.damage = jsonElement.get(DAMAGE).getAsFloat();
            }
            if (jsonElement.has(TELEPORT)) {
                this.teleport = jsonElement.get(TELEPORT).getAsBoolean();
            }
            if (jsonElement.has(LIGHTNING)) {
                this.lighting = jsonElement.get(LIGHTNING).getAsBoolean();
            }
            if (jsonElement.has(EXPLODE)) {
                this.explode = jsonElement.get(EXPLODE).getAsBoolean();
            }
            if (jsonElement.has(PR_SIZE)) {
                this.projectilesize = jsonElement.get(PR_SIZE).getAsFloat();
            }
            return this;
        }
    }
}

