/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.data;

import info.u_team.u_team_core.data.CommonProvider;
import info.u_team.u_team_core.data.GenerationData;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import net.minecraft.data.HashCache;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public abstract class CommonLanguagesProvider
extends CommonProvider {
    protected final Map<String, Map<String, String>> data = new HashMap<String, Map<String, String>>();

    public CommonLanguagesProvider(GenerationData data) {
        super(data);
    }

    public void m_6865_(HashCache cache) throws IOException {
        this.addTranslations();
        this.data.forEach((locale, map) -> {
            if (!map.isEmpty()) {
                try {
                    CommonLanguagesProvider.write(cache, GSON.toJsonTree(map), this.resolveModAssets().resolve("lang").resolve(locale + ".json"));
                }
                catch (IOException ex) {
                    LOGGER.error(this.marker, "Could not write data.", (Throwable)ex);
                }
            }
        });
    }

    public abstract void addTranslations();

    public String m_6055_() {
        return "Languages";
    }

    protected void add(CreativeModeTab key, String name) {
        Component component = key.m_40786_();
        if (component instanceof TranslatableComponent) {
            this.add(((TranslatableComponent)component).m_131328_(), name);
        }
    }

    protected void addBlock(Supplier<? extends Block> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(Block key, String name) {
        this.add(key.m_7705_(), name);
    }

    protected void addItem(Supplier<? extends Item> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(Item key, String name) {
        this.add(key.m_5524_(), name);
    }

    protected void addItemStack(Supplier<? extends ItemStack> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(ItemStack key, String name) {
        this.add(key.m_41778_(), name);
    }

    protected void addEnchantment(Supplier<? extends Enchantment> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(Enchantment key, String name) {
        this.add(key.m_44704_(), name);
    }

    protected void addEffect(Supplier<? extends MobEffect> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(MobEffect key, String name) {
        this.add(key.m_19481_(), name);
    }

    protected void addEntityType(Supplier<? extends EntityType<?>> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(EntityType<?> key, String name) {
        this.add(key.m_20675_(), name);
    }

    protected void add(Supplier<? extends Fluid> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(Fluid key, String name) {
        this.add(key.getAttributes().getTranslationKey(), name);
    }

    protected void add(String key, String value) {
        this.add("en_us", key, value);
    }

    protected void add(String locale, CreativeModeTab key, String name) {
        Component component = key.m_40786_();
        if (component instanceof TranslatableComponent) {
            this.add(locale, ((TranslatableComponent)component).m_131328_(), name);
        }
    }

    protected void addBlock(String locale, Supplier<? extends Block> key, String name) {
        this.add(locale, key.get(), name);
    }

    protected void add(String locale, Block key, String name) {
        this.add(locale, key.m_7705_(), name);
    }

    protected void addItem(String locale, Supplier<? extends Item> key, String name) {
        this.add(locale, key.get(), name);
    }

    protected void add(String locale, Item key, String name) {
        this.add(locale, key.m_5524_(), name);
    }

    protected void addItemStack(String locale, Supplier<? extends ItemStack> key, String name) {
        this.add(locale, key.get(), name);
    }

    protected void add(String locale, ItemStack key, String name) {
        this.add(locale, key.m_41778_(), name);
    }

    protected void addEnchantment(String locale, Supplier<? extends Enchantment> key, String name) {
        this.add(locale, key.get(), name);
    }

    protected void add(String locale, Enchantment key, String name) {
        this.add(locale, key.m_44704_(), name);
    }

    protected void addEffect(String locale, Supplier<? extends MobEffect> key, String name) {
        this.add(locale, key.get(), name);
    }

    protected void add(String locale, MobEffect key, String name) {
        this.add(locale, key.m_19481_(), name);
    }

    protected void addEntityType(String locale, Supplier<? extends EntityType<?>> key, String name) {
        this.add(locale, key.get(), name);
    }

    protected void add(String locale, EntityType<?> key, String name) {
        this.add(locale, key.m_20675_(), name);
    }

    protected void addFluid(String locale, Supplier<? extends Fluid> key, String name) {
        this.add(locale, key.get(), name);
    }

    protected void add(String locale, Fluid key, String name) {
        this.add(locale, key.getAttributes().getTranslationKey(), name);
    }

    protected void add(String locale, String key, String value) {
        Map map = this.data.computeIfAbsent(locale, unused -> new TreeMap());
        if (map.put(key, value) != null) {
            throw new IllegalStateException("Duplicate translation key " + key);
        }
    }

    protected void addBlockTooltip(Supplier<? extends Block> key, String category, int line, String value) {
        this.addItemTooltip(() -> ((Block)key.get()).m_5456_(), category, line, value);
    }

    protected void addBlockTooltip(String locale, Supplier<? extends Block> key, String category, int line, String value) {
        this.addItemTooltip(locale, () -> ((Block)key.get()).m_5456_(), category, line, value);
    }

    protected void addItemTooltip(Supplier<? extends Item> key, String category, int line, String value) {
        if (!((String)category).isEmpty()) {
            category = (String)category + ".";
        }
        this.add(key.get().m_5524_() + ".tooltip." + (String)category + line, value);
    }

    protected void addItemTooltip(String locale, Supplier<? extends Item> key, String category, int line, String value) {
        if (!((String)category).isEmpty()) {
            category = (String)category + ".";
        }
        this.add(locale, key.get().m_5524_() + ".tooltip." + (String)category + line, value);
    }

    protected void addTooltip(String key, String category, int line, String value) {
        if (!((String)category).isEmpty()) {
            category = (String)category + ".";
        }
        this.add("general." + this.modid + "." + key + ".tooltip." + (String)category + line, value);
    }

    protected void addTooltip(String locale, String key, String category, int line, String value) {
        if (!((String)category).isEmpty()) {
            category = (String)category + ".";
        }
        this.add(locale, "general." + this.modid + "." + key + ".tooltip." + (String)category + line, value);
    }
}

