/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.data;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import info.u_team.u_team_core.data.CommonProvider;
import info.u_team.u_team_core.data.GenerationData;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.data.HashCache;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.data.ExistingFileHelper;

public abstract class CommonTagsProvider<T>
extends CommonProvider {
    protected final Registry<T> registry;
    protected final Map<ResourceLocation, Tag.Builder> tagToBuilder;
    protected final ExistingFileHelper.IResourceType resourceType;

    public CommonTagsProvider(GenerationData data, Registry<T> registry) {
        super(data);
        this.registry = registry;
        this.tagToBuilder = Maps.newLinkedHashMap();
        this.resourceType = new ExistingFileHelper.ResourceType(PackType.SERVER_DATA, ".json", "tags/" + this.getTagFolder());
    }

    protected abstract void registerTags();

    public void m_6865_(HashCache cache) {
        this.tagToBuilder.clear();
        this.registerTags();
        this.tagToBuilder.forEach((location, builder) -> {
            List list = builder.m_13330_().filter(builderEntry -> !builderEntry.f_13338_().m_142746_(id -> this.tagToBuilder.containsKey(id), id -> this.registry.m_6612_(id).isPresent())).filter(this::missing).collect(Collectors.toList());
            if (!list.isEmpty()) {
                throw new IllegalArgumentException(String.format("Couldn't define tag %s as it is missing following references: %s", location, list.stream().map(Objects::toString).collect(Collectors.joining(","))));
            }
            JsonObject object = builder.m_13334_();
            Path path = this.makePath((ResourceLocation)location);
            try {
                CommonTagsProvider.write(cache, (JsonElement)object, path);
            }
            catch (IOException ex) {
                LOGGER.error(this.marker, "Could not write data.", (Throwable)ex);
            }
        });
    }

    private boolean missing(Tag.BuilderEntry proxy) {
        Tag.Entry entry = proxy.f_13338_();
        if (entry instanceof Tag.TagEntry) {
            return !this.data.getExistingFileHelper().exists(((Tag.TagEntry)entry).f_13383_, this.resourceType);
        }
        return false;
    }

    protected abstract String getTagFolder();

    protected Path makePath(ResourceLocation location) {
        return this.resolveData(location).resolve("tags").resolve(this.getTagFolder()).resolve(location.m_135815_() + ".json");
    }

    protected BetterBuilder<T> getBuilder(TagKey<T> tag) {
        Tag.Builder tagBuilder = this.getTagBuilder(tag);
        return new BetterBuilder<T>(tagBuilder, this.registry, this.modid);
    }

    protected Tag.Builder getTagBuilder(TagKey<T> tag) {
        return this.tagToBuilder.computeIfAbsent(tag.f_203868_(), location -> {
            this.data.getExistingFileHelper().trackGenerated(location, this.resourceType);
            return new UniqueBuilder();
        });
    }

    public static class BetterBuilder<T> {
        private final Registry<T> registry;
        private final TagsProvider.TagAppender<T> internalBuilder;

        public BetterBuilder(Tag.Builder builder, Registry<T> registry, String id) {
            this.registry = registry;
            this.internalBuilder = new TagsProvider.TagAppender(builder, registry, id);
        }

        @SafeVarargs
        public final BetterBuilder<T> add(T ... values) {
            this.internalBuilder.m_126584_((Object[])values);
            return this;
        }

        @SafeVarargs
        public final BetterBuilder<T> add(TagKey<T> ... values) {
            this.internalBuilder.addTags(values);
            return this;
        }

        @SafeVarargs
        public final BetterBuilder<T> addOptional(T ... values) {
            Stream.of(values).map(arg_0 -> this.registry.m_7981_(arg_0)).forEach(arg_0 -> this.internalBuilder.m_176839_(arg_0));
            return this;
        }

        @SafeVarargs
        public final BetterBuilder<T> addOptional(TagKey<T> ... values) {
            Stream.of(values).map(TagKey::f_203868_).forEach(arg_0 -> this.internalBuilder.m_176841_(arg_0));
            return this;
        }

        public BetterBuilder<T> add(T value) {
            this.internalBuilder.m_126582_(value);
            return this;
        }

        public BetterBuilder<T> add(TagKey<T> value) {
            this.internalBuilder.m_206428_(value);
            return this;
        }

        public BetterBuilder<T> addOptional(ResourceLocation location) {
            this.internalBuilder.m_176839_(location);
            return this;
        }

        public BetterBuilder<T> addOptionalTag(ResourceLocation location) {
            this.internalBuilder.m_176841_(location);
            return this;
        }
    }

    private static class UniqueBuilder
    extends Tag.Builder {
        private UniqueBuilder() {
        }

        public Tag.Builder m_13305_(Tag.BuilderEntry proxyTag) {
            ResourceLocation identifier = this.getIdentifier(proxyTag.f_13338_());
            boolean duplicate = this.m_13330_().map(Tag.BuilderEntry::f_13338_).anyMatch(entry -> this.getIdentifier((Tag.Entry)entry).equals((Object)identifier));
            if (!duplicate) {
                return super.m_13305_(proxyTag);
            }
            return this;
        }

        private ResourceLocation getIdentifier(Tag.Entry entry) {
            ResourceLocation identifier;
            if (entry instanceof Tag.ElementEntry) {
                Tag.ElementEntry elementEntry = (Tag.ElementEntry)entry;
                identifier = elementEntry.f_13349_;
            } else if (entry instanceof Tag.OptionalElementEntry) {
                Tag.OptionalElementEntry optionalEntry = (Tag.OptionalElementEntry)entry;
                identifier = optionalEntry.f_13363_;
            } else if (entry instanceof Tag.TagEntry) {
                Tag.TagEntry tagEntry = (Tag.TagEntry)entry;
                identifier = tagEntry.f_13383_;
            } else if (entry instanceof Tag.OptionalTagEntry) {
                Tag.OptionalTagEntry optionalTagEntry = (Tag.OptionalTagEntry)entry;
                identifier = optionalTagEntry.f_13373_;
            } else {
                throw new IllegalArgumentException("Unknown implementation of ITagEntry");
            }
            return identifier;
        }
    }
}

