/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.mehvahdjukaar.selene.math.MthUtils;
import net.mehvahdjukaar.supplementaries.client.particles.ParticleUtil;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BellowsBlock;
import net.mehvahdjukaar.supplementaries.common.utils.CommonUtil;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.mehvahdjukaar.supplementaries.setup.ModSounds;
import net.mehvahdjukaar.supplementaries.setup.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChangeOverTimeBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.WetSpongeBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BellowsBlockTile
extends BlockEntity {
    public float height = 0.0f;
    public float prevHeight = 0.0f;
    private long startTime = 0L;
    public boolean isPressed = false;
    private boolean lastBlowing = false;

    public BellowsBlockTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.BELLOWS_TILE.get(), pos, state);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_);
    }

    private AABB getHalfBoundingBox(Direction dir) {
        return new AABB(this.f_58858_).m_82310_(-0.5 * (double)dir.m_122429_(), -0.5 * (double)dir.m_122430_(), -0.5 * (double)dir.m_122431_());
    }

    private void moveCollidedEntities(Level level) {
        Direction dir = this.getDirection().m_122434_() == Direction.Axis.Y ? Direction.SOUTH : Direction.UP;
        for (int j = 0; j < 2; ++j) {
            AABB halfBoundingBox = this.getHalfBoundingBox(dir);
            List list = level.m_45933_(null, halfBoundingBox);
            if (!list.isEmpty()) {
                block7: for (Entity entity2 : list) {
                    if (entity2.m_7752_() == PushReaction.IGNORE) continue;
                    AABB entityBB = entity2.m_142469_();
                    double dy = 0.0;
                    double dz = 0.0;
                    float f = this.height + 0.01f;
                    switch (dir) {
                        case SOUTH: {
                            dz = halfBoundingBox.f_82293_ + (double)f - entityBB.f_82290_;
                            if (!(dz < 0.0)) break;
                            continue block7;
                        }
                        case NORTH: {
                            dz = halfBoundingBox.f_82290_ - (double)f - entityBB.f_82293_;
                            if (!(dz > 0.0)) break;
                            continue block7;
                        }
                        case UP: {
                            dy = halfBoundingBox.f_82292_ + (double)f - entityBB.f_82289_;
                            if (!(dy < 0.0)) break;
                            continue block7;
                        }
                        case DOWN: {
                            dy = halfBoundingBox.f_82289_ - (double)f - entityBB.f_82292_;
                            if (!(dy > 0.0)) break;
                            continue block7;
                        }
                    }
                    entity2.m_6478_(MoverType.SHULKER_BOX, new Vec3(0.0, dy, dz));
                }
            }
            dir = dir.m_122424_();
        }
    }

    private void pushEntities(Direction facing, float period, float range, Level level) {
        double velocity = ServerConfigs.cached.BELLOWS_BASE_VEL_SCALING / (double)period;
        double maxVelocity = ServerConfigs.cached.BELLOWS_MAX_VEL;
        AABB facingBox = CommonUtil.getDirectionBB(this.f_58858_, facing, (int)range);
        List list = level.m_45976_(Entity.class, facingBox);
        block7: for (Entity entity2 : list) {
            if (!this.inLineOfSight(entity2, facing, level)) continue;
            if (facing == Direction.UP) {
                maxVelocity *= 0.5;
            }
            AABB entityBB = entity2.m_142469_();
            velocity *= ((double)range - (switch (facing) {
                default -> {
                    double b = this.f_58858_.m_123343_() + 1;
                    if (entityBB.f_82290_ < b) continue block7;
                    yield entity2.m_20189_() - b;
                }
                case Direction.NORTH -> {
                    double b = this.f_58858_.m_123343_();
                    if (entityBB.f_82293_ > b) continue block7;
                    yield b - entity2.m_20189_();
                }
                case Direction.EAST -> {
                    double b = this.f_58858_.m_123341_() + 1;
                    if (entityBB.f_82288_ < b) continue block7;
                    yield entity2.m_20185_() - b;
                }
                case Direction.WEST -> {
                    double b = this.f_58858_.m_123341_();
                    if (entityBB.f_82291_ > b) continue block7;
                    yield b - entity2.m_20185_();
                }
                case Direction.UP -> {
                    double b = this.f_58858_.m_123342_() + 1;
                    if (entityBB.f_82289_ < b) continue block7;
                    yield entity2.m_20186_() - b;
                }
                case Direction.DOWN -> {
                    double b = this.f_58858_.m_123342_();
                    if (entityBB.f_82292_ > b) continue block7;
                    yield b - entity2.m_20186_();
                }
            })) / (double)range;
            if (!(Math.abs(entity2.m_20184_().m_82507_(facing.m_122434_())) < maxVelocity)) continue;
            entity2.m_20256_(entity2.m_20184_().m_82520_((double)facing.m_122429_() * velocity, (double)facing.m_122430_() * velocity, (double)facing.m_122431_() * velocity));
            if (!ServerConfigs.cached.BELLOWS_FLAG) continue;
            entity2.f_19864_ = true;
        }
    }

    private void blowParticles(float air, Direction facing, Level level, boolean waterInFront) {
        if (level.f_46441_.nextFloat() < air) {
            BlockPos facingPos;
            AirType type = AirType.BUBBLE;
            BlockPos frontPos = facingPos = this.f_58858_.m_142300_(facing);
            boolean hasSponge = false;
            if (!waterInFront) {
                BlockState frontState = level.m_8055_(facingPos);
                if (frontState.m_60734_() instanceof WetSpongeBlock) {
                    hasSponge = true;
                    frontPos = frontPos.m_142300_(facing);
                }
                type = AirType.AIR;
            }
            if (!Block.m_49863_((LevelReader)level, (BlockPos)frontPos, (Direction)facing.m_122424_())) {
                BlockPos p = this.f_58858_;
                if (hasSponge) {
                    EnumSet<Direction> directions = EnumSet.allOf(Direction.class);
                    directions.remove(facing.m_122424_());
                    directions.remove(facing);
                    for (Direction d : directions) {
                        if (!level.m_8055_(facingPos.m_142300_(d)).m_60713_((Block)ModRegistry.SOAP_BLOCK.get())) continue;
                        type = AirType.SOAP;
                        p = facingPos;
                        break;
                    }
                    if (type != AirType.SOAP) {
                        return;
                    }
                }
                this.spawnParticle(level, p, facing, type);
            }
        }
    }

    private <T extends BlockEntity> void tickFurnaces(BlockPos frontPos, BlockState frontState, Level level, T tile) {
        BlockEntityTicker ticker;
        if (tile != null && (ticker = frontState.m_155944_(level, tile.m_58903_())) != null) {
            ticker.m_155252_(level, frontPos, frontState, tile);
        }
    }

    private void tickFurnaces(BlockPos pos, Level level) {
        BlockState state = level.m_8055_(pos);
        if (state.m_204336_(ModTags.BELLOWS_TICKABLE_TAG)) {
            BlockEntity te = level.m_7702_(pos);
            this.tickFurnaces(pos, state, level, te);
        } else if (state instanceof ChangeOverTimeBlock && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            state.m_60735_(serverLevel, pos, level.f_46441_);
        }
    }

    private void refreshFire(int n, Direction facing, BlockPos frontPos, Level level) {
        for (int i = 0; i < n; ++i) {
            int age;
            BlockState fb = level.m_8055_(frontPos);
            if (fb.m_60734_() instanceof FireBlock && (age = ((Integer)fb.m_61143_((Property)FireBlock.f_53408_)).intValue()) != 0) {
                level.m_7731_(frontPos, (BlockState)fb.m_61124_((Property)FireBlock.f_53408_, (Comparable)Integer.valueOf(Mth.m_14045_((int)(age - 7), (int)0, (int)15))), 4);
            }
            frontPos = frontPos.m_142300_(facing);
        }
    }

    private float getPeriodForPower(int power) {
        return (float)ServerConfigs.cached.BELLOWS_BASE_PERIOD - (float)(power - 1) * (float)ServerConfigs.cached.BELLOWS_POWER_SCALING;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BellowsBlockTile tile) {
        int power = (Integer)state.m_61143_((Property)BellowsBlock.POWER);
        tile.prevHeight = tile.height;
        if (power != 0 && (tile.startTime != 0L || tile.height == 0.0f)) {
            boolean blowing;
            long time = level.m_46467_();
            if (tile.startTime == 0L) {
                tile.startTime = time;
            }
            float period = tile.getPeriodForPower(power);
            float arg = (float)Math.PI * 2 * ((float)(time - tile.startTime) / period % 1.0f);
            float sin = Mth.m_14031_((float)arg);
            float cos = Mth.m_14089_((float)arg);
            float dh = 0.0625f;
            tile.height = 0.0625f * cos - 0.0625f;
            tile.pushAir(level, pos, state, power, time, period, sin);
            boolean bl = blowing = Mth.m_14031_((float)(arg - 0.8f)) > 0.0f;
            if (tile.lastBlowing != blowing) {
                level.m_5594_(null, pos, blowing ? (SoundEvent)ModSounds.BELLOWS_BLOW.get() : (SoundEvent)ModSounds.BELLOWS_RETRACT.get(), SoundSource.BLOCKS, 0.1f, MthUtils.nextWeighted((Random)level.f_46441_, (float)0.1f) + 0.85f + 0.6f * (float)power / 15.0f);
            }
            tile.lastBlowing = blowing;
        } else if (tile.isPressed) {
            float minH = -0.125f;
            tile.height = Math.max(tile.height - 0.01f, minH);
            if (tile.height > minH) {
                long time = level.m_46467_();
                int p = 7;
                float period = tile.getPeriodForPower(p);
                tile.pushAir(level, pos, state, power, time, period, 0.8f);
            }
        } else {
            tile.startTime = 0L;
            if (tile.height < 0.0f) {
                tile.height = Math.min(tile.height + 0.01f, 0.0f);
            }
        }
        if (tile.prevHeight != 0.0f && tile.height != 0.0f) {
            tile.moveCollidedEntities(level);
        }
        tile.isPressed = false;
    }

    private void pushAir(Level level, BlockPos pos, BlockState state, int power, long time, float period, float airIntensity) {
        Direction facing = (Direction)state.m_61143_((Property)BellowsBlock.FACING);
        BlockPos frontPos = pos.m_142300_(facing);
        FluidState fluid = level.m_6425_(frontPos);
        if (level.f_46443_) {
            this.blowParticles(airIntensity, facing, level, fluid.m_76152_().m_205067_(FluidTags.f_13131_));
        } else if (fluid.m_76178_()) {
            float range = ServerConfigs.cached.BELLOWS_RANGE;
            if (airIntensity > 0.0f) {
                this.pushEntities(facing, period, range, level);
            }
            if (time % (long)(10 - power / 2) == 0L) {
                this.tickFurnaces(frontPos, level);
            }
            int n = 0;
            int a = 0;
            while ((float)a <= range) {
                if (time % (15L * (long)(a + 1)) != 0L) {
                    n = a;
                    break;
                }
                ++a;
            }
            this.refreshFire(n, facing, frontPos, level);
        }
    }

    public boolean inLineOfSight(Entity entity2, Direction facing, Level level) {
        int x = facing.m_122429_() * (Mth.m_14107_((double)entity2.m_20185_()) - this.f_58858_.m_123341_());
        int y = facing.m_122430_() * (Mth.m_14107_((double)entity2.m_20186_()) - this.f_58858_.m_123342_());
        int z = facing.m_122431_() * (Mth.m_14107_((double)entity2.m_20189_()) - this.f_58858_.m_123343_());
        boolean flag = true;
        for (int i = 1; i < Math.abs(x + y + z); ++i) {
            if (!Block.m_49863_((LevelReader)level, (BlockPos)this.f_58858_.m_5484_(facing, i), (Direction)facing.m_122424_())) continue;
            flag = false;
        }
        return flag;
    }

    public void spawnParticle(Level world, BlockPos pos, Direction dir, AirType airType) {
        if (airType == AirType.SOAP) {
            for (int m = 0; m < 1 + world.f_46441_.nextInt(3); ++m) {
                ParticleUtil.spawnParticleOnFace(world, pos, dir, (ParticleOptions)ModRegistry.SUDS_PARTICLE.get(), 0.3f, 0.5f, true);
            }
        } else {
            double xo = dir.m_122429_();
            double yo = dir.m_122430_();
            double zo = dir.m_122431_();
            double x = xo * 0.5 + (double)pos.m_123341_() + 0.5 + ((double)world.f_46441_.nextFloat() - 0.5) / 3.0;
            double y = yo * 0.5 + (double)pos.m_123342_() + 0.5 + ((double)world.f_46441_.nextFloat() - 0.5) / 3.0;
            double z = zo * 0.5 + (double)pos.m_123343_() + 0.5 + ((double)world.f_46441_.nextFloat() - 0.5) / 3.0;
            double vel = 0.125f + world.f_46441_.nextFloat() * 0.2f;
            double velX = xo * vel;
            double velY = yo * vel;
            double velZ = zo * vel;
            if (airType == AirType.BUBBLE) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123795_, x, y, z, velX * 0.8, velY * 0.8, velZ * 0.8);
            } else {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, velX, velY, velZ);
            }
        }
    }

    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)BellowsBlock.FACING);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.startTime = compound.m_128454_("Offset");
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128356_("Offset", this.startTime);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onSteppedOn(Entity entityIn) {
        if (this.isPressed) {
            return;
        }
        double b = entityIn.m_142469_().m_82309_();
        if (b > 0.8 && ((Direction)this.m_58900_().m_61143_((Property)BellowsBlock.FACING)).m_122434_() != Direction.Axis.Y) {
            this.isPressed = true;
        }
    }

    private static enum AirType {
        AIR,
        BUBBLE,
        SOAP;

    }
}

