/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.Random;
import javax.annotation.Nonnull;
import net.mehvahdjukaar.selene.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.block.blocks.ClockBlock;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.mehvahdjukaar.supplementaries.setup.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ClockBlockTile
extends BlockEntity {
    public float roll = 0.0f;
    public float prevRoll = 0.0f;
    public float targetRoll = 0.0f;
    public float sRoll = 0.0f;
    public float sPrevRoll = 0.0f;
    public float sTargetRoll = 0.0f;
    public int power = 0;

    public ClockBlockTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.CLOCK_BLOCK_TILE.get(), pos, state);
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        this.prevRoll = this.roll = compound.m_128457_("MinRoll");
        this.targetRoll = this.roll;
        this.sPrevRoll = this.sRoll = compound.m_128457_("SecRoll");
        this.sTargetRoll = this.sRoll;
        this.power = compound.m_128451_("Power");
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128350_("MinRoll", this.targetRoll);
        tag.m_128350_("SecRoll", this.sTargetRoll);
        tag.m_128405_("Power", this.power);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void updateInitialTime(Level level, BlockState state, BlockPos pos) {
        int time = (int)(level.m_46468_() % 24000L);
        this.updateTime(time, level, state, pos);
        this.roll = this.targetRoll;
        this.prevRoll = this.targetRoll;
        this.sRoll = this.sTargetRoll;
        this.sPrevRoll = this.sTargetRoll;
    }

    public void updateTime(int time, Level level, BlockState state, BlockPos pos) {
        if (level.m_6042_().m_63956_()) {
            int minute = Mth.m_14045_((int)(time % 1000 / 20), (int)0, (int)50);
            int hour = Mth.m_14045_((int)(time / 1000), (int)0, (int)24);
            if (!level.f_46443_) {
                int p;
                if (hour != (Integer)state.m_61143_((Property)ClockBlock.HOUR)) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)ClockBlock.HOUR, (Comparable)Integer.valueOf(hour)), 3);
                }
                if ((p = Mth.m_14045_((int)(time / 1500), (int)0, (int)15)) != this.power) {
                    this.power = p;
                    level.m_46717_(pos, this.m_58900_().m_60734_());
                }
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)(minute % 2 == 0 ? ModSounds.CLOCK_TICK_1 : ModSounds.CLOCK_TICK_2).get(), SoundSource.BLOCKS, 0.08f, MthUtils.nextWeighted((Random)level.f_46441_, (float)0.1f) + 0.95f);
            }
            this.targetRoll = hour * 30 % 360;
            this.sTargetRoll = ((float)minute * 7.2f + 180.0f) % 360.0f;
        } else {
            this.targetRoll = level.f_46441_.nextFloat() * 360.0f;
            this.sTargetRoll = level.f_46441_.nextFloat() * 360.0f;
        }
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, ClockBlockTile tile) {
        float r;
        int time;
        int dayTime = (int)(pLevel.m_46468_() % 24000L);
        int n = time = pLevel.m_46469_().m_46207_(GameRules.f_46140_) ? dayTime : (int)(pLevel.m_46467_() % 24000L);
        if (time % 20 == 0) {
            tile.updateTime(dayTime, pLevel, pState, pPos);
        }
        tile.prevRoll = tile.roll;
        if (tile.roll != tile.targetRoll) {
            r = (tile.roll + 8.0f) % 360.0f;
            if (r >= tile.targetRoll && r <= tile.targetRoll + 8.0f) {
                r = tile.targetRoll;
            }
            tile.roll = r;
        }
        tile.sPrevRoll = tile.sRoll;
        if (tile.sRoll != tile.sTargetRoll) {
            r = (tile.sRoll + 8.0f) % 360.0f;
            if (r >= tile.sTargetRoll && r <= tile.sTargetRoll + 8.0f) {
                r = tile.sTargetRoll;
            }
            tile.sRoll = r;
        }
    }

    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)ClockBlock.FACING);
    }
}

