/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.blocks.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.common.block.blocks.NoticeBoardBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.StatueBlock;
import net.mehvahdjukaar.supplementaries.common.utils.CommonUtil;
import net.mehvahdjukaar.supplementaries.common.utils.SpecialPlayers;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class StatueBlockTile
extends ItemDisplayTile {
    @Nullable
    public GameProfile owner = null;
    public StatuePose pose = StatuePose.STANDING;
    public boolean isWaving = false;
    public BlockState candle = null;

    public StatueBlockTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.STATUE_TILE.get(), pos, state);
    }

    public void m_58638_(Component name) {
        super.m_58638_(name);
        this.updateName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(@Nullable GameProfile input) {
        if (!(this.owner != null || input != null && input.isComplete() && input.getProperties().containsKey((Object)"textures"))) {
            StatueBlockTile statueBlockTile = this;
            synchronized (statueBlockTile) {
                this.owner = input;
            }
            SkullBlockEntity.m_155738_((GameProfile)this.owner, gameProfile -> {
                this.owner = gameProfile;
            });
        }
    }

    private void updateName() {
        if (this.m_8077_()) {
            String name = this.m_7770_().getString().toLowerCase(Locale.ROOT);
            Pair<UUID, String> profile = SpecialPlayers.STATUES.get(name);
            if (profile != null) {
                this.setOwner(new GameProfile((UUID)profile.getFirst(), (String)profile.getSecond()));
            }
        } else {
            this.owner = null;
        }
    }

    public void updateClientVisualsOnLoad() {
        this.updateName();
        ItemStack stack = this.getDisplayedItem();
        this.pose = StatuePose.getPose(stack);
        this.isWaving = (Boolean)this.m_58900_().m_61143_((Property)StatueBlock.POWERED);
        if (this.pose == StatuePose.CANDLE) {
            Block b = ((BlockItem)stack.m_41720_()).m_40614_();
            if (!(b instanceof CandleBlock)) {
                b = Blocks.f_152482_;
            }
            this.candle = (BlockState)b.m_49966_().m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(true));
        }
    }

    public void updateTileOnInventoryChanged() {
        boolean flag;
        boolean bl = flag = StatuePose.getPose(this.getDisplayedItem()) == StatuePose.CANDLE;
        if (flag != (Boolean)this.m_58900_().m_61143_((Property)StatueBlock.LIT)) {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)StatueBlock.LIT, (Comparable)Boolean.valueOf(flag)));
        }
    }

    public Component m_6820_() {
        return new TranslatableComponent("block.supplementaries.statuette");
    }

    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)NoticeBoardBlock.FACING);
    }

    public static enum StatuePose {
        STANDING,
        HOLDING,
        CANDLE,
        SWORD,
        TOOL,
        GLOBE,
        SEPIA_GLOBE;


        public static StatuePose getPose(ItemStack stack) {
            if (stack.m_41619_()) {
                return STANDING;
            }
            Item i = stack.m_41720_();
            if (CommonUtil.isSword(i)) {
                return SWORD;
            }
            if (CommonUtil.isTool(i)) {
                return TOOL;
            }
            if (i == ModRegistry.GLOBE_ITEM.get()) {
                return GLOBE;
            }
            if (i == ModRegistry.GLOBE_SEPIA_ITEM.get()) {
                return SEPIA_GLOBE;
            }
            return stack.m_204117_(ItemTags.f_144319_) ? CANDLE : HOLDING;
        }

        public boolean isGlobe() {
            return this == GLOBE || this == SEPIA_GLOBE;
        }
    }
}

