/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.setup;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.mehvahdjukaar.selene.block_set.BlockSetManager;
import net.mehvahdjukaar.selene.block_set.wood.WoodType;
import net.mehvahdjukaar.selene.items.WoodBasedBlockItem;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CeilingBannerBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FlagBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.HangingSignBlock;
import net.mehvahdjukaar.supplementaries.common.items.BlockPlacerItem;
import net.mehvahdjukaar.supplementaries.common.items.FlagItem;
import net.mehvahdjukaar.supplementaries.common.items.OptionalTagBlockItem;
import net.mehvahdjukaar.supplementaries.common.items.PresentItem;
import net.mehvahdjukaar.supplementaries.common.items.SignPostItem;
import net.mehvahdjukaar.supplementaries.configs.RegistryConfigs;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.mehvahdjukaar.supplementaries.setup.ModSounds;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;

public class RegistryHelper {
    public static void initDynamicRegistry() {
        BlockSetManager.addBlockSetRegistrationCallback(RegistryHelper::registerHangingSignBlocks, Block.class, WoodType.class);
        BlockSetManager.addBlockSetRegistrationCallback(RegistryHelper::registerHangingSignItems, Item.class, WoodType.class);
        BlockSetManager.addBlockSetRegistrationCallback(RegistryHelper::registerSignPostItems, Item.class, WoodType.class);
    }

    public static CreativeModeTab getTab(CreativeModeTab g, String regName) {
        if (RegistryConfigs.Reg.isEnabled(regName)) {
            return ModRegistry.MOD_TAB == null ? g : ModRegistry.MOD_TAB;
        }
        return null;
    }

    public static CreativeModeTab getTab(String modId, CreativeModeTab g, String regName) {
        return ModList.get().isLoaded(modId) ? RegistryHelper.getTab(g, regName) : null;
    }

    public static RegistryObject<Block> regPlaceableItem(String name, Supplier<? extends Block> sup, String itemLocation, ForgeConfigSpec.BooleanValue config) {
        Supplier<Item> itemSupp = () -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemLocation));
        return RegistryHelper.regPlaceableItem(name, sup, itemSupp, config);
    }

    public static RegistryObject<Block> regPlaceableItem(String name, Supplier<? extends Block> sup, Supplier<? extends Item> itemSupplier, ForgeConfigSpec.BooleanValue config) {
        Supplier<Block> newSupp = () -> {
            Block b = (Block)sup.get();
            BlockPlacerItem.registerPlaceableItem(b, itemSupplier, config);
            return b;
        };
        return ModRegistry.BLOCKS.register(name, newSupp);
    }

    public static RegistryObject<Item> regItem(String name, Supplier<? extends Item> sup) {
        return ModRegistry.ITEMS.register(name, sup);
    }

    public static RegistryObject<Item> regBlockItem(RegistryObject<Block> blockSup, CreativeModeTab group) {
        return RegistryHelper.regItem(blockSup.getId().m_135815_(), () -> new BlockItem((Block)blockSup.get(), new Item.Properties().m_41491_(group)));
    }

    public static RegistryObject<Item> regBlockItem(RegistryObject<Block> blockSup, CreativeModeTab group, int burnTime) {
        return RegistryHelper.regItem(blockSup.getId().m_135815_(), () -> new WoodBasedBlockItem((Block)blockSup.get(), new Item.Properties().m_41491_(group), burnTime));
    }

    public static RegistryObject<Item> regBlockItem(RegistryObject<Block> blockSup, CreativeModeTab group, String tagKey) {
        return RegistryHelper.regItem(blockSup.getId().m_135815_(), () -> new OptionalTagBlockItem((Block)blockSup.get(), new Item.Properties().m_41491_(group), tagKey));
    }

    public static RegistryObject<SimpleParticleType> regParticle(String name) {
        return ModRegistry.PARTICLES.register(name, () -> new SimpleParticleType(true));
    }

    public static RegistryObject<SoundEvent> regSound(String name) {
        return ModRegistry.SOUNDS.register(name, () -> new SoundEvent(Supplementaries.res(name)));
    }

    public static <T extends Entity> RegistryObject<EntityType<T>> regEntity(String name, EntityType.Builder<T> builder) {
        return ModRegistry.ENTITIES.register(name, () -> builder.m_20712_(name));
    }

    public static Map<DyeColor, RegistryObject<Block>> makeFlagBlocks(String baseName) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (DyeColor color : DyeColor.values()) {
            String name = baseName + "_" + color.m_41065_();
            builder.put((Object)color, (Object)ModRegistry.BLOCKS.register(name, () -> new FlagBlock(color, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)color.m_41069_()).m_60978_(1.0f).m_60955_().m_60918_(SoundType.f_56736_))));
        }
        return builder.build();
    }

    public static Map<DyeColor, RegistryObject<Item>> makeFlagItems(String baseName) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Map.Entry<DyeColor, RegistryObject<Block>> entry : ModRegistry.FLAGS.entrySet()) {
            DyeColor color = entry.getKey();
            RegistryObject<Block> regObj = entry.getValue();
            builder.put((Object)color, (Object)ModRegistry.ITEMS.register(regObj.getId().m_135815_(), () -> new FlagItem((Block)regObj.get(), new Item.Properties().m_41487_(16).m_41491_(RegistryHelper.getTab(CreativeModeTab.f_40750_, baseName)))));
        }
        return builder.build();
    }

    public static Map<DyeColor, RegistryObject<Block>> makeCeilingBanners(String baseName) {
        LinkedHashMap<DyeColor, RegistryObject<Block>> map = new LinkedHashMap<DyeColor, RegistryObject<Block>>();
        for (DyeColor color : DyeColor.values()) {
            String name = baseName + "_" + color.m_41065_();
            map.put(color, RegistryHelper.regPlaceableItem(name, () -> new CeilingBannerBlock(color, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)color.m_41069_()).m_60978_(1.0f).m_60910_().m_60918_(SoundType.f_56736_).lootFrom(() -> BannerBlock.m_49014_((DyeColor)color))), color.m_41065_() + "_banner", ServerConfigs.tweaks.CEILING_BANNERS));
        }
        return map;
    }

    public static Map<DyeColor, RegistryObject<Block>> makePresents(String baseName, BiFunction<DyeColor, BlockBehaviour.Properties, Block> presentFactory) {
        LinkedHashMap<DyeColor, RegistryObject<Block>> map = new LinkedHashMap<DyeColor, RegistryObject<Block>>();
        for (DyeColor color : DyeColor.values()) {
            String name = baseName + "_" + color.m_41065_();
            map.put(color, (RegistryObject<Block>)ModRegistry.BLOCKS.register(name, () -> (Block)presentFactory.apply(color, BlockBehaviour.Properties.m_60944_((Material)Material.f_76272_, (MaterialColor)color.m_41069_()).m_60978_(1.0f).m_60918_(ModSounds.PRESENT))));
        }
        map.put(null, ModRegistry.BLOCKS.register(baseName, () -> (Block)presentFactory.apply(null, BlockBehaviour.Properties.m_60944_((Material)Material.f_76272_, (MaterialColor)MaterialColor.f_76411_).m_60978_(1.0f).m_60918_(ModSounds.PRESENT))));
        return map;
    }

    public static Map<DyeColor, RegistryObject<Item>> makePresentsItems(Map<DyeColor, RegistryObject<Block>> presents, String name, CreativeModeTab tab) {
        HashMap<DyeColor, RegistryObject<Item>> map = new HashMap<DyeColor, RegistryObject<Item>>();
        for (Map.Entry<DyeColor, RegistryObject<Block>> entry : presents.entrySet()) {
            DyeColor color = entry.getKey();
            RegistryObject<Block> regObj = entry.getValue();
            map.put(color, (RegistryObject<Item>)ModRegistry.ITEMS.register(regObj.getId().m_135815_(), () -> new PresentItem((Block)regObj.get(), new Item.Properties().m_41491_(RegistryHelper.getTab(tab, name)), map)));
        }
        return map;
    }

    private static void registerHangingSignBlocks(RegistryEvent.Register<Block> event, Collection<WoodType> woodTypes) {
        IForgeRegistry registry = event.getRegistry();
        for (WoodType wood : woodTypes) {
            String name = wood.getVariantId("hanging_sign");
            Block block2 = (Block)new HangingSignBlock(BlockBehaviour.Properties.m_60944_((Material)wood.material, (MaterialColor)wood.material.m_76339_()).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_().m_60910_(), wood).setRegistryName(Supplementaries.res(name));
            registry.register((IForgeRegistryEntry)block2);
            ModRegistry.HANGING_SIGNS.put(wood, (HangingSignBlock)block2);
        }
    }

    public static void registerHangingSignItems(RegistryEvent.Register<Item> event, Collection<WoodType> woodTypes) {
        IForgeRegistry registry = event.getRegistry();
        for (Map.Entry<WoodType, HangingSignBlock> entry : ModRegistry.HANGING_SIGNS.entrySet()) {
            WoodType wood = entry.getKey();
            Block block2 = (Block)entry.getValue();
            Item item2 = (Item)new WoodBasedBlockItem(block2, new Item.Properties().m_41487_(16).m_41491_(RegistryHelper.getTab(CreativeModeTab.f_40750_, "hanging_sign")), wood, 200).setRegistryName(block2.getRegistryName());
            registry.register((IForgeRegistryEntry)item2);
            ModRegistry.HANGING_SIGNS_ITEMS.put(wood, item2);
        }
    }

    public static void registerSignPostItems(RegistryEvent.Register<Item> event, Collection<WoodType> woodTypes) {
        IForgeRegistry registry = event.getRegistry();
        for (WoodType wood : woodTypes) {
            String name = wood.getVariantId("sign_post");
            Item item2 = (Item)new SignPostItem(new Item.Properties().m_41487_(16).m_41491_(RegistryHelper.getTab(CreativeModeTab.f_40750_, "sign_post")), wood).setRegistryName(Supplementaries.res(name));
            registry.register((IForgeRegistryEntry)item2);
            ModRegistry.SIGN_POST_ITEMS.put(wood, (SignPostItem)item2);
        }
    }
}

