/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enhancedfarming.compat.jei.piston;

import com.mrbysco.enhancedfarming.compat.jei.JEICompat;
import com.mrbysco.enhancedfarming.recipes.PistonRecipe;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;

public class PistonCategory<T extends PistonRecipe>
implements IRecipeCategory<PistonRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;

    public PistonCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(JEICompat.RECIPE_PISTON_JEI, 0, 0, 84, 62);
        this.icon = guiHelper.createDrawable(JEICompat.RECIPE_PISTON_ICON_JEI, 0, 0, 16, 16);
        this.localizedName = new TranslatableComponent("enhancedfarming.gui.jei.category.piston");
    }

    public RecipeType<PistonRecipe> getRecipeType() {
        return JEICompat.PISTON_TYPE;
    }

    public ResourceLocation getUid() {
        return JEICompat.PISTON;
    }

    public Class<? extends PistonRecipe> getRecipeClass() {
        return PistonRecipe.class;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PistonRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 0, 22).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 66, 22).addItemStack(recipe.m_8043_());
    }
}

