/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enhancedfarming.config;

import com.mrbysco.enhancedfarming.EnhancedFarming;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

public class FarmingConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        EnhancedFarming.LOGGER.debug("Loaded Enhanced Farming's config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        EnhancedFarming.LOGGER.fatal("Enhanced Farming's config just got changed on the file system!");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue hotBurnsPlayer;
        public final ForgeConfigSpec.IntValue hotTime;
        public final ForgeConfigSpec.BooleanValue rightClickFruitHarvest;
        public final ForgeConfigSpec.BooleanValue relocationAllowed;
        public final ForgeConfigSpec.IntValue treeDropChance;
        public final ForgeConfigSpec.BooleanValue bonemealGrow;
        public final ForgeConfigSpec.BooleanValue instantGrow;
        public final ForgeConfigSpec.BooleanValue cropToSeeds;
        public final ForgeConfigSpec.BooleanValue enableRake;
        public final ForgeConfigSpec.BooleanValue seedsFromGrass;
        public final ForgeConfigSpec.BooleanValue saplingsFromGrass;
        public final ForgeConfigSpec.BooleanValue generateAppleTree;
        public final ForgeConfigSpec.BooleanValue generateAvocadoTree;
        public final ForgeConfigSpec.BooleanValue generateBananaTree;
        public final ForgeConfigSpec.BooleanValue generateCherryTree;
        public final ForgeConfigSpec.BooleanValue generateLemonTree;
        public final ForgeConfigSpec.BooleanValue generateMangoTree;
        public final ForgeConfigSpec.BooleanValue generateOliveTree;
        public final ForgeConfigSpec.BooleanValue generateOrangeTree;
        public final ForgeConfigSpec.BooleanValue generatePearTree;
        public final ForgeConfigSpec.IntValue appleTreeRarity;
        public final ForgeConfigSpec.IntValue avocadoTreeRarity;
        public final ForgeConfigSpec.IntValue bananaTreeRarity;
        public final ForgeConfigSpec.IntValue cherryTreeRarity;
        public final ForgeConfigSpec.IntValue lemonTreeRarity;
        public final ForgeConfigSpec.IntValue mangoTreeRarity;
        public final ForgeConfigSpec.IntValue oliveTreeRarity;
        public final ForgeConfigSpec.IntValue orangeTreeRarity;
        public final ForgeConfigSpec.IntValue pearTreeRarity;
        public final ForgeConfigSpec.BooleanValue generateNetherFlower;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("General settings").push("general");
            this.hotBurnsPlayer = builder.comment("Makes it so if you hold hot drinks for too long that you begin taking fire damage [Default: false]").define("hotBurnsPlayer", false);
            this.hotTime = builder.comment("Amount of seconds before you start taking fire damage when 'hotBurnsPlayer' is enabled [Default: 15]").defineInRange("hotTime", 15, 1, Integer.MAX_VALUE);
            this.rightClickFruitHarvest = builder.comment("When enabled the fruity leaves have to be right-clicked to be harvested [Default: true]").define("rightClickFruitHarvest", true);
            this.relocationAllowed = builder.comment("When enabled makes you able to get fruit from leaves that were placed after shearing [Default: false]").define("relocationAllowed", false);
            this.treeDropChance = builder.comment("The chance in which fruit drop from tree when \"rightClickFruitHarvest\" isn't enabled (1 in X chance) [Default: 20]").defineInRange("treeDropChance", 20, 1, Integer.MAX_VALUE);
            this.bonemealGrow = builder.comment("When enabled allows the usage of bonemeal on the mods plants [Default: true]").define("bonemealGrow", true);
            this.instantGrow = builder.comment("When enabled allows instant-growth using bonemeal on the mods plants [Default: false]").define("instantGrow", false);
            this.cropToSeeds = builder.comment("Enables Crop to Seeds recipes [Default: true]").define("crop_to_seeds", true);
            this.enableRake = builder.comment("Enables rakes [Default: true]").define("enableRake", true);
            this.seedsFromGrass = builder.comment("When enabled makes seeds drop from grass [Default: false]").define("seedsFromGrass", false);
            this.saplingsFromGrass = builder.comment("When enabled makes seeds drop from grass [Default: false]").define("saplingsFromGrass", false);
            builder.pop();
            builder.comment("Tree settings").push("tree");
            this.generateAppleTree = builder.comment("Enable generation of Apple trees [Default: true]").define("generateAppleTree", true);
            this.generateAvocadoTree = builder.comment("Enable generation of Avocado trees [Default: true]").define("generateAvocadoTree", true);
            this.generateBananaTree = builder.comment("Enable generation of Banana trees [Default: true]").define("generateBananaTree", true);
            this.generateCherryTree = builder.comment("Enable generation of Cherry trees [Default: true]").define("generateCherryTree", true);
            this.generateLemonTree = builder.comment("Enable generation of Lemon trees [Default: true]").define("generateLemonTree", true);
            this.generateMangoTree = builder.comment("Enable generation of Mango trees [Default: true]").define("generateMangoTree", true);
            this.generateOliveTree = builder.comment("Enable generation of Olive trees [Default: true]").define("generateOliveTree", true);
            this.generateOrangeTree = builder.comment("Enable generation of Orange trees [Default: true]").define("generateOrangeTree", true);
            this.generatePearTree = builder.comment("Enable generation of Pear trees [Default: true]").define("generatePearTree", true);
            builder.pop();
            builder.comment("Tree Rarity").push("rarity");
            this.appleTreeRarity = builder.comment("Rarity of Apple Trees. Makes the tree generate 1 every X times (Requires restart for changes to effect) [Default: 4]").defineInRange("appleTreeRarity", 4, 1, Integer.MAX_VALUE);
            this.avocadoTreeRarity = builder.comment("Rarity of Avocado Trees. Makes the tree generate 1 every X times (Requires restart for changes to effect) [Default: 4]").defineInRange("avocadoTreeRarity", 4, 1, Integer.MAX_VALUE);
            this.bananaTreeRarity = builder.comment("Rarity of Banana Trees. Makes the tree generate 1 every X times (Requires restart for changes to effect) [Default: 4]").defineInRange("bananaTreeRarity", 4, 1, Integer.MAX_VALUE);
            this.cherryTreeRarity = builder.comment("Rarity of Cherry Trees. Makes the tree generate 1 every X times (Requires restart for changes to effect) [Default: 4]").defineInRange("cherryTreeRarity", 4, 1, Integer.MAX_VALUE);
            this.lemonTreeRarity = builder.comment("Rarity of Lemon Trees. Makes the tree generate 1 every X times (Requires restart for changes to effect) [Default: 4]").defineInRange("lemonTreeRarity", 4, 1, Integer.MAX_VALUE);
            this.mangoTreeRarity = builder.comment("Rarity of Mango Trees. Makes the tree generate 1 every X times (Requires restart for changes to effect) [Default: 4]").defineInRange("mangoTreeRarity", 4, 1, Integer.MAX_VALUE);
            this.oliveTreeRarity = builder.comment("Rarity of Olive Trees. Makes the tree generate 1 every X times (Requires restart for changes to effect) [Default: 4]").defineInRange("oliveTreeRarity", 4, 1, Integer.MAX_VALUE);
            this.orangeTreeRarity = builder.comment("Rarity of Orange Trees. Makes the tree generate 1 every X times (Requires restart for changes to effect) [Default: 4]").defineInRange("orangeTreeRarity", 4, 1, Integer.MAX_VALUE);
            this.pearTreeRarity = builder.comment("Rarity of Pear Trees. Makes the tree generate 1 every X times (Requires restart for changes to effect) [Default: 4]").defineInRange("pearTreeRarity", 4, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Crop settings").push("crop");
            this.generateNetherFlower = builder.comment("Enable generation of wild Nether Flower crops in the nether [Default: true]").define("generateNetherFlower", true);
            builder.pop();
        }
    }
}

