/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enhancedfarming.datagen;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mrbysco.enhancedfarming.block.FruitLeavesBlock;
import com.mrbysco.enhancedfarming.block.GrowableSaplingBlock;
import com.mrbysco.enhancedfarming.block.crops.CropstickCropBlock;
import com.mrbysco.enhancedfarming.block.crops.NetherFlowerBlock;
import com.mrbysco.enhancedfarming.init.FarmingLootTables;
import com.mrbysco.enhancedfarming.init.FarmingRegistry;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.GiftLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class FarmingDataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.m_123914_((DataProvider)new FarmingLoot(generator));
        }
        if (event.includeClient()) {
            generator.m_123914_((DataProvider)new Language(generator));
            generator.m_123914_((DataProvider)new FarmingBlockStates(generator, helper));
            generator.m_123914_((DataProvider)new FarmingItemModels(generator, helper));
        }
    }

    private static class FarmingLoot
    extends LootTableProvider {
        public FarmingLoot(DataGenerator gen) {
            super(gen);
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
            return ImmutableList.of((Object)Pair.of(FarmingBlocks::new, (Object)LootContextParamSets.f_81421_), (Object)Pair.of(FarmingRakeDrops::new, (Object)LootContextParamSets.f_81416_));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, @Nonnull ValidationContext validationtracker) {
            map.forEach((name, table) -> LootTables.m_79202_((ValidationContext)validationtracker, (ResourceLocation)name, (LootTable)table));
        }

        private static class FarmingRakeDrops
        extends GiftLoot {
            private FarmingRakeDrops() {
            }

            public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
                consumer.accept(FarmingLootTables.GAMEPLAY_RAKE_DROPS, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)FarmingRegistry.APPLE_SAPLING.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)FarmingRegistry.LEMON_SAPLING.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)FarmingRegistry.ORANGE_SAPLING.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)FarmingRegistry.MINT_SEEDS.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)FarmingRegistry.NETHER_FLOWER_SEEDS.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)FarmingRegistry.CHERRY_SAPLING.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)FarmingRegistry.PEAR_SAPLING.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)FarmingRegistry.BANANA_SAPLING.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)FarmingRegistry.AVOCADO_SAPLING.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)FarmingRegistry.MANGO_SAPLING.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)FarmingRegistry.TOMATO_SEEDS.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)FarmingRegistry.CUCUMBER_SEEDS.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)FarmingRegistry.AUBERGINE_SEEDS.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)FarmingRegistry.PINEAPPLE_SEEDS.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)FarmingRegistry.GRAPE_SEEDS.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)FarmingRegistry.CORN_SEEDS.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)FarmingRegistry.ONION_SEEDS.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)FarmingRegistry.GARLIC_SEEDS.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)FarmingRegistry.OLIVE_SAPLING.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)FarmingRegistry.LETTUCE_SEEDS.get())))));
            }
        }

        private static class FarmingBlocks
        extends BlockLoot {
            private final float[] NORMAL_LEAVES_SAPLING_CHANCES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
            private final float[] JUNGLE_LEAVES_SAPLING_CHANGES = new float[]{0.025f, 0.027777778f, 0.03125f, 0.041666668f, 0.1f};

            private FarmingBlocks() {
            }

            protected void addTables() {
                this.m_124288_((Block)FarmingRegistry.APPLE_SAPLING.get());
                this.m_124288_((Block)FarmingRegistry.LEMON_SAPLING.get());
                this.m_124288_((Block)FarmingRegistry.ORANGE_SAPLING.get());
                this.m_124288_((Block)FarmingRegistry.CHERRY_SAPLING.get());
                this.m_124288_((Block)FarmingRegistry.PEAR_SAPLING.get());
                this.m_124288_((Block)FarmingRegistry.BANANA_SAPLING.get());
                this.m_124288_((Block)FarmingRegistry.AVOCADO_SAPLING.get());
                this.m_124288_((Block)FarmingRegistry.MANGO_SAPLING.get());
                this.m_124288_((Block)FarmingRegistry.OLIVE_SAPLING.get());
                this.m_124175_((Block)FarmingRegistry.APPLE_LEAVES.get(), block -> FarmingBlocks.m_124157_((Block)((Block)FarmingRegistry.APPLE_LEAVES.get()), (Block)((Block)FarmingRegistry.APPLE_SAPLING.get()), (float[])this.NORMAL_LEAVES_SAPLING_CHANCES));
                this.m_124175_((Block)FarmingRegistry.APPLE_LEAVES.get(), block -> FarmingBlocks.m_124157_((Block)((Block)FarmingRegistry.APPLE_LEAVES.get()), (Block)((Block)FarmingRegistry.APPLE_SAPLING.get()), (float[])this.NORMAL_LEAVES_SAPLING_CHANCES));
                this.m_124175_((Block)FarmingRegistry.LEMON_LEAVES.get(), block -> FarmingBlocks.m_124157_((Block)((Block)FarmingRegistry.LEMON_LEAVES.get()), (Block)((Block)FarmingRegistry.LEMON_SAPLING.get()), (float[])this.NORMAL_LEAVES_SAPLING_CHANCES));
                this.m_124175_((Block)FarmingRegistry.ORANGE_LEAVES.get(), block -> FarmingBlocks.m_124157_((Block)((Block)FarmingRegistry.ORANGE_LEAVES.get()), (Block)((Block)FarmingRegistry.ORANGE_SAPLING.get()), (float[])this.NORMAL_LEAVES_SAPLING_CHANCES));
                this.m_124175_((Block)FarmingRegistry.CHERRY_LEAVES.get(), block -> FarmingBlocks.m_124157_((Block)((Block)FarmingRegistry.CHERRY_LEAVES.get()), (Block)((Block)FarmingRegistry.CHERRY_SAPLING.get()), (float[])this.NORMAL_LEAVES_SAPLING_CHANCES));
                this.m_124175_((Block)FarmingRegistry.PEAR_LEAVES.get(), block -> FarmingBlocks.m_124157_((Block)((Block)FarmingRegistry.PEAR_LEAVES.get()), (Block)((Block)FarmingRegistry.PEAR_SAPLING.get()), (float[])this.NORMAL_LEAVES_SAPLING_CHANCES));
                this.m_124175_((Block)FarmingRegistry.BANANA_LEAVES.get(), block -> FarmingBlocks.m_124157_((Block)((Block)FarmingRegistry.BANANA_LEAVES.get()), (Block)((Block)FarmingRegistry.BANANA_SAPLING.get()), (float[])this.JUNGLE_LEAVES_SAPLING_CHANGES));
                this.m_124175_((Block)FarmingRegistry.AVOCADO_LEAVES.get(), block -> FarmingBlocks.m_124157_((Block)((Block)FarmingRegistry.AVOCADO_LEAVES.get()), (Block)((Block)FarmingRegistry.AVOCADO_SAPLING.get()), (float[])this.NORMAL_LEAVES_SAPLING_CHANCES));
                this.m_124175_((Block)FarmingRegistry.MANGO_LEAVES.get(), block -> FarmingBlocks.m_124157_((Block)((Block)FarmingRegistry.MANGO_LEAVES.get()), (Block)((Block)FarmingRegistry.MANGO_SAPLING.get()), (float[])this.NORMAL_LEAVES_SAPLING_CHANCES));
                this.m_124175_((Block)FarmingRegistry.OLIVE_LEAVES.get(), block -> FarmingBlocks.m_124157_((Block)((Block)FarmingRegistry.OLIVE_LEAVES.get()), (Block)((Block)FarmingRegistry.OLIVE_SAPLING.get()), (float[])this.NORMAL_LEAVES_SAPLING_CHANCES));
                this.m_124175_((Block)FarmingRegistry.CROP_STICK.get(), block -> FarmingBlocks.m_124168_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)FarmingBlocks.m_124134_((ItemLike)block, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)Items.f_42398_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)3.0f)))))));
                this.m_124175_((Block)FarmingRegistry.MINT_CROP.get(), block -> FarmingBlocks.m_124142_((Block)((Block)FarmingRegistry.MINT_CROP.get()), (Item)((Item)FarmingRegistry.MINT.get()), (Item)((Item)FarmingRegistry.MINT_SEEDS.get()), (LootItemCondition.Builder)this.getBuilder((CropBlock)FarmingRegistry.MINT_CROP.get())));
                LootItemBlockStatePropertyCondition.Builder netherBuilder = LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)FarmingRegistry.NETHER_FLOWER_CROP.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)NetherFlowerBlock.AGE, 5));
                this.m_124175_((Block)FarmingRegistry.NETHER_FLOWER_CROP.get(), arg_0 -> FarmingBlocks.lambda$addTables$12((LootItemCondition.Builder)netherBuilder, arg_0));
                this.m_124175_((Block)FarmingRegistry.TOMATO_CROP.get(), block -> FarmingBlocks.m_124142_((Block)((Block)FarmingRegistry.TOMATO_CROP.get()), (Item)((Item)FarmingRegistry.TOMATO.get()), (Item)((Item)FarmingRegistry.TOMATO_SEEDS.get()), (LootItemCondition.Builder)this.getBuilder((CropBlock)FarmingRegistry.TOMATO_CROP.get())));
                this.m_124175_((Block)FarmingRegistry.CUCUMBER_CROP.get(), block -> FarmingBlocks.m_124142_((Block)((Block)FarmingRegistry.CUCUMBER_CROP.get()), (Item)((Item)FarmingRegistry.CUCUMBER.get()), (Item)((Item)FarmingRegistry.CUCUMBER_SEEDS.get()), (LootItemCondition.Builder)this.getBuilder((CropBlock)FarmingRegistry.CUCUMBER_CROP.get())));
                this.m_124175_((Block)FarmingRegistry.AUBERGINE_CROP.get(), block -> FarmingBlocks.m_124142_((Block)((Block)FarmingRegistry.AUBERGINE_CROP.get()), (Item)((Item)FarmingRegistry.AUBERGINE.get()), (Item)((Item)FarmingRegistry.AUBERGINE_SEEDS.get()), (LootItemCondition.Builder)this.getBuilder((CropBlock)FarmingRegistry.AUBERGINE_CROP.get())));
                this.m_124175_((Block)FarmingRegistry.GRAPE_CROP.get(), block -> FarmingBlocks.m_124142_((Block)((Block)FarmingRegistry.GRAPE_CROP.get()), (Item)((Item)FarmingRegistry.GRAPES.get()), (Item)((Item)FarmingRegistry.GRAPE_SEEDS.get()), (LootItemCondition.Builder)this.getBuilder((CropBlock)FarmingRegistry.GRAPE_CROP.get())));
                this.m_124175_((Block)FarmingRegistry.PINEAPPLE_CROP.get(), block -> FarmingBlocks.m_124142_((Block)((Block)FarmingRegistry.PINEAPPLE_CROP.get()), (Item)((Item)FarmingRegistry.PINEAPPLE.get()), (Item)((Item)FarmingRegistry.PINEAPPLE_SEEDS.get()), (LootItemCondition.Builder)this.getBuilder((CropBlock)FarmingRegistry.PINEAPPLE_CROP.get())));
                this.m_124175_((Block)FarmingRegistry.CORN_CROP.get(), block -> FarmingBlocks.m_124142_((Block)((Block)FarmingRegistry.CORN_CROP.get()), (Item)((Item)FarmingRegistry.CORN.get()), (Item)((Item)FarmingRegistry.CORN_SEEDS.get()), (LootItemCondition.Builder)this.getBuilder((CropBlock)FarmingRegistry.CORN_CROP.get())));
                this.m_124175_((Block)FarmingRegistry.ONION_CROP.get(), block -> FarmingBlocks.m_124142_((Block)((Block)FarmingRegistry.ONION_CROP.get()), (Item)((Item)FarmingRegistry.ONION.get()), (Item)((Item)FarmingRegistry.ONION_SEEDS.get()), (LootItemCondition.Builder)this.getBuilder((CropBlock)FarmingRegistry.ONION_CROP.get())));
                this.m_124175_((Block)FarmingRegistry.GARLIC_CROP.get(), block -> FarmingBlocks.m_124142_((Block)((Block)FarmingRegistry.GARLIC_CROP.get()), (Item)((Item)FarmingRegistry.GARLIC.get()), (Item)((Item)FarmingRegistry.GARLIC_SEEDS.get()), (LootItemCondition.Builder)this.getBuilder((CropBlock)FarmingRegistry.GARLIC_CROP.get())));
                this.m_124175_((Block)FarmingRegistry.LETTUCE_CROP.get(), block -> FarmingBlocks.m_124142_((Block)((Block)FarmingRegistry.LETTUCE_CROP.get()), (Item)((Item)FarmingRegistry.LETTUCE.get()), (Item)((Item)FarmingRegistry.LETTUCE_SEEDS.get()), (LootItemCondition.Builder)this.getBuilder((CropBlock)FarmingRegistry.LETTUCE_CROP.get())));
                this.m_124288_((Block)FarmingRegistry.SCARECROW.get());
            }

            public LootItemCondition.Builder getBuilder(CropBlock block) {
                return LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)block.m_7959_(), block.m_7419_()));
            }

            protected Iterable<Block> getKnownBlocks() {
                return FarmingRegistry.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
            }

            private static /* synthetic */ LootTable.Builder lambda$addTables$12(LootItemCondition.Builder netherBuilder, Block block) {
                return FarmingBlocks.m_124142_((Block)((Block)FarmingRegistry.NETHER_FLOWER_CROP.get()), (Item)Items.f_42585_, (Item)((Item)FarmingRegistry.NETHER_FLOWER_SEEDS.get()), (LootItemCondition.Builder)netherBuilder);
            }
        }
    }

    private static class Language
    extends LanguageProvider {
        public Language(DataGenerator gen) {
            super(gen, "enhancedfarming", "en_us");
        }

        protected void addTranslations() {
            this.add("enhancedfarming.config.title", "Enhanced Farming Config");
            this.add("itemGroup.enhancedfarming", "Enhanced Farming");
            this.addBlocks();
            this.addItems();
            this.add("enhancedfarming.gui.jei.category.piston", "Piston crafting");
        }

        private void addBlocks() {
            this.addBlock((Supplier)FarmingRegistry.MINT_CROP, "Mint Crop");
            this.addBlock((Supplier)FarmingRegistry.NETHER_FLOWER_CROP, "Nether Flower Crop");
            this.addBlock((Supplier)FarmingRegistry.TOMATO_CROP, "Tomato Crop");
            this.addBlock((Supplier)FarmingRegistry.CUCUMBER_CROP, "Cucumber Crop");
            this.addBlock((Supplier)FarmingRegistry.AUBERGINE_CROP, "Aubergine Crop");
            this.addBlock((Supplier)FarmingRegistry.GRAPE_CROP, "Grape Crop");
            this.addBlock((Supplier)FarmingRegistry.PINEAPPLE_CROP, "Pineapple Crop");
            this.addBlock((Supplier)FarmingRegistry.CORN_CROP, "Corn Crop");
            this.addBlock((Supplier)FarmingRegistry.ONION_CROP, "Onion Crop");
            this.addBlock((Supplier)FarmingRegistry.GARLIC_CROP, "Garlic Crop");
            this.addBlock((Supplier)FarmingRegistry.LETTUCE_CROP, "Lettuce Crop");
            this.addBlock((Supplier)FarmingRegistry.APPLE_LEAVES, "Apple Leaves");
            this.addBlock((Supplier)FarmingRegistry.LEMON_LEAVES, "Lemon Leaves");
            this.addBlock((Supplier)FarmingRegistry.ORANGE_LEAVES, "Orange Leaves");
            this.addBlock((Supplier)FarmingRegistry.CHERRY_LEAVES, "Cherry Leaves");
            this.addBlock((Supplier)FarmingRegistry.PEAR_LEAVES, "Pear Leaves");
            this.addBlock((Supplier)FarmingRegistry.BANANA_LEAVES, "Banana Leaves");
            this.addBlock((Supplier)FarmingRegistry.AVOCADO_LEAVES, "Avocado Leaves");
            this.addBlock((Supplier)FarmingRegistry.MANGO_LEAVES, "Mango Leaves");
            this.addBlock((Supplier)FarmingRegistry.OLIVE_LEAVES, "Olive Leaves");
            this.addBlock((Supplier)FarmingRegistry.APPLE_SAPLING, "Apple Seeds");
            this.addBlock((Supplier)FarmingRegistry.LEMON_SAPLING, "Lemon Seeds");
            this.addBlock((Supplier)FarmingRegistry.ORANGE_SAPLING, "Orange Seeds");
            this.addBlock((Supplier)FarmingRegistry.CHERRY_SAPLING, "Cherry Seeds");
            this.addBlock((Supplier)FarmingRegistry.PEAR_SAPLING, "Pear Seeds");
            this.addBlock((Supplier)FarmingRegistry.BANANA_SAPLING, "Banana Seeds");
            this.addBlock((Supplier)FarmingRegistry.AVOCADO_SAPLING, "Avocado Seed");
            this.addBlock((Supplier)FarmingRegistry.MANGO_SAPLING, "Mango Seed");
            this.addBlock((Supplier)FarmingRegistry.OLIVE_SAPLING, "Olive Seeds");
            this.addBlock((Supplier)FarmingRegistry.CROP_STICK, "Crop Sticks");
            this.addBlock((Supplier)FarmingRegistry.SCARECROW, "Scarecrow");
        }

        private void addItems() {
            this.addItem((Supplier)FarmingRegistry.MINT_SEEDS, "Mint Seeds");
            this.addItem((Supplier)FarmingRegistry.NETHER_FLOWER_SEEDS, "Nether Flower Seeds");
            this.addItem((Supplier)FarmingRegistry.TOMATO_SEEDS, "Tomato Seeds");
            this.addItem((Supplier)FarmingRegistry.CUCUMBER_SEEDS, "Cucumber Seeds");
            this.addItem((Supplier)FarmingRegistry.AUBERGINE_SEEDS, "Aubergine Seeds");
            this.addItem((Supplier)FarmingRegistry.GRAPE_SEEDS, "Grape Seeds");
            this.addItem((Supplier)FarmingRegistry.CORN_SEEDS, "Corn Seeds");
            this.addItem((Supplier)FarmingRegistry.PINEAPPLE_SEEDS, "Pineapple Seeds");
            this.addItem((Supplier)FarmingRegistry.ONION_SEEDS, "Onion Seeds");
            this.addItem((Supplier)FarmingRegistry.GARLIC_SEEDS, "Garlic Seeds");
            this.addItem((Supplier)FarmingRegistry.LETTUCE_SEEDS, "Lettuce Seeds");
            this.addItem((Supplier)FarmingRegistry.POT, "Pot");
            this.addItem((Supplier)FarmingRegistry.CUTTING_BOARD, "Cutting Board");
            this.addItem((Supplier)FarmingRegistry.MORTAR_AND_PESTLE, "Mortar And Pestle");
            this.addItem((Supplier)FarmingRegistry.MINT, "Mint");
            this.addItem((Supplier)FarmingRegistry.LEMON, "Lemon");
            this.addItem((Supplier)FarmingRegistry.ORANGE, "Orange");
            this.addItem((Supplier)FarmingRegistry.CHERRY, "Cherry");
            this.addItem((Supplier)FarmingRegistry.PEAR, "Pear");
            this.addItem((Supplier)FarmingRegistry.BANANA, "Banana");
            this.addItem((Supplier)FarmingRegistry.OLIVE, "Olive");
            this.addItem((Supplier)FarmingRegistry.AVOCADO, "Avocado");
            this.addItem((Supplier)FarmingRegistry.MANGO, "Mango");
            this.addItem((Supplier)FarmingRegistry.TOMATO, "Tomato");
            this.addItem((Supplier)FarmingRegistry.CUCUMBER, "Cucumber");
            this.addItem((Supplier)FarmingRegistry.AUBERGINE, "Aubergine");
            this.addItem((Supplier)FarmingRegistry.GRAPES, "Grapes");
            this.addItem((Supplier)FarmingRegistry.PINEAPPLE, "Pineapple");
            this.addItem((Supplier)FarmingRegistry.CORN, "Corn");
            this.addItem((Supplier)FarmingRegistry.ONION, "Onion");
            this.addItem((Supplier)FarmingRegistry.GARLIC, "Garlic");
            this.addItem((Supplier)FarmingRegistry.LETTUCE, "Lettuce");
            this.addItem((Supplier)FarmingRegistry.GOLDEN_LEMON, "Golden lemon");
            this.addItem((Supplier)FarmingRegistry.GOLDEN_ORANGE, "Golden Orange");
            this.addItem((Supplier)FarmingRegistry.CHOCOLATE_BAR, "Chocolate Bar");
            this.addItem((Supplier)FarmingRegistry.CHOCOLATE_CANDY, "Chocolate Candy");
            this.addItem((Supplier)FarmingRegistry.CHOCOLATE_CHERRY, "Chocolate Cherry");
            this.addItem((Supplier)FarmingRegistry.CHOCOLATE_BANANA, "Chocolate Banana");
            this.addItem((Supplier)FarmingRegistry.MINT_CHOCOLATE_BAR, "Mint Chocolate Bar");
            this.addItem((Supplier)FarmingRegistry.MINT_TEA, "Mint Tea");
            this.addItem((Supplier)FarmingRegistry.APPLE_JUICE, "Apple Juice");
            this.addItem((Supplier)FarmingRegistry.LEMONADE, "Lemonade");
            this.addItem((Supplier)FarmingRegistry.ORANGE_JUICE, "Orange Juice");
            this.addItem((Supplier)FarmingRegistry.CHERRY_JUICE, "Cherry Juice");
            this.addItem((Supplier)FarmingRegistry.PEAR_JUICE, "Pear Juice");
            this.addItem((Supplier)FarmingRegistry.BANANA_JUICE, "Banana Juice");
            this.addItem((Supplier)FarmingRegistry.GRAPE_JUICE, "Grape Juice");
            this.addItem((Supplier)FarmingRegistry.MANGO_JUICE, "Mango Juice");
            this.addItem((Supplier)FarmingRegistry.PINEAPPLE_JUICE, "Pineapple Juice");
            this.addItem((Supplier)FarmingRegistry.MILK_BOTTLE, "Milk Bottle");
            this.addItem((Supplier)FarmingRegistry.COLD_CHOCOLATE_BOTTLE, "Cold Chocolate Bottle");
            this.addItem((Supplier)FarmingRegistry.HOT_CHOCOLATE_BOTTLE, "Hot Chocolate Bottle");
            this.addItem((Supplier)FarmingRegistry.HOT_WATER, "Boiled Water");
            this.addItem((Supplier)FarmingRegistry.SMOOTHIE_APPLE, "Apple Smoothie");
            this.addItem((Supplier)FarmingRegistry.SMOOTHIE_LEMON, "Lemon Smoothie");
            this.addItem((Supplier)FarmingRegistry.SMOOTHIE_ORANGE, "Orange Smoothie");
            this.addItem((Supplier)FarmingRegistry.SMOOTHIE_CHERRY, "Cherry Smoothie");
            this.addItem((Supplier)FarmingRegistry.SMOOTHIE_PEAR, "Pear Smoothie");
            this.addItem((Supplier)FarmingRegistry.SMOOTHIE_BANANA, "Banana Smoothie");
            this.addItem((Supplier)FarmingRegistry.SMOOTHIE_GRAPE, "Grape Smoothie");
            this.addItem((Supplier)FarmingRegistry.SMOOTHIE_MANGO, "Mango Smoothie");
            this.addItem((Supplier)FarmingRegistry.SMOOTHIE_PINEAPPLE, "Pineapple Smoothie");
            this.addItem((Supplier)FarmingRegistry.SMOOTHIE_CUCUMBER, "Cucumber Smoothie");
            this.addItem((Supplier)FarmingRegistry.STOCK, "Stock");
            this.addItem((Supplier)FarmingRegistry.SALT, "Salt");
            this.addItem((Supplier)FarmingRegistry.FLOUR, "Flour");
            this.addItem((Supplier)FarmingRegistry.DOUGH, "Dough");
            this.addItem((Supplier)FarmingRegistry.OLIVE_OIL, "Olive Oil");
            this.addItem((Supplier)FarmingRegistry.PASTA, "Pasta");
            this.addItem((Supplier)FarmingRegistry.RAW_FRIES, "Raw Fries");
            this.addItem((Supplier)FarmingRegistry.FRUIT_SALAD, "Fruit Salad");
            this.addItem((Supplier)FarmingRegistry.SALAD, "Salad");
            this.addItem((Supplier)FarmingRegistry.CORN_SOUP, "Corn Soup");
            this.addItem((Supplier)FarmingRegistry.CUCUMBER_SOUP, "Cucumber Soup");
            this.addItem((Supplier)FarmingRegistry.TOMATO_SOUP, "Tomato Soup");
            this.addItem((Supplier)FarmingRegistry.POTATO_SOUP, "Potato Soup");
            this.addItem((Supplier)FarmingRegistry.CARROT_SOUP, "Carrot Soup");
            this.addItem((Supplier)FarmingRegistry.ONION_SOUP, "Onion Soup");
            this.addItem((Supplier)FarmingRegistry.CHICKEN_NOODLE_SOUP, "Chicken Noodle Soup");
            this.addItem((Supplier)FarmingRegistry.HAMBURGER, "Hamburger");
            this.addItem((Supplier)FarmingRegistry.CHICKENBURGER, "Chicken Burger");
            this.addItem((Supplier)FarmingRegistry.CHEESEBURGER, "Cheese Burger");
            this.addItem((Supplier)FarmingRegistry.BOILED_EGG, "Boiled Egg");
            this.addItem((Supplier)FarmingRegistry.BAKED_EGG, "Baked Egg");
            this.addItem((Supplier)FarmingRegistry.SLICED_BREAD, "Sliced Bread");
            this.addItem((Supplier)FarmingRegistry.CHEESE, "Cheese");
            this.addItem((Supplier)FarmingRegistry.SPAGHETTI, "Spaghetti");
            this.addItem((Supplier)FarmingRegistry.JAM, "Fruit Jam");
            this.addItem((Supplier)FarmingRegistry.FRIES, "Fries");
            this.addItem((Supplier)FarmingRegistry.FISH_AND_CHIPS, "Fish And Chips");
            this.addItem((Supplier)FarmingRegistry.POTATO_CHIPS, "Potato Chips");
            this.addItem((Supplier)FarmingRegistry.GUACAMOLE, "Guacamole");
            this.addItem((Supplier)FarmingRegistry.GUAC_AND_CHIPS, "Guac and Chips");
            this.addItem((Supplier)FarmingRegistry.EGG_SANDWICH, "Egg Sandwich");
            this.addItem((Supplier)FarmingRegistry.BACON_SANDWICH, "Bacon Sandwich");
            this.addItem((Supplier)FarmingRegistry.CHICKEN_SANDWICH, "Chicken Sandwich");
            this.addItem((Supplier)FarmingRegistry.JC_SANDWICH, "Jam And Cheese Sandwich");
            this.addItem((Supplier)FarmingRegistry.PINEAPPLE_PIZZA, "Pineapple Pizza");
            this.addItem((Supplier)FarmingRegistry.CHEESE_PIZZA, "Cheese Pizza");
            this.addItem((Supplier)FarmingRegistry.BACON_PIZZA, "Bacon Pizza");
            this.addItem((Supplier)FarmingRegistry.APPLE_PIE, "Apple Pie");
            this.addItem((Supplier)FarmingRegistry.BANANA_PIE, "Banana Cream Pie");
            this.addItem((Supplier)FarmingRegistry.BACON_AND_EGG_PIE, "Bacon And Egg Pie");
            this.addItem((Supplier)FarmingRegistry.CHERRY_PIE, "Cherry Pie");
            this.addItem((Supplier)FarmingRegistry.GRAPE_PIE, "Grape Pie");
            this.addItem((Supplier)FarmingRegistry.LEMON_PIE, "Lemon Meringue Pie");
            this.addItem((Supplier)FarmingRegistry.PEAR_PIE, "Pear Pie");
            this.addItem((Supplier)FarmingRegistry.WOODEN_RAKE, "Wooden Rake");
            this.addItem((Supplier)FarmingRegistry.STONE_RAKE, "Stone Rake");
            this.addItem((Supplier)FarmingRegistry.IRON_RAKE, "Iron Rake");
            this.addItem((Supplier)FarmingRegistry.GOLD_RAKE, "Gold Rake");
            this.addItem((Supplier)FarmingRegistry.DIAMOND_RAKE, "Diamond Rake");
        }
    }

    private static class FarmingBlockStates
    extends BlockStateProvider {
        public FarmingBlockStates(DataGenerator gen, ExistingFileHelper helper) {
            super(gen, "enhancedfarming", helper);
        }

        protected void registerStatesAndModels() {
            this.buildCrops((CropBlock)FarmingRegistry.MINT_CROP.get());
            this.buildNetherCrops((NetherFlowerBlock)((Object)FarmingRegistry.NETHER_FLOWER_CROP.get()));
            this.buildCrops((CropBlock)FarmingRegistry.TOMATO_CROP.get());
            this.buildCrops((CropBlock)FarmingRegistry.CUCUMBER_CROP.get());
            this.buildCrops((CropBlock)FarmingRegistry.AUBERGINE_CROP.get());
            this.buildStickCropCrops((CropstickCropBlock)((Object)FarmingRegistry.GRAPE_CROP.get()));
            this.buildCrops((CropBlock)FarmingRegistry.PINEAPPLE_CROP.get());
            this.buildCrops((CropBlock)FarmingRegistry.CORN_CROP.get());
            this.buildCrops((CropBlock)FarmingRegistry.ONION_CROP.get());
            this.buildCrops((CropBlock)FarmingRegistry.GARLIC_CROP.get());
            this.buildCrops((CropBlock)FarmingRegistry.LETTUCE_CROP.get());
            this.buildSaplings((GrowableSaplingBlock)((Object)FarmingRegistry.APPLE_SAPLING.get()), "oak_sapling");
            this.buildSaplings((GrowableSaplingBlock)((Object)FarmingRegistry.LEMON_SAPLING.get()), "oak_sapling");
            this.buildSaplings((GrowableSaplingBlock)((Object)FarmingRegistry.ORANGE_SAPLING.get()), "oak_sapling");
            this.buildSaplings((GrowableSaplingBlock)((Object)FarmingRegistry.CHERRY_SAPLING.get()), "oak_sapling");
            this.buildSaplings((GrowableSaplingBlock)((Object)FarmingRegistry.PEAR_SAPLING.get()), "oak_sapling");
            this.buildSaplings((GrowableSaplingBlock)((Object)FarmingRegistry.BANANA_SAPLING.get()), "jungle_sapling");
            this.buildSaplings((GrowableSaplingBlock)((Object)FarmingRegistry.AVOCADO_SAPLING.get()), "oak_sapling");
            this.buildSaplings((GrowableSaplingBlock)((Object)FarmingRegistry.MANGO_SAPLING.get()), "oak_sapling");
            this.buildSaplings((GrowableSaplingBlock)((Object)FarmingRegistry.OLIVE_SAPLING.get()), "acacia_sapling");
            this.buildLeaves((FruitLeavesBlock)((Object)FarmingRegistry.APPLE_LEAVES.get()), "oak_leaves");
            this.buildLeaves((FruitLeavesBlock)((Object)FarmingRegistry.LEMON_LEAVES.get()), "oak_leaves");
            this.buildLeaves((FruitLeavesBlock)((Object)FarmingRegistry.ORANGE_LEAVES.get()), "oak_leaves");
            this.buildLeaves((FruitLeavesBlock)((Object)FarmingRegistry.CHERRY_LEAVES.get()), "oak_leaves");
            this.buildLeaves((FruitLeavesBlock)((Object)FarmingRegistry.PEAR_LEAVES.get()), "oak_leaves");
            this.buildLeaves((FruitLeavesBlock)((Object)FarmingRegistry.BANANA_LEAVES.get()), "jungle_leaves");
            this.buildLeaves((FruitLeavesBlock)((Object)FarmingRegistry.AVOCADO_LEAVES.get()), "oak_leaves");
            this.buildLeaves((FruitLeavesBlock)((Object)FarmingRegistry.MANGO_LEAVES.get()), "oak_leaves");
            this.buildLeaves((FruitLeavesBlock)((Object)FarmingRegistry.OLIVE_LEAVES.get()), "acacia_leaves");
            this.model((Block)FarmingRegistry.CROP_STICK.get());
            this.horizontalBlock((Block)FarmingRegistry.SCARECROW.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/scarecrow")));
        }

        protected void model(Block block) {
            ModelFile.ExistingModelFile file = this.models().getExistingFile(block.getRegistryName());
            this.getVariantBuilder(block).forAllStates(arg_0 -> FarmingBlockStates.lambda$model$0((ModelFile)file, arg_0));
        }

        protected void buildNetherCrops(NetherFlowerBlock block) {
            VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
            for (int i = 0; i <= block.getMaxAge(); ++i) {
                ModelBuilder file = this.models().crop(block.getRegistryName().m_135815_() + "_" + i, new ResourceLocation("enhancedfarming", "block/crops/" + block.getRegistryName().m_135815_() + "_" + i));
                builder.partialState().with((Property)block.getAgeProperty(), (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)file).addModel();
            }
        }

        protected void buildCrops(CropBlock block) {
            VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
            for (int i = 0; i <= block.m_7419_(); ++i) {
                ModelBuilder file = this.models().crop(block.getRegistryName().m_135815_() + "_" + i, new ResourceLocation("enhancedfarming", "block/crops/" + block.getRegistryName().m_135815_() + "_" + i));
                builder.partialState().with((Property)block.m_7959_(), (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)file).addModel();
            }
        }

        protected void buildStickCropCrops(CropstickCropBlock block) {
            VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
            for (int i = 0; i <= block.m_7419_(); ++i) {
                ModelBuilder file = this.models().singleTexture(block.getRegistryName().m_135815_() + "_" + i, this.modLoc("block/stick_crops"), "crop", new ResourceLocation("enhancedfarming", "block/crops/" + block.getRegistryName().m_135815_() + "_" + i));
                builder.partialState().with((Property)block.m_7959_(), (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)file).addModel();
            }
        }

        protected void buildSaplings(GrowableSaplingBlock block, String base) {
            VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
            for (int i = 0; i <= block.getMatureStage(); ++i) {
                ModelBuilder file;
                if (i == block.getMatureStage()) {
                    file = this.models().crop(block.getRegistryName().m_135815_() + "_" + i, new ResourceLocation("enhancedfarming", "block/saplings/" + block.getRegistryName().m_135815_()));
                    builder.partialState().with((Property)block.getStageProperty(), (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)file).addModel();
                    continue;
                }
                file = this.models().crop(block.getRegistryName().m_135815_() + "_" + i, new ResourceLocation("enhancedfarming", "block/saplings/" + base + "_" + i));
                builder.partialState().with((Property)block.getStageProperty(), (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)file).addModel();
            }
        }

        protected void buildLeaves(FruitLeavesBlock block, String originalLeaves) {
            VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
            for (int i = 0; i <= block.getMaxAge(); ++i) {
                ModelBuilder file;
                if (i != block.getMaxAge()) {
                    file = ((BlockModelBuilder)this.models().singleTexture(block.getRegistryName().m_135815_() + "_blooming", this.modLoc("block/leave_overlay"), "layer1", new ResourceLocation("enhancedfarming", "block/leaves/" + block.getRegistryName().m_135815_() + "_blooming"))).texture("layer0", this.mcLoc("block/" + originalLeaves));
                    builder.partialState().with((Property)block.getAgeProperty(), (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)file).addModel();
                    continue;
                }
                file = ((BlockModelBuilder)this.models().singleTexture(block.getRegistryName().m_135815_() + "_fruity", this.modLoc("block/leave_overlay"), "layer1", new ResourceLocation("enhancedfarming", "block/leaves/" + block.getRegistryName().m_135815_() + "_fruity"))).texture("layer0", this.mcLoc("block/" + originalLeaves));
                builder.partialState().with((Property)block.getAgeProperty(), (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)file).addModel();
            }
        }

        private static /* synthetic */ ConfiguredModel[] lambda$model$0(ModelFile file, BlockState state) {
            return ConfiguredModel.builder().modelFile(file).build();
        }
    }

    private static class FarmingItemModels
    extends ItemModelProvider {
        public FarmingItemModels(DataGenerator gen, ExistingFileHelper helper) {
            super(gen, "enhancedfarming", helper);
        }

        protected void registerModels() {
            FarmingRegistry.ITEMS.getEntries().stream().map(RegistryObject::get).forEach(item -> {
                String path = Objects.requireNonNull(item.getRegistryName()).m_135815_();
                if (!path.equals("scarecrow")) {
                    if (path.endsWith("_sapling")) {
                        this.singleTexture(path, this.mcLoc("item/handheld"), "layer0", this.modLoc("block/saplings/" + path));
                    } else if (path.endsWith("_leaves")) {
                        this.withExistingParent(path, this.modLoc("block/" + path + "_fruity"));
                    } else if (path.endsWith("_rake")) {
                        this.singleTexture(path, this.mcLoc("item/handheld"), "layer0", this.modLoc("item/" + path));
                    } else {
                        this.singleTexture(path, this.mcLoc("item/generated"), "layer0", this.modLoc("item/" + path));
                    }
                } else {
                    this.withExistingParent(path, this.modLoc("block/scarecrow"));
                }
            });
        }

        public String m_6055_() {
            return "Item Models";
        }
    }

    private static class FarmingLanguage
    extends LanguageProvider {
        public FarmingLanguage(DataGenerator gen) {
            super(gen, "enhancedfarming", "en_us");
        }

        protected void addTranslations() {
        }
    }

    private static class FarmingRecipes
    extends RecipeProvider {
        public FarmingRecipes(DataGenerator gen) {
            super(gen);
        }

        protected void m_176531_(Consumer<FinishedRecipe> consumer) {
        }

        protected void m_126013_(HashCache cache, JsonObject advancementJson, Path path) {
        }
    }
}

