/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enhancedfarming.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mrbysco.enhancedfarming.recipes.FarmingRecipes;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class PistonRecipe
implements Recipe<Container> {
    protected final ResourceLocation id;
    protected final String group;
    protected final Ingredient ingredient;
    protected final ItemStack result;

    public PistonRecipe(ResourceLocation id, String group, Ingredient ingredient, ItemStack stack) {
        this.id = id;
        this.group = group;
        this.ingredient = ingredient;
        this.result = stack;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)FarmingRecipes.PISTON_CRAFTING_TYPE.get();
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        return this.ingredient.test(inv.m_8020_(0));
    }

    public ItemStack m_5874_(Container inventory) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int x, int y) {
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonnulllist = NonNullList.m_122779_();
        nonnulllist.add((Object)this.ingredient);
        return nonnulllist;
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    public String m_6076_() {
        return this.group;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)FarmingRecipes.PISTON_CRAFTING_SERIALIZER.get();
    }

    public static class SerializerPistonRecipe
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<PistonRecipe> {
        public PistonRecipe fromJson(ResourceLocation recipeId, JsonObject jsonObject) {
            ItemStack itemstack;
            String s = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"group", (String)"");
            JsonArray jsonelement = GsonHelper.m_13885_((JsonObject)jsonObject, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)jsonObject, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)jsonObject, (String)"ingredient");
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonelement);
            if (!jsonObject.has("result")) {
                throw new JsonSyntaxException("Missing result, expected to find a string or object");
            }
            if (jsonObject.get("result").isJsonObject()) {
                itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"));
            } else {
                String s1 = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"result");
                ResourceLocation resourcelocation = new ResourceLocation(s1);
                itemstack = new ItemStack((ItemLike)Registry.f_122827_.m_6612_(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + s1 + " does not exist")));
            }
            return new PistonRecipe(recipeId, s, ingredient, itemstack);
        }

        @Nullable
        public PistonRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String s = buffer.m_130277_();
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack itemstack = buffer.m_130267_();
            return new PistonRecipe(recipeId, s, ingredient, itemstack);
        }

        public void toNetwork(FriendlyByteBuf buffer, PistonRecipe recipe) {
            buffer.m_130070_(recipe.group);
            recipe.ingredient.m_43923_(buffer);
            buffer.m_130055_(recipe.result);
        }
    }
}

