/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.biome_dictionary;

import com.legacy.structure_gel.api.biome_dictionary.BiomeDictionary;
import com.legacy.structure_gel.api.biome_dictionary.IBiomeFilter;
import com.legacy.structure_gel.api.registry.registrar.BiomeRegistrar;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.util.Internal;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public final class BiomeType
implements IBiomeFilter.HolderSetBiomeFilter<Holder<Biome>> {
    protected static final ResourceLocation INTERNAL_NAME = StructureGelMod.locate("internal");
    private final ResourceLocation registryName;
    private final boolean immutable;
    @Nullable
    private IBiomeFilter.BiomeFilter biomeFilter = null;
    @Nullable
    private IBiomeFilter.BiomeTypeFilter typeFilter = null;
    @Nullable
    private IBiomeFilter.ForgeTypeFilter forgeTypeFilter = null;
    private final List<IBiomeFilter<?>> filters = new ArrayList();

    private BiomeType(Builder builder) throws IllegalStateException {
        this.registryName = builder.registryName;
        this.immutable = builder.immutable;
        List<Holder<Biome>> holders = builder.biomes.stream().map(arg_0 -> ((IForgeRegistry)ForgeRegistries.BIOMES).getHolder(arg_0)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (!holders.isEmpty()) {
            this.biomeFilter = new IBiomeFilter.BiomeFilter(holders);
            this.filters.add(this.biomeFilter);
        }
        List<BiomeType> biomeTypes = builder.parents.stream().map(BiomeDictionary.REGISTRY::get).filter(type -> type != null).collect(Collectors.toList());
        if (!biomeTypes.isEmpty()) {
            this.typeFilter = new IBiomeFilter.BiomeTypeFilter(biomeTypes);
            this.filters.add(this.typeFilter);
        }
        this.validateParents(this);
        List<BiomeDictionary.Type> forgeTypes = List.copyOf(builder.forgeTypes);
        if (!forgeTypes.isEmpty()) {
            this.forgeTypeFilter = new IBiomeFilter.ForgeTypeFilter(forgeTypes);
            this.filters.add(this.forgeTypeFilter);
        }
    }

    public static Builder builder(ResourceLocation registryName) {
        return new Builder(registryName);
    }

    public static Builder builder() {
        return BiomeType.builder(INTERNAL_NAME);
    }

    @Internal
    protected static Builder builder(String registryName) {
        return BiomeType.builder(StructureGelMod.locate(registryName));
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public BiomeType addBiome(Holder<Biome> biome) {
        if (!this.immutable) {
            if (this.biomeFilter == null) {
                this.biomeFilter = new IBiomeFilter.BiomeFilter(List.of());
                this.filters.add(this.biomeFilter);
            }
            if (!this.biomeFilter.m_203333_(biome)) {
                this.biomeFilter.add(biome);
            }
        }
        return this;
    }

    public BiomeType addParent(BiomeType parent) throws IllegalStateException {
        if (!this.immutable) {
            if (this.typeFilter == null) {
                this.typeFilter = new IBiomeFilter.BiomeTypeFilter(List.of());
                this.filters.add(this.typeFilter);
            }
            this.typeFilter.add(parent);
            this.validateParents(this);
        }
        return this;
    }

    public BiomeType addForgeType(BiomeDictionary.Type forgeType) {
        if (!this.immutable) {
            if (this.forgeTypeFilter == null) {
                this.forgeTypeFilter = new IBiomeFilter.ForgeTypeFilter(List.of());
                this.filters.add(this.forgeTypeFilter);
            }
            this.forgeTypeFilter.add(forgeType);
        }
        return this;
    }

    public void merge(BiomeType type) throws IllegalStateException {
        if (type.biomeFilter != null) {
            type.biomeFilter.getData().forEach(this::addBiome);
        }
        if (type.typeFilter != null) {
            type.typeFilter.getData().forEach(this::addParent);
        }
        if (type.forgeTypeFilter != null) {
            type.forgeTypeFilter.getData().forEach(this::addForgeType);
        }
    }

    public boolean m_203333_(Holder<Biome> biome) {
        return this.filters.stream().anyMatch(filter -> filter.passesFilter(biome));
    }

    @Override
    public List<Holder<Biome>> getAllValues() {
        return this.filters.stream().flatMap(filter -> filter.getAllValues().stream()).collect(Collectors.toList());
    }

    @Override
    public List<Holder<Biome>> getData() {
        return this.getAllValues();
    }

    @Override
    public void add(Holder<Biome> object) {
        this.addBiome(object);
    }

    public boolean ignoreForGuess() {
        return this.equals(BiomeDictionary.ALL_BIOMES) || this.registryName.m_135827_().equals("forge") || this.equals(BiomeDictionary.EMPTY) || this.registryName.equals((Object)INTERNAL_NAME);
    }

    private void validateParents(BiomeType original) throws IllegalStateException {
        if (this.typeFilter != null) {
            for (BiomeType parent : this.typeFilter.getData()) {
                if (original.equals(parent)) {
                    throw new IllegalStateException("Detected a cycle in the Biome Dictionary. The BiomeType " + original.registryName + " contains itself through its parent, " + this.registryName);
                }
                parent.validateParents(original);
            }
        }
    }

    public String toString() {
        return String.format("BiomeType[registryName = %s, immutable = %b, biomes = %s]", this.registryName, this.immutable, this.valuesToStrings());
    }

    public List<String> toFilterStrings(boolean isIncluded) throws IllegalStateException {
        List values = this.toFilterStrings();
        return isIncluded ? values : (List)values.stream().map(s -> "!" + s).collect(Collectors.toCollection(ArrayList::new));
    }

    private List<String> toFilterStrings() throws IllegalStateException {
        if (BiomeDictionary.REGISTRY.containsKey(this.registryName)) {
            return new ArrayList<CallSite>(List.of("##" + this.registryName.toString()));
        }
        return this.valuesToStrings();
    }

    private List<String> valuesToStrings() {
        ArrayList<String> values = new ArrayList<String>();
        if (this.biomeFilter != null) {
            this.biomeFilter.m_203614_().map(h -> ((ResourceKey)h.m_203543_().orElseThrow(() -> new IllegalStateException("The biome holder " + h + " does not have a ResourceKey bound. Cannot create config filter strings."))).m_135782_().toString()).forEach(values::add);
        }
        if (this.typeFilter != null) {
            this.typeFilter.getData().forEach(type -> type.toFilterStrings().forEach(values::add));
        }
        if (this.forgeTypeFilter != null) {
            for (BiomeDictionary.Type forgeType : this.forgeTypeFilter.getData()) {
                BiomeType type2 = BiomeDictionary.FORGE_TYPES.get(forgeType);
                if (type2 != null) {
                    values.add("##" + type2.registryName);
                    continue;
                }
                net.minecraftforge.common.BiomeDictionary.getBiomes((BiomeDictionary.Type)forgeType).stream().map(key -> key.m_135782_().toString()).forEach(values::add);
            }
        }
        return values;
    }

    public static final class Builder {
        private ResourceLocation registryName;
        private final LinkedHashSet<ResourceLocation> biomes = new LinkedHashSet();
        private final LinkedHashSet<ResourceLocation> parents = new LinkedHashSet();
        private final LinkedHashSet<BiomeDictionary.Type> forgeTypes = new LinkedHashSet();
        private boolean immutable = false;

        private Builder(ResourceLocation registryName) {
            this.registryName = registryName;
        }

        public final Builder registryName(ResourceLocation registryName) {
            this.registryName = registryName;
            return this;
        }

        public final Builder biomes(Collection<ResourceLocation> biomeNames) {
            this.biomes.addAll(biomeNames);
            return this;
        }

        @SafeVarargs
        public final Builder biomes(ResourceKey<Biome> ... biomeKeys) {
            return this.biomes(Arrays.stream(biomeKeys).map(ResourceKey::m_135782_).collect(Collectors.toList()));
        }

        public final Builder biomes(ResourceLocation ... biomeNames) {
            return this.biomes(Arrays.asList(biomeNames));
        }

        public final Builder biomes(String modID, String ... biomeNames) {
            return this.biomes(Arrays.stream(biomeNames).map(b -> new ResourceLocation(modID, b)).collect(Collectors.toList()));
        }

        public final Builder biomes(BiomeRegistrar ... biomes) {
            return this.biomes(Arrays.stream(biomes).map(BiomeRegistrar::getName).collect(Collectors.toList()));
        }

        public final Builder biomes(BiomeSource ... biomeSources) {
            return this.biomes(Arrays.stream(biomeSources).map(BiomeSource::m_207840_).flatMap(Collection::stream).map(Holder::m_203543_).filter(Optional::isPresent).map(o -> ((ResourceKey)o.get()).m_135782_()).collect(Collectors.toList()));
        }

        public final Builder parents(Collection<ResourceLocation> biomeNames) {
            this.parents.addAll(biomeNames);
            return this;
        }

        public final Builder parents(BiomeType ... biomeTypes) {
            return this.parents(Arrays.stream(biomeTypes).map(BiomeType::getRegistryName).collect(Collectors.toList()));
        }

        public final Builder parents(ResourceLocation ... biomeTypeNames) {
            return this.parents(Arrays.asList(biomeTypeNames));
        }

        public final Builder forgeTypes(Collection<BiomeDictionary.Type> forgeTypes) {
            this.forgeTypes.addAll(forgeTypes);
            return this;
        }

        public final Builder forgeTypes(BiomeDictionary.Type ... forgeTypes) {
            return this.forgeTypes(Arrays.asList(forgeTypes));
        }

        public final Builder immutable() {
            this.immutable = true;
            return this;
        }

        public BiomeType build() throws IllegalStateException {
            return new BiomeType(this);
        }
    }
}

