/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.data_handler.parsing;

import com.legacy.structure_gel.api.data_handler.DataHandlerType;
import com.legacy.structure_gel.api.data_handler.parsing.DataMap;
import com.legacy.structure_gel.core.StructureGelMod;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.lang3.tuple.Pair;

public class DataParser {
    private boolean finalized = false;
    private final List<Parser<?>> parsers = new ArrayList();
    public final ResourceLocation dataHandlerType;

    private DataParser(ResourceLocation dataHandlerType) {
        this.dataHandlerType = dataHandlerType;
    }

    public static DataParser of(DataHandlerType<?> dataHandlerType, Consumer<DataParser> parserHandler) {
        DataParser dataParser = new DataParser(dataHandlerType.getRegistryName());
        parserHandler.accept(dataParser);
        for (Parser<?> parser : dataParser.parsers) {
            if (parser.defaultValName != null) continue;
            parser.setDefaultValName(parser.defaultVal != null ? parser.defaultVal.toString() : null);
        }
        dataParser.finalized = true;
        return dataParser;
    }

    public NumberParser<Integer> add(String key, int defaultVal, int min, int max) {
        return this.addNumber(key, Integer::valueOf, defaultVal, Integer.class, "int", min, max, (val, range) -> val >= (Integer)range.getLeft() && val <= (Integer)range.getRight());
    }

    public NumberParser<Float> add(String key, float defaultVal, float min, float max) {
        return this.addNumber(key, Float::valueOf, Float.valueOf(defaultVal), Float.class, "float", Float.valueOf(min), Float.valueOf(max), (val, range) -> val.floatValue() >= ((Float)range.getLeft()).floatValue() && val.floatValue() <= ((Float)range.getRight()).floatValue());
    }

    public NumberParser<Double> add(String key, double defaultVal, double min, double max) {
        return this.addNumber(key, Double::valueOf, defaultVal, Double.class, "double", min, max, (val, range) -> val >= (Double)range.getLeft() && val <= (Double)range.getRight());
    }

    public Parser<Boolean> add(String key, boolean defaultVal) {
        return this.add(key, Boolean::valueOf, defaultVal, Boolean.class, "boolean");
    }

    public Parser<String> add(String key, @Nullable String defaultVal) {
        return this.add(key, s -> s, defaultVal, String.class, "String");
    }

    public Parser<ResourceLocation> add(String key, @Nullable ResourceLocation defaultVal) {
        return this.add(key, DataParser::parseResourceLocation, defaultVal, ResourceLocation.class, "ResourceLocation");
    }

    public Parser<Direction> add(String key, @Nullable Direction defaultVal) {
        return this.add(key, Direction::m_122402_, defaultVal, Direction.class, "Direction").setDefaultValName(defaultVal != null ? defaultVal.m_122433_() : null);
    }

    public Parser<Direction.Axis> add(String key, @Nullable Direction.Axis defaultVal) {
        return this.add(key, Direction.Axis::m_122473_, defaultVal, Direction.Axis.class, "Axis").setDefaultValName(defaultVal != null ? defaultVal.m_122477_() : null);
    }

    public Parser<BlockState> add(String key, @Nullable BlockState defaultVal) {
        String defaultValName = null;
        if (defaultVal != null) {
            String str = defaultVal.toString();
            int endBracketIndex = str.indexOf(125);
            String block = str.substring(str.indexOf(123) + 1, endBracketIndex);
            defaultValName = block + str.substring(endBracketIndex + 1);
        }
        return this.add(key, DataParser::parseBlockState, defaultVal, BlockState.class, "BlockState").setDefaultValName(defaultValName).setExample("minecraft:chest[facing=east]");
    }

    public Parser<ItemStack> add(String key, @Nullable ItemStack defaultVal) {
        ItemStack defaultClone = null;
        String defaultValName = null;
        if (defaultVal != null) {
            defaultClone = defaultVal.m_41619_() ? new ItemStack((ItemLike)((Item)null)) : defaultVal.m_41777_();
            ResourceLocation registryName = defaultClone.m_41720_().getRegistryName();
            if (registryName != null) {
                CompoundTag tag = defaultClone.m_41739_(new CompoundTag());
                tag.m_128473_("id");
                defaultValName = registryName.toString() + (tag.m_128456_() ? "" : tag.m_7916_());
            }
            defaultClone.m_41784_().m_128344_("Count", (byte)defaultClone.m_41613_());
        }
        return this.add(key, DataParser::parseItemStack, defaultClone, ItemStack.class, "ItemStack").setDefaultValName(defaultValName, ItemStack::m_41728_).setExample("minecraft:diamond{Count:1b}");
    }

    public Parser<CompoundTag> add(String key, @Nullable CompoundTag defaultVal) {
        return this.add(key, DataParser::parseTag, defaultVal, CompoundTag.class, "CompoundTag").setDefaultValName(defaultVal != null ? defaultVal.m_7916_() : null).setExample("{key:\"value\", id:0, list:[0, 1, 2]}");
    }

    public <T> ResourceKeyParser<ResourceKey<T>> add(String key, @Nonnull ResourceKey<T> defaultVal) throws NullPointerException {
        if (defaultVal == null) {
            throw new NullPointerException("defaultVal cannot be null for " + this.dataHandlerType + "." + key + " use add(String, ResourceKey<T>, ResourceKey<Registry<T>>)");
        }
        return this.add(key, defaultVal, ResourceKey.m_135788_((ResourceLocation)defaultVal.getRegistryName()));
    }

    public <T> ResourceKeyParser<ResourceKey<T>> add(String key, @Nullable ResourceKey<T> defaultVal, @Nonnull ResourceKey<Registry<T>> registry) {
        ResourceKeyParser<ResourceKey<T>> parser = new ResourceKeyParser<ResourceKey<T>>(this.dataHandlerType, key, s -> DataParser.parseResourceKey(registry, s), defaultVal, registry);
        parser.setDefaultValName(defaultVal != null ? defaultVal.m_135782_().toString() : null);
        this.add(parser);
        return parser;
    }

    public <T extends IForgeRegistryEntry<T>> ForgeRegistryParser<T> add(String key, @Nonnull T defaultVal) throws NullPointerException {
        if (defaultVal == null) {
            throw new NullPointerException("defaultVal cannot be null for " + this.dataHandlerType + "." + key + " use add(String, T, IForgeRegistry<T>)");
        }
        IForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(defaultVal.getRegistryType());
        return this.add(key, defaultVal, registry);
    }

    public <T extends IForgeRegistryEntry<T>> ForgeRegistryParser<T> add(String key, @Nullable T defaultVal, @Nonnull IForgeRegistry<T> registry) {
        ResourceLocation registryName;
        String defaultValName = null;
        if (defaultVal != null && (registryName = defaultVal.getRegistryName()) != null) {
            defaultValName = registryName.toString();
        }
        ForgeRegistryParser<IForgeRegistryEntry> parser = new ForgeRegistryParser<IForgeRegistryEntry>(this.dataHandlerType, key, s -> DataParser.parseForgeRegistry(registry, s), defaultVal, registry);
        parser.setDefaultValName(defaultValName);
        this.add(parser);
        return parser;
    }

    public <T> Parser<T> add(String key, Function<String, T> parser, @Nullable T defaultVal, Class<T> type, String typeName, Predicate<String> validator) {
        Parser<T> dataParser = new Parser<T>(this.dataHandlerType, key, parser, defaultVal, type, typeName, validator);
        this.add(dataParser);
        return dataParser;
    }

    public <T> Parser<T> add(String key, Function<String, T> parser, @Nullable T defaultVal, Class<T> type, String typeName) {
        return this.add(key, parser, defaultVal, type, typeName, s -> Objects.nonNull(parser.apply((String)s)));
    }

    public <T extends Number> NumberParser<T> addNumber(String key, Function<String, T> parser, @Nullable T defaultVal, Class<T> type, String typeName, T minVal, T maxVal, BiPredicate<T, Pair<T, T>> rangeTest) {
        NumberParser<T> numParser = new NumberParser<T>(this.dataHandlerType, key, parser, defaultVal, type, typeName, minVal, maxVal, rangeTest);
        this.add(numParser);
        return numParser;
    }

    public void add(Parser<?> parser) throws IllegalStateException, IllegalArgumentException {
        if (!this.finalized) {
            for (Parser<?> p : this.parsers) {
                if (!p.name.equals(parser.name)) continue;
                throw new IllegalArgumentException("Attempted to add a parser under an existing name for " + this.dataHandlerType + ". " + parser);
            }
        } else {
            throw new IllegalStateException("Attempted to add a parser after the DataParser for " + this.dataHandlerType + " has already been created. " + parser);
        }
        this.parsers.add(parser);
    }

    public DataMap parse(Map<String, String> input) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (Parser<?> parser : this.parsers) {
            String key = parser.key;
            String rawVal = input.get(key);
            if (rawVal != null) {
                Object parsedVal = parser.parse(rawVal);
                data.put(key, parsedVal);
                continue;
            }
            data.put(key, parser.defaultVal);
        }
        return new DataMap(data);
    }

    public List<Parser<?>> getParsers() {
        return Collections.unmodifiableList(this.parsers);
    }

    @Nullable
    private static ResourceLocation parseResourceLocation(String key) {
        return ResourceLocation.m_135830_((String)key) ? new ResourceLocation(key) : null;
    }

    @Nullable
    private static BlockState parseBlockState(String key) {
        BlockStateParser stateParser = new BlockStateParser(new StringReader(key), false);
        try {
            stateParser.m_116806_(true);
            return stateParser.m_116808_();
        }
        catch (CommandSyntaxException e) {
            return null;
        }
    }

    @Nullable
    private static ItemStack parseItemStack(String key) {
        ItemParser itemParser = new ItemParser(new StringReader(key), false);
        try {
            itemParser.m_121032_();
            ItemStack itemStack = new ItemStack((ItemLike)itemParser.m_121014_());
            CompoundTag nbt = itemParser.m_121018_();
            if (nbt != null) {
                itemStack.m_41751_(nbt);
                if (nbt.m_128425_("Count", 1)) {
                    itemStack.m_41764_((int)nbt.m_128445_("Count"));
                }
            }
            return itemStack;
        }
        catch (CommandSyntaxException e) {
            return null;
        }
    }

    @Nullable
    private static CompoundTag parseTag(String key) {
        try {
            return new TagParser(new StringReader(key)).m_129373_();
        }
        catch (CommandSyntaxException e) {
            return null;
        }
    }

    @Nullable
    public static <T extends IForgeRegistryEntry<T>> T parseForgeRegistry(IForgeRegistry<T> registry, String key) {
        ResourceLocation location;
        if (ResourceLocation.m_135830_((String)key) && registry.containsKey(location = new ResourceLocation(key))) {
            return (T)registry.getValue(location);
        }
        return null;
    }

    @Nullable
    public static <T> ResourceKey<T> parseResourceKey(ResourceKey<Registry<T>> registry, String key) {
        if (ResourceLocation.m_135830_((String)key)) {
            return ResourceKey.m_135785_(registry, (ResourceLocation)new ResourceLocation(key));
        }
        return null;
    }

    public static class Parser<T> {
        public final String name;
        public final String key;
        public final Function<String, T> parseFunc;
        @Nullable
        public final T defaultVal;
        public final Class<T> type;
        public final String typeName;
        public final Predicate<String> validator;
        @Nullable
        private String example;
        @Nullable
        private String defaultValName;
        private Supplier<Collection<T>> suggestions = () -> Collections.emptyList();
        private Function<T, String> toStringFunc = Object::toString;

        public Parser(ResourceLocation dataHandlerType, String key, Function<String, T> parseFunc, @Nullable T defaultVal, Class<T> type, String typeName, Predicate<String> validator) {
            this.name = dataHandlerType.toString() + "." + key;
            this.key = key;
            this.parseFunc = parseFunc;
            this.defaultVal = defaultVal;
            this.type = type;
            this.typeName = typeName;
            this.validator = validator;
        }

        public <S> Parser<T> setSuggestions(Supplier<Collection<T>> suggestions, Function<T, String> toStringFunc) {
            this.suggestions = suggestions;
            this.toStringFunc = toStringFunc;
            return this;
        }

        public Collection<T> getSuggestions() {
            return this.suggestions.get();
        }

        public Function<T, String> getSuggestionToString() {
            return this.toStringFunc;
        }

        public Parser<T> setExample(@Nullable String example) {
            this.example = example;
            return this;
        }

        public Parser<T> setDefaultValName(@Nullable String defaultValName) throws IllegalArgumentException {
            return this.setDefaultValName(defaultValName, (a, b) -> a.equals(b));
        }

        public Parser<T> setDefaultValName(@Nullable String defaultValName, BiPredicate<T, T> equalsFunc) throws IllegalArgumentException {
            if (defaultValName == null && this.defaultVal == null) {
                this.defaultValName = "null";
            } else {
                if (!this.validator.test(defaultValName)) {
                    throw new IllegalArgumentException("The defaultValName for " + this.name + " was not valid: " + defaultValName);
                }
                T parsedVal = this.parseFunc.apply(defaultValName);
                if (this.defaultVal == null && this.defaultVal != parsedVal || !equalsFunc.test(this.defaultVal, parsedVal)) {
                    throw new IllegalArgumentException("The defaultValName for " + this.name + " did not equal the defaultVal. defaultVal: " + this.defaultVal + ", parsedVal: " + parsedVal + " from: " + defaultValName);
                }
                this.defaultValName = defaultValName;
            }
            return this;
        }

        @Nullable
        public String getExample() {
            return this.example;
        }

        public String getDefaultValName() {
            if (this.defaultValName == null) {
                throw new NullPointerException("The defaultValName for " + this.name + " was still null");
            }
            return this.defaultValName;
        }

        @Nullable
        public T parse(String value) {
            try {
                T ret = this.parseFunc.apply(value);
                return ret != null ? ret : this.defaultVal;
            }
            catch (Exception e) {
                StructureGelMod.logError("Failed to parse data for key=\"{}\", value=\"{}\". Returning the defaultVal={}", this.key, value, this.defaultVal);
                StructureGelMod.logError(e, new Object[0]);
                return this.defaultVal;
            }
        }

        public String getTranlsationKey(String labelType) {
            return "gui.structure_gel.data_handler." + this.name + "." + labelType;
        }

        public String toString() {
            return "DataParser[key=" + this.key + ", type=" + this.typeName + "]";
        }
    }

    public static class NumberParser<T extends Number>
    extends Parser<T> {
        private T minVal;
        private T maxVal;

        public NumberParser(ResourceLocation dataHandlerType, String key, Function<String, T> parseFunc, T defaultVal, Class<T> type, String typeName, T minVal, T maxVal, BiPredicate<T, Pair<T, T>> rangeTest) {
            super(dataHandlerType, key, parseFunc, defaultVal, type, typeName, NumberParser.validator(parseFunc, minVal, maxVal, rangeTest));
            this.minVal = minVal;
            this.maxVal = maxVal;
        }

        public T getMin() {
            return this.minVal;
        }

        public T getMax() {
            return this.maxVal;
        }

        private static <T extends Number> Predicate<String> validator(Function<String, T> func, T minVal, T maxVal, BiPredicate<T, Pair<T, T>> rangeTest) {
            return s -> {
                try {
                    Number val = (Number)func.apply((String)s);
                    return rangeTest.test(val, Pair.of((Object)minVal, (Object)maxVal));
                }
                catch (Exception e) {
                    return false;
                }
            };
        }
    }

    public static class ResourceKeyParser<T>
    extends Parser<ResourceKey<T>> {
        private ResourceKey<Registry<T>> registry;

        public ResourceKeyParser(ResourceLocation dataHandlerType, String key, Function<String, ResourceKey<T>> parseFunc, @Nullable ResourceKey<T> defaultVal, ResourceKey<Registry<T>> registry) {
            super(dataHandlerType, key, parseFunc, defaultVal, ResourceKey.class, "Registry: " + registry.m_135782_(), s -> Objects.nonNull(parseFunc.apply((String)s)));
            this.registry = registry;
        }

        public ResourceKey<Registry<T>> getRegistry() {
            return this.registry;
        }
    }

    public static class ForgeRegistryParser<T extends IForgeRegistryEntry<T>>
    extends Parser<T> {
        private IForgeRegistry<T> registry;

        public ForgeRegistryParser(ResourceLocation dataHandlerType, String key, Function<String, T> parseFunc, @Nullable T defaultVal, IForgeRegistry<T> registry) {
            super(dataHandlerType, key, parseFunc, defaultVal, registry.getRegistrySuperType(), "Registry: " + registry.getRegistryName(), s -> Objects.nonNull(parseFunc.apply((String)s)));
            this.registry = registry;
        }

        public IForgeRegistry<T> getRegistry() {
            return this.registry;
        }
    }
}

