/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.registry.registrar;

import com.legacy.structure_gel.api.config.StructureConfig;
import com.legacy.structure_gel.api.registry.registrar.base.IForgeRegistrar;
import com.legacy.structure_gel.api.registry.registrar.base.IRegistrar;
import com.legacy.structure_gel.api.structure.GelStructure;
import com.legacy.structure_gel.api.structure.GelStructurePlacement;
import com.legacy.structure_gel.api.structure.base.IConfigStructure;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.util.Internal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class StructureRegistrar<C extends FeatureConfiguration, S extends StructureFeature<C>>
implements IForgeRegistrar<StructureRegistrar<C, S>, StructureFeature<?>>,
IRegistrar<StructureRegistrar<C, S>> {
    @Internal
    public static final Map<ResourceLocation, StructureRegistrar<?, ?>> REGISTRARS = new LinkedHashMap();
    private final ResourceLocation registryName;
    private final Lazy<S> structure;
    private final Map<String, StructurePieceType> pieceTypes;
    private final GenerationStep.Decoration generationStage;
    private final Map<String, Holder<ConfiguredStructureFeature<C, S>>> configuredStructures = new HashMap<String, Holder<ConfiguredStructureFeature<C, S>>>();
    @Nullable
    private final StructurePlacement structurePlacement;
    @Nullable
    private Holder<StructureSet> structureSet = null;
    @Nullable
    private Map<String, ConfiguredStructureFeatureBuilder<C, S>> configuredStructureFeatureBuilders;
    private boolean handledForge = false;
    private boolean handled = false;

    protected StructureRegistrar(Builder<C, S> builder) {
        this.registryName = builder.registryName;
        this.structure = builder.structure;
        this.pieceTypes = builder.pieceTypes;
        this.configuredStructureFeatureBuilders = builder.configuredStructureFeatureBuilders;
        this.generationStage = builder.generationStep;
        this.structurePlacement = builder.structurePlacement;
        REGISTRARS.put(this.registryName, this);
        try {
            IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
            bus.addGenericListener(StructureFeature.class, EventPriority.HIGH, event -> StructureRegistrar.handleForge(this, event.getRegistry()));
            bus.addListener(EventPriority.HIGH, event -> StructureRegistrar.handle(this));
        }
        catch (Exception e) {
            StructureGelMod.logWarn("A mod failed to load. The StructureRegistrar for " + this.registryName + " was not added to the registry event bus.", new Object[0]);
        }
    }

    public static <C extends FeatureConfiguration, S extends StructureFeature<C>> Builder<C, S> builder(ResourceLocation registryName, Supplier<S> structure) {
        return new Builder(registryName, structure);
    }

    public S getStructure() {
        return (S)((StructureFeature)this.structure.get());
    }

    public Map<String, StructurePieceType> getPieceTypes() {
        return this.pieceTypes;
    }

    @Nullable
    public StructurePieceType getPieceType(String name) {
        return this.getPieceTypes().get(name);
    }

    public StructurePieceType getPieceType() throws IllegalArgumentException {
        if (this.getPieceTypes().size() == 1) {
            return (StructurePieceType)this.getPieceTypes().values().toArray()[0];
        }
        throw new IllegalArgumentException(String.format("The structure %s has more than one piece type associated with it. A String must be passed to define which one to get.", this.registryName));
    }

    public Map<String, Holder<ConfiguredStructureFeature<C, S>>> getConfiguredStructures() {
        return this.configuredStructures;
    }

    @Nullable
    public Holder<ConfiguredStructureFeature<?, ?>> getConfigured(String name) {
        return this.getConfiguredExact(name);
    }

    @Nullable
    public Holder<ConfiguredStructureFeature<?, ?>> getConfigured() throws IllegalArgumentException {
        return this.getConfiguredExact();
    }

    @Nullable
    public Holder<ConfiguredStructureFeature<C, S>> getConfiguredExact(String name) {
        return this.getConfiguredStructures().get(name);
    }

    @Nullable
    public Holder<ConfiguredStructureFeature<C, S>> getConfiguredExact() throws IllegalArgumentException {
        Map<String, Holder<ConfiguredStructureFeature<C, S>>> structures = this.getConfiguredStructures();
        int size = structures.size();
        if (size == 1) {
            return (Holder)structures.values().toArray()[0];
        }
        if (size < 1) {
            return null;
        }
        throw new IllegalArgumentException(String.format("The structure %s has more than one configured structure feature associated with it. A String must be passed to define which one to get.", this.registryName));
    }

    @Nullable
    public Holder<StructureSet> getStructureSet() {
        return this.structureSet;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public GenerationStep.Decoration getGenerationStage() {
        return this.generationStage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <C extends FeatureConfiguration, S extends StructureFeature<C>> StructureRegistrar<C, S> handleForge(StructureRegistrar<C, S> registrar, IForgeRegistry<StructureFeature<?>> registry) {
        Class<StructureRegistrar> clazz = StructureRegistrar.class;
        synchronized (StructureRegistrar.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return registrar.handleForge((IForgeRegistry)registry);
        }
    }

    @Override
    @Internal
    public StructureRegistrar<C, S> handleForge(IForgeRegistry<StructureFeature<?>> registry) {
        if (!this.handledForge) {
            S structure = this.getStructure();
            if (structure.getRegistryName() == null) {
                structure.setRegistryName(this.getRegistryName());
            }
            registry.register(structure);
            StructureFeature.f_67032_.put(structure, this.generationStage);
            this.handledForge = true;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <C extends FeatureConfiguration, S extends StructureFeature<C>> StructureRegistrar<C, S> handle(StructureRegistrar<C, S> registrar) {
        Class<StructureRegistrar> clazz = StructureRegistrar.class;
        synchronized (StructureRegistrar.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return registrar.handle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Internal
    public StructureRegistrar<C, S> handle() {
        if (this.handled) return this;
        Class<StructureRegistrar> clazz = StructureRegistrar.class;
        synchronized (StructureRegistrar.class) {
            S structure = this.getStructure();
            if (structure instanceof IConfigStructure) {
                ((IConfigStructure)structure).getConfig().reloadBiomes();
            }
            this.pieceTypes.forEach((name, pieceType) -> Registry.m_122965_((Registry)Registry.f_122843_, (ResourceLocation)(name.isEmpty() ? this.registryName : new ResourceLocation(this.registryName.m_135827_(), this.registryName.m_135815_() + "_" + name)), (Object)pieceType));
            ArrayList structureWeights = new ArrayList();
            this.configuredStructureFeatureBuilders.forEach((name, builder) -> {
                Holder holder = BuiltinRegistries.m_206388_((Registry)BuiltinRegistries.f_123862_, (ResourceLocation)(name.isEmpty() ? this.registryName : new ResourceLocation(this.registryName.m_135827_(), this.registryName.m_135815_() + "_" + name)), builder.build(structure));
                this.configuredStructures.put((String)name, (Holder<ConfiguredStructureFeature<C, S>>)holder);
                structureWeights.add(StructureSet.m_210017_((Holder)holder, (int)builder.weight));
            });
            this.configuredStructureFeatureBuilders = null;
            StructurePlacement placement = this.structurePlacement;
            if (placement == null) {
                placement = structure instanceof GelStructure ? new GelStructurePlacement((GelStructure)structure) : new RandomSpreadStructurePlacement(34, 8, RandomSpreadType.LINEAR, 10387312);
            }
            this.structureSet = BuiltinRegistries.m_206388_((Registry)BuiltinRegistries.f_211084_, (ResourceLocation)this.registryName, (Object)new StructureSet(structureWeights, placement));
            this.handled = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this;
        }
    }

    public static class Builder<C extends FeatureConfiguration, S extends StructureFeature<C>> {
        private final ResourceLocation registryName;
        private final Lazy<S> structure;
        private GenerationStep.Decoration generationStep = GenerationStep.Decoration.SURFACE_STRUCTURES;
        private final Map<String, ConfiguredStructureFeatureBuilder<C, S>> configuredStructureFeatureBuilders = new HashMap<String, ConfiguredStructureFeatureBuilder<C, S>>();
        private final Map<String, StructurePieceType> pieceTypes = new HashMap<String, StructurePieceType>();
        @Nullable
        private StructurePlacement structurePlacement = null;

        private Builder(ResourceLocation registryName, Supplier<S> structure) {
            this.registryName = registryName;
            this.structure = Lazy.of(structure);
        }

        public ConfiguredStructureFeatureBuilder<C, S> pushConfigured(C config) {
            return this.pushConfigured("", config);
        }

        public ConfiguredStructureFeatureBuilder<C, S> pushConfigured(String name, C config) {
            return new ConfiguredStructureFeatureBuilder(this, config, name);
        }

        private Builder<C, S> addConfigured(ConfiguredStructureFeatureBuilder<C, S> configuredStructureFeatureBuilder) throws IllegalArgumentException {
            if (this.configuredStructureFeatureBuilders.put(configuredStructureFeatureBuilder.name, configuredStructureFeatureBuilder) != null) {
                throw new IllegalArgumentException(this.errMsg("added a ConfiguredStructureFeature under an existing name \"" + configuredStructureFeatureBuilder.name + "\""));
            }
            return this;
        }

        public Builder<C, S> addPiece(String name, StructurePieceType pieceType) throws IllegalArgumentException {
            if (this.pieceTypes.put(name, pieceType) != null) {
                throw new IllegalArgumentException(this.errMsg("added a StructurePieceType under an existing name \"" + name + "\""));
            }
            return this;
        }

        public Builder<C, S> addPiece(StructurePieceType pieceType) throws IllegalArgumentException {
            return this.addPiece("", pieceType);
        }

        public Builder<C, S> generationStep(GenerationStep.Decoration generationStep) {
            this.generationStep = generationStep;
            return this;
        }

        public Builder<C, S> placement(StructurePlacement structurePlacement) {
            this.structurePlacement = structurePlacement;
            return this;
        }

        public StructureRegistrar<C, S> build() throws IllegalStateException {
            if (this.configuredStructureFeatureBuilders.isEmpty()) {
                throw new IllegalStateException(this.errMsg("has no ConfiguredStructureFeature"));
            }
            if (this.pieceTypes.isEmpty()) {
                throw new IllegalStateException(this.errMsg("has no StructurePieceType"));
            }
            return new StructureRegistrar(this);
        }

        private String errMsg(String msg) {
            return "The StructureRegistrar.Builder \"" + this.registryName + "\" " + msg;
        }
    }

    public static class ConfiguredStructureFeatureBuilder<C extends FeatureConfiguration, S extends StructureFeature<C>> {
        private final Builder<C, S> parentBuilder;
        private final String name;
        private final C config;
        private Supplier<HolderSet<Biome>> biomes = null;
        private boolean adaptNoise = false;
        private Map<MobCategory, Supplier<StructureSpawnOverride>> spawns = new HashMap<MobCategory, Supplier<StructureSpawnOverride>>();
        private int weight = 1;

        private ConfiguredStructureFeatureBuilder(Builder<C, S> parentBuilder, C config, String name) {
            this.parentBuilder = parentBuilder;
            this.config = config;
            this.name = name;
        }

        public final ConfiguredStructureFeatureBuilder<C, S> biomes(List<HolderSet<Biome>> holderSets) {
            this.biomes = () -> holderSets.size() == 1 ? (HolderSet)holderSets.get(0) : HolderSet.m_205800_(holderSets.stream().flatMap(HolderSet::m_203614_).collect(Collectors.toList()));
            return this;
        }

        @SafeVarargs
        public final ConfiguredStructureFeatureBuilder<C, S> biomes(HolderSet<Biome> ... holderSets) {
            return this.biomes(List.of(holderSets));
        }

        @SafeVarargs
        public final ConfiguredStructureFeatureBuilder<C, S> biomes(ResourceKey<Biome> ... biomes) {
            HolderSet[] holderSetArray = new HolderSet[1];
            holderSetArray[0] = HolderSet.m_205800_(Arrays.stream(biomes).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.BIOMES).getHolder(arg_0)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
            return this.biomes(holderSetArray);
        }

        public final ConfiguredStructureFeatureBuilder<C, S> biomes(TagKey<Biome> tagKey) {
            this.biomes = () -> BuiltinRegistries.f_123865_.m_203561_(tagKey);
            return this;
        }

        public final ConfiguredStructureFeatureBuilder<C, S> biomes(StructureConfig.ConfiguredConfig config) {
            this.biomes = () -> config.getBiomes();
            return this;
        }

        public final ConfiguredStructureFeatureBuilder<C, S> spawns(MobCategory category, StructureSpawnOverride spawnPool) {
            this.spawns.put(category, () -> spawnPool);
            return this;
        }

        public final ConfiguredStructureFeatureBuilder<C, S> spawns(MobCategory category, StructureSpawnOverride.BoundingBoxType boundingBoxType, MobSpawnSettings.SpawnerData ... spawns) {
            return this.spawns(category, new StructureSpawnOverride(boundingBoxType, WeightedRandomList.m_146330_((WeightedEntry[])spawns)));
        }

        public final ConfiguredStructureFeatureBuilder<C, S> spawns(StructureConfig.ConfiguredConfig config) {
            for (MobCategory category : MobCategory.values()) {
                this.spawns.put(category, () -> config.getSpawns(category));
            }
            return this;
        }

        public final ConfiguredStructureFeatureBuilder<C, S> noSpawns(StructureSpawnOverride.BoundingBoxType boundingBoxType, MobCategory ... categories) {
            for (MobCategory category : categories.length == 0 ? MobCategory.values() : categories) {
                this.spawns(category, boundingBoxType, new MobSpawnSettings.SpawnerData[0]);
            }
            return this;
        }

        public final ConfiguredStructureFeatureBuilder<C, S> adaptNoise() {
            this.adaptNoise = true;
            return this;
        }

        public final ConfiguredStructureFeatureBuilder<C, S> weight(int weight) {
            this.weight = weight;
            return this;
        }

        public final Builder<C, S> popConfigured() throws IllegalStateException {
            if (this.biomes == null) {
                throw new IllegalStateException(this.errMsg("has no biomes"));
            }
            this.parentBuilder.addConfigured(this);
            return this.parentBuilder;
        }

        private ConfiguredStructureFeature<C, S> build(S structure) {
            return new ConfiguredStructureFeature(structure, this.config, this.biomes.get(), this.adaptNoise, this.spawns.entrySet().stream().filter(e -> ((Supplier)e.getValue()).get() != null).collect(Collectors.toMap(Map.Entry::getKey, e -> (StructureSpawnOverride)((Supplier)e.getValue()).get())));
        }

        private String errMsg(String msg) {
            return this.parentBuilder.errMsg("ConfiguredFeatureBuilder \"" + this.name + "\" " + msg);
        }
    }
}

