/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.structure;

import com.legacy.structure_gel.api.structure.base.IPieceBuilderModifier;
import com.legacy.structure_gel.core.StructureGelMod;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;

public abstract class GelStructure<C extends FeatureConfiguration>
extends StructureFeature<C>
implements IPieceBuilderModifier<C> {
    public GelStructure(Codec<C> codec, PieceGenerator<C> generator) {
        this(codec, PieceGeneratorSupplier.m_197349_((Predicate)PieceGeneratorSupplier.m_197345_((Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG), generator));
    }

    public GelStructure(Codec<C> codec, PieceGeneratorSupplier<C> pieceGeneratorSupplier) {
        this(codec, pieceGeneratorSupplier, PostPlacementProcessor.f_192427_);
    }

    public GelStructure(Codec<C> codec, PieceGeneratorSupplier<C> pieceGeneratorSupplier, PostPlacementProcessor postPlacementProcessor) {
        super(codec, pieceGeneratorSupplier, postPlacementProcessor);
    }

    protected void setPieceGenerator(Function<PieceGeneratorSupplier<C>, PieceGeneratorSupplier<C>> newPieceGeneratorFunction) {
        this.f_191106_ = newPieceGeneratorFunction.apply(this.f_191106_);
    }

    public boolean isLakeProof() {
        return true;
    }

    public int getSeed() {
        if (this.getRegistryName() == null) {
            StructureGelMod.logWarn("The structure {} does not have a registry name. Defaulted to using the structure's Class name. This should be avoided if possible.", this.getClass().getName());
            return Math.abs(this.getClass().getCanonicalName().hashCode());
        }
        return Math.abs(this.getRegistryName().toString().hashCode());
    }

    public float getProbability() {
        return 1.0f;
    }

    public abstract int getSpacing();

    public int getOffset() {
        return this.getSpacing();
    }

    public boolean isAllowedNearWorldSpawn() {
        return false;
    }

    public static void fillBelow(WorldGenLevel level, Random rand, BoundingBox bounds, PiecesContainer pieces, Function<Random, BlockState> blockStateFunc) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int minHeight = level.m_141937_();
        BoundingBox pieceBounds = pieces.m_192756_();
        int maxHeight = pieceBounds.m_162396_();
        for (int x = bounds.m_162395_(); x <= bounds.m_162399_(); ++x) {
            block1: for (int z = bounds.m_162398_(); z <= bounds.m_162401_(); ++z) {
                pos.m_122178_(x, maxHeight, z);
                if (level.m_46859_((BlockPos)pos) || !pieceBounds.m_71051_((Vec3i)pos) || !pieces.m_192751_((BlockPos)pos)) continue;
                for (int y = maxHeight - 1; y > minHeight; --y) {
                    pos.m_142448_(y);
                    if (!level.m_46859_((BlockPos)pos) && !level.m_8055_((BlockPos)pos).m_60767_().m_76332_()) continue block1;
                    level.m_7731_((BlockPos)pos, blockStateFunc.apply(rand), 2);
                }
            }
        }
    }
}

