/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.registry;

import com.legacy.structure_gel.api.structure.GelStructurePlacement;
import com.legacy.structure_gel.api.structure.processor.RandomBlockSwapProcessor;
import com.legacy.structure_gel.api.structure.processor.RandomStateSwapProcessor;
import com.legacy.structure_gel.api.structure.processor.RandomTagSwapProcessor;
import com.legacy.structure_gel.api.structure.processor.RemoveGelStructureProcessor;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.structure.jigsaw.GelSinglePoolElement;
import com.legacy.structure_gel.core.structure.jigsaw.GelStructurePiece;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="structure_gel", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SGStructures {
    @SubscribeEvent
    protected static void onRegistry(RegistryEvent.Register<StructureFeature<?>> event) {
        Processors.init();
        JigsawDeserializers.init();
        StructurePieceTypes.init();
        StructurePlacementTypes.init();
    }

    public static class Processors {
        public static final StructureProcessorType<RemoveGelStructureProcessor> REMOVE_FILLER = () -> RemoveGelStructureProcessor.CODEC;
        public static final StructureProcessorType<RandomBlockSwapProcessor> REPLACE_BLOCK = () -> RandomBlockSwapProcessor.CODEC;
        public static final StructureProcessorType<RandomTagSwapProcessor> REPLACE_TAG = () -> RandomTagSwapProcessor.CODEC;
        public static final StructureProcessorType<RandomStateSwapProcessor> REPLACE_STATE = () -> RandomStateSwapProcessor.CODEC;

        private static void init() {
            Processors.register("remove_filler", REMOVE_FILLER);
            Processors.register("replace_block", REPLACE_BLOCK);
            Processors.register("replace_tag", REPLACE_TAG);
            Processors.register("replace_state", REPLACE_STATE);
        }

        private static <P extends StructureProcessor> void register(String key, StructureProcessorType<P> processorType) {
            Registry.m_122965_((Registry)Registry.f_122891_, (ResourceLocation)StructureGelMod.locate(key), processorType);
        }
    }

    public static class JigsawDeserializers {
        public static final StructurePoolElementType<GelSinglePoolElement> GEL_SINGLE_POOL_ELEMENT = () -> GelSinglePoolElement.CODEC;

        private static void init() {
            JigsawDeserializers.register("gel_single_pool_element", GEL_SINGLE_POOL_ELEMENT);
        }

        private static <P extends StructurePoolElement> void register(String key, StructurePoolElementType<P> jigsawDeserializer) {
            Registry.m_122965_((Registry)Registry.f_122892_, (ResourceLocation)StructureGelMod.locate(key), jigsawDeserializer);
        }
    }

    public static class StructurePieceTypes {
        public static final StructurePieceType GEL_JIGSAW = GelStructurePiece::new;

        private static void init() {
            StructurePieceTypes.register("gel_jigsaw", GEL_JIGSAW);
        }

        private static void register(String key, StructurePieceType pieceType) {
            Registry.m_122965_((Registry)Registry.f_122843_, (ResourceLocation)StructureGelMod.locate(key), (Object)pieceType);
        }
    }

    public static class StructurePlacementTypes {
        public static final StructurePlacementType<GelStructurePlacement> GEL_PLACEMENT = () -> GelStructurePlacement.CODEC;

        private static void init() {
            StructurePlacementTypes.register("gel_placement", GEL_PLACEMENT);
        }

        private static <SP extends StructurePlacement> void register(String key, StructurePlacementType<SP> structurePlacementType) {
            Registry.m_122965_((Registry)Registry.f_205930_, (ResourceLocation)StructureGelMod.locate(key), structurePlacementType);
        }
    }
}

