/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.infernalstudios.infernalexp.entities.BasaltGiantEntity;

public class BasaltGiantModel<T extends BasaltGiantEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("infernalexp", "basalt_giant"), "main");
    private final ModelPart body;
    private final ModelPart torso;
    private final ModelPart torso2;
    private final ModelPart head;
    private final ModelPart jaw;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;

    public BasaltGiantModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.torso = this.body.m_171324_("torso");
        this.torso2 = this.torso.m_171324_("torso_2");
        this.head = this.torso2.m_171324_("head");
        this.jaw = this.head.m_171324_("jaw");
        this.leftArm = this.torso2.m_171324_("left_arm");
        this.rightArm = this.torso2.m_171324_("right_arm");
        this.leftLeg = this.body.m_171324_("left_leg");
        this.rightLeg = this.body.m_171324_("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        PartDefinition body = partDefinition.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition torso = body.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(4, 51).m_171488_(-9.0f, -15.0f, -4.0f, 18.0f, 15.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-36.0f, (float)4.0f));
        PartDefinition torso2 = torso.m_171599_("torso_2", CubeListBuilder.m_171558_().m_171514_(25, 85).m_171488_(-1.0f, -26.0f, 0.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(57, 43).m_171488_(-7.0f, -24.0f, -5.0f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(57, 0).m_171488_(5.0f, -24.0f, 2.0f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(57, 23).m_171488_(6.0f, -26.0f, -5.0f, 3.0f, 11.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(24, 101).m_171488_(-9.0f, -28.0f, 1.0f, 5.0f, 11.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 50).m_171488_(-1.0f, -21.0f, -4.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(57, 43).m_171488_(-10.0f, -17.0f, -7.0f, 20.0f, 17.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-15.0f, (float)-1.0f));
        PartDefinition head = torso2.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(57, 0).m_171488_(-7.0f, -8.0f, -12.0f, 13.0f, 10.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)-4.0f, (float)-7.0f));
        head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(57, 23).m_171488_(-9.0f, 0.0f, -14.0f, 17.0f, 5.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition leftArm = torso2.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(105, 29).m_171488_(-1.0f, -8.0f, -2.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(105, 29).m_171488_(1.0f, -6.0f, 0.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(104, 105).m_171480_().m_171488_(-2.0f, -4.0f, -3.0f, 6.0f, 17.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)12.0f, (float)-11.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.0436f));
        leftArm.m_171599_("left_arm_joint", CubeListBuilder.m_171558_().m_171514_(49, 75).m_171480_().m_171488_(-4.0f, 0.0f, -4.0f, 8.0f, 17.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(88, 80).m_171488_(-5.0f, 17.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)12.0f, (float)0.0f));
        PartDefinition rightArm = torso2.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(105, 23).m_171488_(0.0f, -8.0f, -0.1f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(105, 23).m_171488_(-2.0f, -6.0f, -2.1f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(104, 105).m_171488_(-3.0f, -4.0f, -3.1f, 6.0f, 17.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-13.0f, (float)-11.0f, (float)-0.9f, (float)0.0f, (float)0.0f, (float)0.0436f));
        rightArm.m_171599_("right_arm_joint", CubeListBuilder.m_171558_().m_171514_(49, 75).m_171488_(-4.0f, 0.0f, -4.1f, 8.0f, 17.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(88, 80).m_171480_().m_171488_(-5.0f, 17.0f, -5.1f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition leftLeg = body.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(79, 104).m_171488_(-3.0f, 0.0f, -3.0f, 6.0f, 18.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)-36.0f, (float)4.0f));
        leftLeg.m_171599_("left_leg_joint", CubeListBuilder.m_171558_().m_171514_(46, 101).m_171488_(-4.0f, 0.0f, -4.0f, 8.0f, 19.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)17.0f, (float)0.0f));
        PartDefinition rightLeg = body.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(79, 104).m_171480_().m_171488_(-3.0f, 0.0f, -3.0f, 6.0f, 18.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-5.0f, (float)-36.0f, (float)4.0f));
        rightLeg.m_171599_("right_leg_joint", CubeListBuilder.m_171558_().m_171514_(46, 101).m_171480_().m_171488_(-14.0f, 0.0f, -4.0f, 8.0f, 19.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)10.0f, (float)17.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        int i = ((BasaltGiantEntity)entity).getAttackTimer();
        if (i <= 0) {
            this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.4f + (float)Math.PI)) * 1.0f * limbSwingAmount;
            this.jaw.f_104203_ = 0.0f;
        }
        this.leftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.4f + (float)Math.PI)) * 0.8f * limbSwingAmount;
        this.rightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.4f)) * 0.8f * limbSwingAmount;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.4f)) * 1.0f * limbSwingAmount;
        this.torso2.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.3332f)) * 0.25f * limbSwingAmount;
        this.head.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.1551f)) * 0.15f * limbSwingAmount;
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104301_(matrixStack, buffer, packedLight, packedOverlay);
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        int i = ((BasaltGiantEntity)entityIn).getAttackTimer();
        if (i > 0) {
            this.rightLeg.f_104203_ = -0.9f + 0.9f * Mth.m_14156_((float)((float)i - partialTick), (float)10.0f);
            this.jaw.f_104203_ = 0.375f - 0.375f * Mth.m_14156_((float)((float)i - partialTick), (float)10.0f);
        }
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.f_104203_ = x;
        modelRenderer.f_104204_ = y;
        modelRenderer.f_104205_ = z;
    }
}

